package com.provismet.cobblemon.gimmick.item;

import eu.pb4.polymer.core.api.item.SimplePolymerItem;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PolymerHeldItem extends SimplePolymerItem implements NumericalTooltipItem {
    private final PolymerModelData modelData;
    private final int tooltipLines;

    public PolymerHeldItem (class_1793 settings, class_1792 baseVanillaItem, PolymerModelData modelData) {
        this(settings, baseVanillaItem, modelData, 0);
    }

    public PolymerHeldItem (class_1793 settings, class_1792 baseVanillaItem, PolymerModelData modelData, int tooltipLines) {
        super(settings, baseVanillaItem);
        this.modelData = modelData;
        this.tooltipLines = tooltipLines;
    }

    @Override
    public int getPolymerCustomModelData (class_1799 itemStack, @Nullable class_3222 player) {
        return this.modelData.value();
    }

    @Override
    public void method_7851 (class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        for (int i = 1; i <= this.tooltipLines; ++i) {
            tooltip.add(class_2561.method_43471(this.getTooltipTranslationKey(i)).method_27692(class_124.field_1080));
        }
    }

    @Override
    public String getTooltipTranslationKey (int lineNumber) {
        return this.method_7876() + ".tooltip." + lineNumber;
    }
}
