package com.provismet.cobblemon.gimmick.item.forms;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.gimmick.api.data.component.Fusion;
import com.provismet.cobblemon.gimmick.api.data.registry.EffectsData;
import com.provismet.cobblemon.gimmick.registry.GTGItemDataComponents;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class DataDrivenFusionItem extends AbstractDataDrivenFormItem implements FormChangeFusionItem {
    public DataDrivenFusionItem (class_1793 settings, class_1792 baseVanillaItem, PolymerModelData modelData) {
        super(settings, baseVanillaItem, modelData);
    }

    @Override
    public boolean canBeMerged (class_1799 stack, Pokemon other) {
        Fusion fusionData = stack.method_57824(GTGItemDataComponents.FUSION);
        if (fusionData != null) {
            return fusionData.canBeUsedAsInput(other);
        }
        return false;
    }

    @Override
    public void applyUnplitForme (class_1799 stack, Pokemon pokemon) {
        Fusion fusionData = stack.method_57824(GTGItemDataComponents.FUSION);
        if (fusionData != null) {
            fusionData.removeFeatures(pokemon);

            if (fusionData.unfusionEffect().isPresent()) {
                PokemonEntity entity = pokemon.getEntity();
                if (entity == null) return;

                EffectsData.run(entity, fusionData.unfusionEffect().get());
            }
        }
    }

    @Override
    public void applyFusedForme (class_1799 stack, Pokemon pokemon, Pokemon other) {
        Fusion fusionData = stack.method_57824(GTGItemDataComponents.FUSION);
        if (fusionData != null) {
            fusionData.applyFeatures(pokemon, other);

            if (fusionData.fusionEffect().isPresent()) {
                PokemonEntity entity = pokemon.getEntity();
                if (entity == null) return;

                EffectsData.run(entity, fusionData.fusionEffect().get());
            }
        }
    }

    @Override
    public boolean canUseOnPokemon (class_1799 stack, Pokemon pokemon) {
        Fusion fusionData = stack.method_57824(GTGItemDataComponents.FUSION);

        if (fusionData == null) return false;
        return fusionData.recipient().matches(pokemon);
    }

    @Override
    public boolean canUseOnPokemon (@NotNull Pokemon pokemon) {
        return false;
    }
}
