package com.provismet.cobblemon.gimmick.item.forms;

import com.cobblemon.mod.common.api.callback.PartySelectCallbacks;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.provismet.cobblemon.gimmick.GimmeThatGimmickMain;
import kotlin.Unit;
import net.minecraft.class_1271;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public interface FormChangeFusionItem extends FormChangeItem {
    @Nullable
    @Override
    default class_1271<class_1799> applyToPokemon (@NotNull class_3222 player, @NotNull class_1799 stack, @NotNull Pokemon pokemon) {
        if (!this.canUseOnPokemon(stack, pokemon)) return class_1271.method_22431(stack);

        if (pokemon.getPersistentData().method_10545("fusion_forme")) { // Split
            try {
                Pokemon other = Pokemon.Companion.loadFromNBT(player.method_37908().method_30349(), pokemon.getPersistentData().method_10562("fusion_forme"));
                PlayerExtensionsKt.party(player).add(other);
            }
            catch (Exception e) {
                GimmeThatGimmickMain.LOGGER.error(
                    "Failed to decode fused pokemon to give back to {}. Pokemon NBT is as follows: {}",
                    player.method_5477().getString(),
                    pokemon.getPersistentData().method_10562("fusion_forme").toString()
                );
                GimmeThatGimmickMain.LOGGER.error("Error is as follows: ", e);
            }
            this.applyUnplitForme(stack, pokemon);
            pokemon.getPersistentData().method_10551("fusion_forme");
        }
        else { // Merge
            PartySelectCallbacks.INSTANCE.createFromPokemon(
                player,
                PlayerExtensionsKt.party(player).toGappyList().stream().filter(Objects::nonNull).toList(),
                otherPokemon -> this.isSuitableForMerging(stack, otherPokemon),
                otherPokemon -> {
                    if (player.method_6047().equals(stack) || player.method_6079().equals(stack)) {
                        return this.merge(player, stack, pokemon, otherPokemon);
                    }
                    return Unit.INSTANCE;
                }
            );
        }
        pokemon.getAnyChangeObservable().emit(pokemon);
        return class_1271.method_22427(stack);
    }

    default Unit merge (class_3222 player, class_1799 stack, Pokemon pokemon, Pokemon other) {
        this.applyFusedForme(stack, pokemon, other);
        class_2487 otherPokemonNbt = other.saveToNBT(player.method_37908().method_30349(), new class_2487());
        pokemon.getPersistentData().method_10566("fusion_forme", otherPokemonNbt);
        this.postMerge(player, stack, pokemon, other);
        PlayerExtensionsKt.party(player).remove(other);

        if (other.getEntity() != null) {
            other.getEntity().method_31472();
        }

        return Unit.INSTANCE;
    }

    private boolean isSuitableForMerging (class_1799 stack, Pokemon other) {
        return other.heldItem().method_7960() && this.canBeMerged(stack, other);
    }

    default void postMerge (class_3222 player, class_1799 stack, Pokemon pokemon, Pokemon absorbed) {
        player.method_7353(class_2561.method_43469("message.overlay.gimme-that-gimmick.fusion", pokemon.getDisplayName(), absorbed.getDisplayName()), true);
    }

    boolean canBeMerged (class_1799 stack, Pokemon other);
    void applyUnplitForme (class_1799 stack, Pokemon pokemon);
    void applyFusedForme (class_1799 stack, Pokemon pokemon, Pokemon other);
}
