package com.provismet.cobblemon.gimmick.item.forms;

import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.PokemonInteractContext;
import com.cobblemon.mod.common.api.callback.PartySelectCallbacks;
import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.ItemStackExtensionsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.provismet.cobblemon.gimmick.GimmeThatGimmickMain;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import net.minecraft.class_1271;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public interface FormChangeItem extends PokemonSelectingItem {
    @Override
    default @NotNull class_1271<class_1799> interactGeneral (@NotNull class_3222 player, @NotNull class_1799 itemStack) {
        List<Pokemon> partyList = CollectionsKt.toList(PlayerExtensionsKt.party(player));
        if (partyList.isEmpty()) return class_1271.method_22431(itemStack);

        PartySelectCallbacks.INSTANCE.createFromPokemon(
            player,
            partyList,
            pokemon -> this.canUseOnPokemon(itemStack, pokemon),
            pokemon -> {
                if (ItemStackExtensionsKt.isHeld(itemStack, player)) {
                    this.applyToPokemon(player, itemStack, pokemon);
                    CobblemonCriteria.INSTANCE.getPOKEMON_INTERACT().trigger(player, new PokemonInteractContext(pokemon.getSpecies().resourceIdentifier, class_7923.field_41178.method_10221(itemStack.method_7909())));
                }
                return Unit.INSTANCE;
            }
        );

        return class_1271.method_22427(itemStack);
    }

    default boolean canUseOnPokemon (class_1799 stack, Pokemon pokemon) {
        GimmeThatGimmickMain.LOGGER.info("checked default?");
        return this.canUseOnPokemon(pokemon);
    }
}
