package com.provismet.cobblemon.gimmick.item.forms;

import com.cobblemon.mod.common.api.callback.PartySelectCallbacks;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import kotlin.Unit;
import net.minecraft.class_1271;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;

public interface FormChangeSelectionItem extends FormChangeItem {
    @Nullable
    @Override
    default class_1271<class_1799> applyToPokemon (@NotNull class_3222 player, @NotNull class_1799 stack, @NotNull Pokemon pokemon) {
        if (!this.canUseOnPokemon(stack, pokemon)) return class_1271.method_22431(stack);

        List<Pokemon> forms = pokemon.getSpecies()
            .getForms()
            .stream()
            .filter(Objects::nonNull)
            .filter(form -> !form.formOnlyShowdownId().equals(pokemon.getForm().formOnlyShowdownId()))
            .map(form -> {
                Pokemon copy = BattlePokemon.Companion.safeCopyOf(pokemon).getEffectedPokemon();
                this.applyForm(player, copy, form);
                copy.setNickname(class_2561.method_43470(form.getName()));
                return copy;
            })
            .toList();

        PartySelectCallbacks.INSTANCE.createFromPokemon(
            player,
            class_2561.method_43471("gui.title.gimme-that-gimmick.form"),
            forms,
            form -> true,
            selectedForm -> {
                this.applyForm(player, pokemon, selectedForm.getForm());
                this.postFormChange(player, stack, pokemon);
                return Unit.INSTANCE;
            }
        );
        return class_1271.method_22427(stack);
    }

    void applyForm (class_3222 player, Pokemon pokemon, FormData form);

    default void postFormChange (class_3222 player, class_1799 stack, Pokemon pokemon) {
        player.method_7353(class_2561.method_43469("message.overlay.gimme-that-gimmick.form", pokemon.getDisplayName(), pokemon.getForm().getName()), true);
    }
}
