package com.provismet.cobblemon.gimmick.item.forms;

import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.gimmick.GimmeThatGimmickMain;
import com.provismet.cobblemon.gimmick.api.data.registry.EffectsData;
import com.provismet.cobblemon.gimmick.item.PolymerPokemonSelectingBlockItem;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1271;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class MeteoriteItem extends PolymerPokemonSelectingBlockItem implements FormChangeSelectionItem {
    public MeteoriteItem (class_2248 block, class_1793 settings, class_1792 baseVanillaItem, PolymerModelData modelData) {
        super(block, settings, baseVanillaItem, modelData, 1);
    }

    @Override
    public @Nullable class_1271<class_1799> applyToPokemon (@NotNull class_3222 player, @NotNull class_1799 stack, @NotNull Pokemon pokemon) {
        GimmeThatGimmickMain.LOGGER.info("applyToPokemon");
        return FormChangeSelectionItem.super.applyToPokemon(player, stack, pokemon);
    }

    @Override
    public void applyForm (class_3222 player, Pokemon pokemon, FormData form) {
        String formName = form == null ? "normal" : form.formOnlyShowdownId();
        new StringSpeciesFeature("meteorite_forme", formName).apply(pokemon);

        if (pokemon.getEntity() != null) {
            List<String> effects = List.of("meteorite_" + formName, "meteorite");
            for (String effectName : effects) {
                class_2960 id = GimmeThatGimmickMain.identifier(effectName);
                if (EffectsData.get(pokemon.getEntity().method_56673(), id).isPresent()) {
                    EffectsData.run(pokemon.getEntity(), id);
                    break;
                }
            }
        }
    }

    @Override
    public boolean canUseOnPokemon (@NotNull Pokemon pokemon) {
        return pokemon.getSpecies().getResourceIdentifier().toString().equals("cobblemon:deoxys");
    }
}
