package com.provismet.cobblemon.gimmick.item.forms;

import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.gimmick.GimmeThatGimmickMain;
import com.provismet.cobblemon.gimmick.api.data.registry.EffectsData;
import com.provismet.cobblemon.gimmick.item.PolymerPokemonSelectingItem;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class NSolarizerItem extends PolymerPokemonSelectingItem implements FormChangeFusionItem {
    public NSolarizerItem (class_1793 settings, class_1792 baseVanillaItem, PolymerModelData modelData) {
        super(settings, baseVanillaItem, modelData, 1);
    }

    @Override
    public boolean canBeMerged (class_1799 stack, Pokemon other) {
        return other.getSpecies().getResourceIdentifier().toString().equals("cobblemon:solgaleo");
    }

    @Override
    public void applyUnplitForme (class_1799 stack, Pokemon pokemon) {
        new StringSpeciesFeature("prism_fusion", "none").apply(pokemon);

        if (pokemon.getEntity() != null) {
            EffectsData.run(pokemon.getEntity(), GimmeThatGimmickMain.identifier("n_solarizer_unfuse"));
        }
    }

    @Override
    public void applyFusedForme (class_1799 stack, Pokemon pokemon, Pokemon other) {
        new StringSpeciesFeature("prism_fusion", "dusk").apply(pokemon);

        if (pokemon.getEntity() != null) {
            EffectsData.run(pokemon.getEntity(), GimmeThatGimmickMain.identifier("n_solarizer_fuse"));
        }
    }

    @Override
    public boolean canUseOnPokemon (@NotNull Pokemon pokemon) {
        return pokemon.getSpecies().getResourceIdentifier().toString().equals("cobblemon:necrozma");
    }
}
