package com.provismet.cobblemon.gimmick.item.forms;

import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.gimmick.GimmeThatGimmickMain;
import com.provismet.cobblemon.gimmick.api.data.registry.EffectsData;
import com.provismet.cobblemon.gimmick.item.PolymerPokemonSelectingItem;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class RotomCatalogItem extends PolymerPokemonSelectingItem implements FormChangeSelectionItem {
    public RotomCatalogItem (class_1793 settings, class_1792 polymerItem, PolymerModelData modelData) {
        super(settings, polymerItem, modelData, 1);
    }

    @Override
    public boolean canUseOnPokemon (@NotNull Pokemon pokemon) {
        return pokemon.getSpecies().getResourceIdentifier().toString().equals("cobblemon:rotom");
    }

    @Override
    public void applyForm (class_3222 player, Pokemon pokemon, FormData form) {
        String appliance = (form == null || form.formOnlyShowdownId().equals("normal")) ? "none" : form.formOnlyShowdownId();
        new StringSpeciesFeature("appliance", appliance).apply(pokemon);

        if (pokemon.getEntity() != null) {
            if (pokemon.getEntity() != null) {
                List<String> effects = List.of("rotom_catalog_" + appliance, "rotom_catalog");
                for (String effectName : effects) {
                    class_2960 id = GimmeThatGimmickMain.identifier(effectName);
                    if (EffectsData.get(pokemon.getEntity().method_56673(), id).isPresent()) {
                        EffectsData.run(pokemon.getEntity(), id);
                        break;
                    }
                }
            }
        }
    }
}
