package com.provismet.cobblemon.gimmick.registry;

import com.provismet.cobblemon.gimmick.GimmeThatGimmickMain;
import com.provismet.cobblemon.gimmick.util.tag.GTGEnchantmentTags;
import com.provismet.cobblemon.gimmick.util.tag.GTGItemTags;
import com.provismet.lilylib.container.EnchantmentContainer;
import java.util.function.Consumer;
import net.minecraft.class_1887;
import net.minecraft.class_3902;
import net.minecraft.class_7891;
import net.minecraft.class_9274;
import net.minecraft.class_9331;

public abstract class GTGEnchantments {
    public static final EnchantmentContainer KEY_STONE = createGimmick("key_stone", GTGEnchantmentComponents.KEY_STONE);
    public static final EnchantmentContainer Z_RING = createGimmick("z-power", GTGEnchantmentComponents.Z_RING);
    public static final EnchantmentContainer DYNAMAX_BAND = createGimmick("dynamax", GTGEnchantmentComponents.DYNAMAX_BAND);
    public static final EnchantmentContainer TERA_ORB = createGimmick("terastal", GTGEnchantmentComponents.TERA_ORB);

    private static EnchantmentContainer createGimmick (String name, class_9331<class_3902> gimmickComponent) {
        return new EnchantmentContainer(
            GimmeThatGimmickMain.identifier(name),
            (itemLookup, enchantmentLookup, damageLookup, blockLookup) -> class_1887.method_60030(
                class_1887.method_58442(
                    itemLookup.method_46735(GTGItemTags.GIMMICK_ENCHANTABLE),
                    1,
                    1,
                    class_1887.method_58440(30),
                    class_1887.method_58440(30),
                    7,
                    class_9274.field_49216
                )
            ).method_60062(
                gimmickComponent
            ).method_60061(
                enchantmentLookup.method_46735(GTGEnchantmentTags.KEY_ITEM)
            )
        );
    }

    public static void bootstrap (class_7891<class_1887> registerable) {
        Consumer<EnchantmentContainer> register = container -> registerable.method_46838(container.getKey(), container.getBuilder(registerable).method_60060(container.getKey().method_29177()));

        register.accept(KEY_STONE);
        register.accept(Z_RING);
        register.accept(DYNAMAX_BAND);
        register.accept(TERA_ORB);
    }
}
