package com.provismet.cobblemon.gimmick.util;

import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.api.types.tera.TeraType;
import com.cobblemon.mod.common.api.types.tera.elemental.ElementalTypeTeraType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.provismet.cobblemon.gimmick.item.zmove.TypedZCrystalItem;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_268;
import net.minecraft.class_2995;
import net.minecraft.class_3218;

public class GlowHandler {
    public static void applyDynamaxGlow(PokemonEntity pokemonEntity) {
        if (pokemonEntity.method_37908() instanceof class_3218 serverLevel) {
            pokemonEntity.method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE, 0, false, false));
            class_2995 scoreboard = serverLevel.method_14170();

            String teamName;
            class_124 teamColour;
            if (pokemonEntity.getPokemon().getSpecies().getName().equalsIgnoreCase("calyrex")) {
                teamName = "glow_dynamax_blue";
                teamColour = class_124.field_1078;
            } else {
                teamName = "glow_dynamax_red";
                teamColour = class_124.field_1061;
            }

            class_268 team = scoreboard.method_1153(teamName);
            if (team == null) {
                team = scoreboard.method_1171(teamName);
                team.method_1141(teamColour);
            }
            scoreboard.method_1172(pokemonEntity.method_5820(), team);
        }
    }

    public static void applyTeraGlow (PokemonEntity pokemon) {
        if (pokemon.method_37908() instanceof class_3218 serverLevel) {
            pokemon.method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE, 0, false, false));
            class_2995 scoreboard = serverLevel.method_14170();
            String teamName = "glow_tera_" + pokemon.getPokemon().getTeraType().showdownId();

            class_268 team = scoreboard.method_1153(teamName);

            class_124 color = getGlowForTera(pokemon.getPokemon().getTeraType());
            if (team == null) {
                team = scoreboard.method_1171(teamName);
                team.method_1141(color);
            }

            scoreboard.method_1172(pokemon.method_5820(), team);
        }
    }

    public static void applyZGlow (PokemonEntity pokemon) {
        ElementalType type;
        if (pokemon.getPokemon().heldItem().method_7909() instanceof TypedZCrystalItem crystal) {
            type = crystal.type;
        } else { // Only possible if the crystal is a custom item not controlled by GTG.
            type = pokemon.getPokemon().getPrimaryType();
        }

        if (pokemon.method_37908() instanceof class_3218 serverLevel) {
            pokemon.method_6092(new class_1293(class_1294.field_5912, 140, 0, false, false));
            class_2995 scoreboard = serverLevel.method_14170();
            String teamName = "glow_type_" + type.getName().toLowerCase(Locale.ROOT);

            class_268 team = scoreboard.method_1153(teamName);

            class_124 color = getGlowForElemental(type);
            if (team == null) {
                team = scoreboard.method_1171(teamName);
                team.method_1141(color);
            }

            scoreboard.method_1172(pokemon.method_5820(), team);
        }
    }

    private static class_124 getGlowForTera(TeraType teraType) {
        if (teraType instanceof ElementalTypeTeraType elementalTera) {
            return getGlowForElemental(elementalTera.getType());
        }
        return class_124.field_1068;
    }

    private static class_124 getGlowForElemental(ElementalType type) {
        if (type.equals(ElementalTypes.INSTANCE.getBUG())) return class_124.field_1077;
        if (type.equals(ElementalTypes.INSTANCE.getDARK())) return class_124.field_1074;
        if (type.equals(ElementalTypes.INSTANCE.getDRAGON())) return class_124.field_1058;
        if (type.equals(ElementalTypes.INSTANCE.getELECTRIC())) return class_124.field_1054;
        if (type.equals(ElementalTypes.INSTANCE.getFAIRY())) return class_124.field_1076;
        if (type.equals(ElementalTypes.INSTANCE.getFIGHTING())) return class_124.field_1079;
        if (type.equals(ElementalTypes.INSTANCE.getFIRE())) return class_124.field_1061;
        if (type.equals(ElementalTypes.INSTANCE.getFLYING())) return class_124.field_1080;
        if (type.equals(ElementalTypes.INSTANCE.getGHOST())) return class_124.field_1064;
        if (type.equals(ElementalTypes.INSTANCE.getGRASS())) return class_124.field_1060;
        if (type.equals(ElementalTypes.INSTANCE.getGROUND())) return class_124.field_1079;
        if (type.equals(ElementalTypes.INSTANCE.getICE())) return class_124.field_1075;
        if (type.equals(ElementalTypes.INSTANCE.getNORMAL())) return class_124.field_1068;
        if (type.equals(ElementalTypes.INSTANCE.getPOISON())) return class_124.field_1064;
        if (type.equals(ElementalTypes.INSTANCE.getPSYCHIC())) return class_124.field_1076;
        if (type.equals(ElementalTypes.INSTANCE.getROCK())) return class_124.field_1063;
        if (type.equals(ElementalTypes.INSTANCE.getSTEEL())) return class_124.field_1080;
        if (type.equals(ElementalTypes.INSTANCE.getWATER())) return class_124.field_1078;
        return class_124.field_1068;
    }
}
