/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.gimmick.api.data.registry.form;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.dispatch.UntilDispatch;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.cobblemon.gimmick.api.data.PokemonFeatures;
import com.provismet.cobblemon.gimmick.api.data.registry.EffectsData;
import com.provismet.cobblemon.gimmick.registry.GTGDynamicRegistryKeys;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public record BattleForm(PokemonTransformation defaultForm, Map<String, PokemonTransformation> forms) {
    public static final Codec<BattleForm> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PokemonTransformation.CODEC.fieldOf("default").forGetter(BattleForm::defaultForm), (App)Codec.unboundedMap((Codec)Codec.STRING, PokemonTransformation.CODEC).fieldOf("forms").forGetter(BattleForm::forms)).apply((Applicative)instance, BattleForm::new));

    public static class_5321<BattleForm> key(class_2960 speciesId) {
        return class_5321.method_29179(GTGDynamicRegistryKeys.BATTLE_FORM, (class_2960)speciesId);
    }

    public static class_5321<BattleForm> key(Pokemon pokemon) {
        return BattleForm.key(pokemon.getSpecies().getResourceIdentifier());
    }

    public void applyForm(PokemonEntity pokemon, @Nullable PokemonEntity opponent, PokemonBattle battle, String formName) {
        PokemonTransformation toApply;
        if (this.forms.containsKey(formName)) {
            toApply = this.forms.get(formName);
        } else if (formName.equalsIgnoreCase(pokemon.getPokemon().getSpecies().showdownId())) {
            toApply = this.defaultForm;
        } else {
            return;
        }
        battle.dispatchToFront(dispatcher -> {
            toApply.features.apply(pokemon.getPokemon());
            return new UntilDispatch(() -> true);
        });
        toApply.effectsData.ifPresent(effectId -> EffectsData.run(pokemon, opponent, battle, effectId));
    }

    public record PokemonTransformation(PokemonFeatures features, Optional<class_2960> effectsData) {
        public static final Codec<PokemonTransformation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PokemonFeatures.CODEC.fieldOf("features").forGetter(PokemonTransformation::features), (App)class_2960.field_25139.optionalFieldOf("effect").forGetter(PokemonTransformation::effectsData)).apply((Applicative)instance, PokemonTransformation::new));

        public static PokemonTransformation of(PokemonFeatures features) {
            return new PokemonTransformation(features, Optional.empty());
        }

        public static PokemonTransformation of(PokemonFeatures features, class_2960 effectData) {
            return new PokemonTransformation(features, Optional.of(effectData));
        }
    }
}

