/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.gimmick.handlers;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleStartedPostEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedPreEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.FormeChangeEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.MegaEvolutionEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.TerastallizationEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.ZMoveUsedEvent;
import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonSentPostEvent;
import com.cobblemon.mod.common.api.events.pokemon.healing.PokemonHealedEvent;
import com.cobblemon.mod.common.api.item.HealingSource;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.dispatch.UntilDispatch;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.battle.BattleTransformPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleUpdateTeamPokemonPacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.AbilityUpdatePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.properties.AspectPropertyType;
import com.cobblemon.mod.common.pokemon.properties.UnaspectPropertyType;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.provismet.cobblemon.gimmick.GimmeThatGimmickMain;
import com.provismet.cobblemon.gimmick.api.data.registry.EffectsData;
import com.provismet.cobblemon.gimmick.api.data.registry.form.BattleForm;
import com.provismet.cobblemon.gimmick.api.gimmick.GimmickCheck;
import com.provismet.cobblemon.gimmick.api.gimmick.Gimmicks;
import com.provismet.cobblemon.gimmick.config.Options;
import com.provismet.cobblemon.gimmick.handlers.DynamaxEventHandler;
import com.provismet.cobblemon.gimmick.item.forms.GenericFormChangeHeldItem;
import com.provismet.cobblemon.gimmick.item.zmove.TypedZCrystalItem;
import com.provismet.cobblemon.gimmick.registry.GTGDynamicRegistries;
import com.provismet.cobblemon.gimmick.registry.GTGDynamicRegistryKeys;
import com.provismet.cobblemon.gimmick.registry.GTGStatusEffects;
import com.provismet.cobblemon.gimmick.util.GlowHandler;
import com.provismet.cobblemon.gimmick.util.MegaHelper;
import com.provismet.cobblemon.gimmick.util.tag.GTGBlockTags;
import com.provismet.cobblemon.gimmick.util.tag.GTGItemTags;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import kotlin.Unit;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_6880;

public abstract class CobblemonEventHandler {
    public static void register() {
        CobblemonEvents.MEGA_EVOLUTION.subscribe(Priority.NORMAL, CobblemonEventHandler::megaEvolutionUsed);
        CobblemonEvents.TERASTALLIZATION.subscribe(Priority.NORMAL, CobblemonEventHandler::terrastallizationUsed);
        CobblemonEvents.ZPOWER_USED.subscribe(Priority.NORMAL, CobblemonEventHandler::zmoveUsed);
        CobblemonEvents.BATTLE_STARTED_PRE.subscribe(Priority.NORMAL, CobblemonEventHandler::battleStarted);
        CobblemonEvents.BATTLE_STARTED_POST.subscribe(Priority.NORMAL, CobblemonEventHandler::battleEndHandler);
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.NORMAL, CobblemonEventHandler::fixTeraTyping);
        CobblemonEvents.HELD_ITEM_PRE.subscribe(Priority.NORMAL, CobblemonEventHandler::heldItemFormChange);
        CobblemonEvents.POKEMON_HEALED.subscribe(Priority.NORMAL, CobblemonEventHandler::pokemonHealed);
        CobblemonEvents.POKEMON_SENT_POST.subscribe(Priority.NORMAL, CobblemonEventHandler::pokemonSentOut);
        CobblemonEvents.FORME_CHANGE.subscribe(Priority.NORMAL, CobblemonEventHandler::formeChanges);
        UseEntityCallback.EVENT.register(CobblemonEventHandler::megaEvolveOutside);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static class_1269 megaEvolveOutside(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 entityHitResult) {
        class_3222 serverPlayer;
        PokemonEntity pokemonEntity;
        block14: {
            block13: {
                if (player.method_5715() || !(entity instanceof PokemonEntity)) break block13;
                pokemonEntity = (PokemonEntity)entity;
                if (GimmickCheck.isUnenchantedKeyStone(player.method_5998(hand))) break block14;
            }
            return class_1269.field_5811;
        }
        if (pokemonEntity.method_35057() != player) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.overlay.gimme-that-gimmick.mega_not_yours").method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        if (pokemonEntity.isBattling() || player instanceof class_3222 && PlayerExtensionsKt.isInBattle((class_3222)(serverPlayer = (class_3222)player))) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.overlay.gimme-that-gimmick.mega_in_battle").method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        Pokemon pokemon = pokemonEntity.getPokemon();
        if (pokemon.getPersistentData().method_10573("last_mega", 4) && Math.abs(world.method_8510() - pokemon.getPersistentData().method_10537("last_mega")) < 20L) {
            return class_1269.field_5814;
        }
        player.method_23667(hand, true);
        if (!MegaHelper.hasMegaAspect(pokemon)) {
            if (!Options.shouldAllowMultipleOutOfCombatMegas() && MegaHelper.checkForMega((class_3222)player)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.overlay.gimme-that-gimmick.mega_exists").method_27692(class_124.field_1061), true);
                return class_1269.field_5812;
            }
            if (!MegaHelper.megaEvolve(pokemon, false)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.overlay.gimme-that-gimmick.no_stone").method_27692(class_124.field_1061), true);
                return class_1269.field_5814;
            }
            List<String> prioritisedEffects = List.of("mega_evolution_outside" + pokemon.showdownId(), "mega_evolution_outside");
            for (String id : prioritisedEffects) {
                Optional<class_6880.class_6883<EffectsData>> effectsData = EffectsData.get(pokemonEntity.method_56673(), GimmeThatGimmickMain.identifier(id));
                if (!effectsData.isPresent()) continue;
                ((EffectsData)effectsData.get().comp_349()).run(pokemonEntity);
                break;
            }
        } else {
            MegaHelper.megaDevolve(pokemon);
        }
        pokemon.getPersistentData().method_10544("last_mega", world.method_8510());
        return class_1269.field_5812;
    }

    private static Unit zmoveUsed(ZMoveUsedEvent zMoveUsedEvent) {
        PokemonEntity pokemonEntity = zMoveUsedEvent.getPokemon().getEntity();
        if (pokemonEntity != null) {
            String string;
            class_1792 class_17922;
            if (Options.shouldApplyBasicZGlow()) {
                GlowHandler.applyZGlow(pokemonEntity);
            }
            if ((class_17922 = zMoveUsedEvent.getPokemon().getEffectedPokemon().heldItem().method_7909()) instanceof TypedZCrystalItem) {
                TypedZCrystalItem crystal = (TypedZCrystalItem)class_17922;
                string = crystal.type.getName();
            } else {
                string = zMoveUsedEvent.getPokemon().getEffectedPokemon().getPrimaryType().getName();
            }
            String type = string;
            String species = zMoveUsedEvent.getPokemon().getEffectedPokemon().getSpecies().showdownId();
            List<String> prioritisedEffects = List.of("z_move_" + species + "_" + type, "z_move_" + species, "z_move_" + type, "z_move");
            for (String effectName : prioritisedEffects) {
                class_2960 key = GimmeThatGimmickMain.identifier(effectName);
                Optional<class_6880.class_6883<EffectsData>> effect = EffectsData.get(pokemonEntity.method_56673(), key);
                if (!effect.isPresent()) continue;
                Optional<PokemonEntity> other = StreamSupport.stream(zMoveUsedEvent.getBattle().getActivePokemon().spliterator(), false).map(ActiveBattlePokemon::getBattlePokemon).filter(active -> zMoveUsedEvent.getPokemon().getFacedOpponents().contains(active)).filter(Objects::nonNull).map(BattlePokemon::getEntity).filter(Objects::nonNull).findAny();
                ((EffectsData)effect.get().comp_349()).run(pokemonEntity, other.orElse(null), zMoveUsedEvent.getBattle());
                break;
            }
        }
        return Unit.INSTANCE;
    }

    private static Unit battleStarted(BattleStartedPreEvent battleEvent) {
        for (BattleActor actor : battleEvent.getBattle().getActors()) {
            if (!(actor instanceof PlayerBattleActor)) continue;
            actor.getPokemonList().forEach(battlePokemon -> CobblemonEventHandler.resetBattleForms(battlePokemon.getEffectedPokemon()));
        }
        for (class_3222 player : battleEvent.getBattle().getPlayers()) {
            CobblemonEventHandler.resetBattlePokemon(player);
            GeneralPlayerData data = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(player);
            boolean hasKeyStone = false;
            boolean hasZRing = false;
            boolean hasDynamax = false;
            boolean hasTeraOrb = false;
            class_1799 teraOrb = null;
            for (class_1799 item : player.method_56675()) {
                if (Options.enabledMegaEvolution() && GimmickCheck.isKeyStone(item)) {
                    hasKeyStone = true;
                }
                if (Options.enabledZMoves() && GimmickCheck.isZRing(item)) {
                    hasZRing = true;
                }
                if (Options.enabledDynamax() && GimmickCheck.isDynamaxBand(item)) {
                    hasDynamax = true;
                }
                if (!Options.enabledTerastal() || !GimmickCheck.isTeraOrb(item)) continue;
                hasTeraOrb = true;
                teraOrb = item;
            }
            if (hasTeraOrb) {
                PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
                for (Pokemon partyMons : playerPartyStore) {
                    if (!partyMons.getSpecies().getName().equals("Terapagos")) continue;
                    teraOrb.method_7974(0);
                    break;
                }
            }
            if (hasKeyStone) {
                data.getKeyItems().add(Gimmicks.KEY_STONE);
            } else {
                data.getKeyItems().remove(Gimmicks.KEY_STONE);
            }
            if (hasZRing) {
                data.getKeyItems().add(Gimmicks.Z_RING);
            } else {
                data.getKeyItems().remove(Gimmicks.Z_RING);
            }
            boolean bl = hasDynamax = hasDynamax && (!Options.isPowerSpotRequired() || CobblemonEventHandler.isPowerSpotNearby(player, Options.getPowerSpotRange()));
            if (hasDynamax && !hasTeraOrb) {
                data.getKeyItems().add(Gimmicks.DYNAMAX_BAND);
            } else {
                data.getKeyItems().remove(Gimmicks.DYNAMAX_BAND);
            }
            if (hasTeraOrb) {
                data.getKeyItems().add(Gimmicks.TERA_ORB);
                continue;
            }
            data.getKeyItems().remove(Gimmicks.TERA_ORB);
        }
        return Unit.INSTANCE;
    }

    private static Unit battleEndHandler(BattleStartedPostEvent battleStartedPostEvent) {
        battleStartedPostEvent.getBattle().getOnEndHandlers().add(battle -> {
            battle.getPlayers().forEach(CobblemonEventHandler::resetBattlePokemon);
            return Unit.INSTANCE;
        });
        return Unit.INSTANCE;
    }

    private static boolean isPowerSpotNearby(class_3222 player, int radius) {
        class_2338 playerPos = player.method_24515();
        class_3218 world = player.method_51469();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 checkPos = playerPos.method_10069(dx, dy, dz);
                    if (!world.method_8320(checkPos).method_26164(GTGBlockTags.POWER_SPOTS)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static Unit megaEvolutionUsed(MegaEvolutionEvent megaEvent) {
        megaEvent.getBattle().dispatchToFront(() -> {
            MegaHelper.megaEvolve(megaEvent.getPokemon().getEffectedPokemon(), true);
            megaEvent.getPokemon().sendUpdate();
            CobblemonEventHandler.updatePokemonPackets(megaEvent.getBattle(), megaEvent.getPokemon(), true);
            return new UntilDispatch(() -> true);
        });
        Pokemon pokemon = megaEvent.getPokemon().getEffectedPokemon();
        if (pokemon.getEntity() != null) {
            List<String> prioritisedEffects = List.of("mega_evolution_" + megaEvent.getPokemon().getEffectedPokemon().showdownId(), "mega_evolution");
            for (String effectName : prioritisedEffects) {
                class_2960 key = GimmeThatGimmickMain.identifier(effectName);
                Optional<class_6880.class_6883<EffectsData>> effect = EffectsData.get(pokemon.getEntity().method_56673(), key);
                if (!effect.isPresent()) continue;
                Optional<PokemonEntity> other = StreamSupport.stream(megaEvent.getBattle().getActivePokemon().spliterator(), false).map(ActiveBattlePokemon::getBattlePokemon).filter(active -> megaEvent.getPokemon().getFacedOpponents().contains(active)).filter(Objects::nonNull).map(BattlePokemon::getEntity).filter(Objects::nonNull).findAny();
                ((EffectsData)effect.get().comp_349()).run(pokemon.getEntity(), other.orElse(null), megaEvent.getBattle());
                break;
            }
        }
        return Unit.INSTANCE;
    }

    private static Unit terrastallizationUsed(TerastallizationEvent terastallizationEvent) {
        Pokemon pokemon = terastallizationEvent.getPokemon().getEffectedPokemon();
        class_3222 player = pokemon.getOwnerPlayer();
        if (Options.canBreakTeraOrb() && player != null) {
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            boolean hasTerapagos = false;
            for (Pokemon partyMons : playerPartyStore) {
                if (!partyMons.getSpecies().getName().equals("Terapagos")) continue;
                hasTerapagos = true;
                break;
            }
            if (!hasTerapagos) {
                for (class_1799 item : player.method_56675()) {
                    if (!item.method_31573(GTGItemTags.BREAKABLE_TERA_ORBS)) continue;
                    item.method_7974(item.method_7919() + 20);
                    break;
                }
            }
        }
        if (pokemon.getSpecies().getName().equals("Terapagos")) {
            terastallizationEvent.getBattle().dispatchToFront(() -> {
                new StringSpeciesFeature("tera_form", "stellar").apply(pokemon);
                CobblemonEventHandler.updatePokemonPackets(terastallizationEvent.getBattle(), terastallizationEvent.getPokemon(), false);
                return new UntilDispatch(() -> true);
            });
        }
        if (pokemon.getSpecies().getName().equals("Ogerpon")) {
            terastallizationEvent.getBattle().dispatchToFront(() -> {
                new FlagSpeciesFeature("embody_aspect", true).apply(pokemon);
                CobblemonEventHandler.updatePokemonPackets(terastallizationEvent.getBattle(), terastallizationEvent.getPokemon(), false);
                return new UntilDispatch(() -> true);
            });
        }
        if (pokemon.getEntity() != null) {
            if (Options.shouldApplyBasicTeraGlow()) {
                GlowHandler.applyTeraGlow(pokemon.getEntity());
                pokemon.getPersistentData().method_10556("tera", true);
            }
            String teraAspect = "tera_" + pokemon.getTeraType().showdownId();
            pokemon.getPersistentData().method_10582("tera_aspect", teraAspect);
            terastallizationEvent.getBattle().dispatchToFront(() -> {
                AspectPropertyType.INSTANCE.fromString(teraAspect).apply(pokemon);
                return new UntilDispatch(() -> true);
            });
            List<String> prioritisedEffects = List.of("terastallization_" + pokemon.getSpecies().showdownId() + "_" + pokemon.getTeraType().showdownId(), "terastallization_" + pokemon.getSpecies().showdownId(), "terastallization_" + pokemon.getTeraType().showdownId(), "terastallization");
            for (String effectName : prioritisedEffects) {
                class_2960 key = GimmeThatGimmickMain.identifier(effectName);
                Optional<class_6880.class_6883<EffectsData>> effect = EffectsData.get(pokemon.getEntity().method_56673(), key);
                if (!effect.isPresent()) continue;
                Optional<PokemonEntity> other = StreamSupport.stream(terastallizationEvent.getBattle().getActivePokemon().spliterator(), false).map(ActiveBattlePokemon::getBattlePokemon).filter(active -> terastallizationEvent.getPokemon().getFacedOpponents().contains(active)).filter(Objects::nonNull).map(BattlePokemon::getEntity).filter(Objects::nonNull).findAny();
                ((EffectsData)effect.get().comp_349()).run(pokemon.getEntity(), other.orElse(null), terastallizationEvent.getBattle());
                break;
            }
        }
        return Unit.INSTANCE;
    }

    public static Unit fixTeraTyping(PokemonCapturedEvent pokemonCapturedEvent) {
        Pokemon pokemon = pokemonCapturedEvent.getPokemon();
        if (pokemon.getSpecies().getName().equals("Ogerpon")) {
            pokemon.setTeraType(TeraTypes.getGRASS());
        } else if (pokemon.getSpecies().getName().equals("Terapagos")) {
            pokemon.setTeraType(TeraTypes.getSTELLAR());
        }
        return Unit.INSTANCE;
    }

    public static void resetBattlePokemon(class_3222 player) {
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        for (Pokemon pokemon : playerPartyStore) {
            CobblemonEventHandler.resetBattleForms(pokemon);
        }
    }

    public static void resetBattleForms(Pokemon pokemon) {
        MegaHelper.megaDevolve(pokemon);
        pokemon.getPersistentData().method_10551("is_tera");
        if (pokemon.getPersistentData().method_10545("tera_aspect")) {
            String aspect = pokemon.getPersistentData().method_10558("tera_aspect");
            UnaspectPropertyType.INSTANCE.fromString(aspect).apply(pokemon);
        }
        GTGDynamicRegistries.battleForms.method_17966(pokemon.getSpecies().getResourceIdentifier()).ifPresent(form -> form.defaultForm().features().apply(pokemon));
        if (pokemon.getAspects().contains("complete-percent")) {
            new StringSpeciesFeature("percent_cells", pokemon.getPersistentData().method_10558("percent_cells")).apply(pokemon);
            pokemon.getPersistentData().method_10551("percent_cells");
        }
        if (pokemon.getAspects().contains("ultra-fusion")) {
            new StringSpeciesFeature("prism_fusion", pokemon.getPersistentData().method_10558("prism_fusion")).apply(pokemon);
            pokemon.getPersistentData().method_10551("prism_fusion");
        }
        if (pokemon.getSpecies().showdownId().equalsIgnoreCase("greninja") && pokemon.getAspects().contains("ash")) {
            new StringSpeciesFeature("battle_bond", "bond").apply(pokemon);
        }
        if (pokemon.getAspects().contains("gmax")) {
            pokemon.getFeatures().removeIf(speciesFeature -> speciesFeature.getName().equalsIgnoreCase("dynamax_form"));
        }
        if (pokemon.getAspects().contains("stellar-form") || pokemon.getAspects().contains("terastal-form")) {
            new StringSpeciesFeature("tera_form", "normal").apply(pokemon);
        }
        if (pokemon.getEntity() != null) {
            DynamaxEventHandler.scaleDownDynamax(pokemon.getEntity());
            if (!pokemon.getEntity().method_6059(GTGStatusEffects.DYNAMAX)) {
                pokemon.getEntity().method_6016(class_1294.field_5912);
            }
        }
        pokemon.getFeatures().removeIf(speciesFeature -> speciesFeature.getName().equalsIgnoreCase("embody_aspect"));
        pokemon.updateAspects();
        pokemon.getAnyChangeObservable().emit((Object[])new Pokemon[]{pokemon});
    }

    public static void updatePokemonPackets(PokemonBattle battle, BattlePokemon battlePokemon, boolean abilities) {
        if (abilities) {
            battle.sendUpdate((NetworkPacket)new AbilityUpdatePacket(() -> ((BattlePokemon)battlePokemon).getEffectedPokemon(), battlePokemon.getEffectedPokemon().getAbility().getTemplate()));
            battle.sendUpdate((NetworkPacket)new BattleUpdateTeamPokemonPacket(battlePokemon.getEffectedPokemon()));
        }
        for (ActiveBattlePokemon activeBattlePokemon : battle.getActivePokemon()) {
            if (activeBattlePokemon.getBattlePokemon() == null || activeBattlePokemon.getBattlePokemon().getEffectedPokemon().getOwnerPlayer() != battlePokemon.getEffectedPokemon().getOwnerPlayer() || activeBattlePokemon.getBattlePokemon() != battlePokemon) continue;
            battle.sendSidedUpdate(activeBattlePokemon.getActor(), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), battlePokemon, true), (NetworkPacket)new BattleTransformPokemonPacket(activeBattlePokemon.getPNX(), battlePokemon, false), false);
        }
    }

    public static Unit formeChanges(FormeChangeEvent formeChangeEvent) {
        if (formeChangeEvent.getFormeName().equals("x") || formeChangeEvent.getFormeName().equals("y") || formeChangeEvent.getFormeName().equals("mega") || formeChangeEvent.getFormeName().equals("tera")) {
            return Unit.INSTANCE;
        }
        Optional<PokemonEntity> other = StreamSupport.stream(formeChangeEvent.getBattle().getActivePokemon().spliterator(), false).map(ActiveBattlePokemon::getBattlePokemon).filter(active -> formeChangeEvent.getPokemon().getFacedOpponents().contains(active)).filter(Objects::nonNull).map(BattlePokemon::getEntity).filter(Objects::nonNull).findAny();
        Pokemon pokemon = formeChangeEvent.getPokemon().getEffectedPokemon();
        if (pokemon.getSpecies().showdownId().equalsIgnoreCase("zygarde") && formeChangeEvent.getFormeName().equalsIgnoreCase("complete")) {
            formeChangeEvent.getBattle().dispatchToFront(() -> {
                if (pokemon.getAspects().contains("10-percent")) {
                    pokemon.getPersistentData().method_10582("percent_cells", "10");
                } else {
                    pokemon.getPersistentData().method_10582("percent_cells", "50");
                }
                new StringSpeciesFeature("percent_cells", "complete").apply(pokemon);
                return new UntilDispatch(() -> true);
            });
            if (pokemon.getEntity() != null) {
                EffectsData.run(pokemon.getEntity(), other.orElse(null), formeChangeEvent.getBattle(), MiscUtilsKt.cobblemonResource((String)"zygarde_complete"));
            }
            return Unit.INSTANCE;
        }
        if (pokemon.getSpecies().showdownId().equalsIgnoreCase("greninja") && formeChangeEvent.getFormeName().equalsIgnoreCase("ash")) {
            formeChangeEvent.getBattle().dispatchToFront(() -> {
                new StringSpeciesFeature("battle_bond", "ash").apply(pokemon);
                return new UntilDispatch(() -> true);
            });
            if (pokemon.getEntity() != null) {
                EffectsData.run(pokemon.getEntity(), other.orElse(null), formeChangeEvent.getBattle(), MiscUtilsKt.cobblemonResource((String)"greninja_ash"));
            }
            return Unit.INSTANCE;
        }
        if (pokemon.getEntity() != null) {
            class_1937 world = pokemon.getEntity().method_37908();
            world.method_30349().method_46759(GTGDynamicRegistryKeys.BATTLE_FORM).flatMap(registry -> registry.method_46746(BattleForm.key(pokemon))).ifPresent(battleForm -> ((BattleForm)battleForm.comp_349()).applyForm(pokemon.getEntity(), other.orElse(null), formeChangeEvent.getBattle(), formeChangeEvent.getFormeName()));
        }
        return Unit.INSTANCE;
    }

    private static Unit heldItemFormChange(HeldItemEvent.Pre heldItemEvent) {
        GenericFormChangeHeldItem formChanger;
        class_1792 class_17922;
        if (!(!MegaHelper.hasMegaAspect(heldItemEvent.getPokemon()) || class_1799.method_7984((class_1799)heldItemEvent.getReceiving(), (class_1799)heldItemEvent.getReturning()) || heldItemEvent.getPokemon().getEntity() != null && heldItemEvent.getPokemon().getEntity().isBattling())) {
            MegaHelper.megaDevolve(heldItemEvent.getPokemon());
        }
        if ((class_17922 = heldItemEvent.getReturning().method_7909()) instanceof GenericFormChangeHeldItem) {
            formChanger = (GenericFormChangeHeldItem)class_17922;
            formChanger.removeFromPokemon(heldItemEvent.getPokemon());
        }
        if ((class_17922 = heldItemEvent.getReceiving().method_7909()) instanceof GenericFormChangeHeldItem) {
            formChanger = (GenericFormChangeHeldItem)class_17922;
            formChanger.giveToPokemon(heldItemEvent.getPokemon());
        }
        return Unit.INSTANCE;
    }

    private static Unit pokemonHealed(PokemonHealedEvent pokemonHealedEvent) {
        class_3222 player = pokemonHealedEvent.getPokemon().getOwnerPlayer();
        if (player != null && pokemonHealedEvent.getSource() == HealingSource.Force.INSTANCE) {
            for (class_1799 item : player.method_56675()) {
                if (!item.method_31573(GTGItemTags.BREAKABLE_TERA_ORBS)) continue;
                item.method_7974(0);
                break;
            }
        }
        return Unit.INSTANCE;
    }

    private static Unit pokemonSentOut(PokemonSentPostEvent event) {
        if (Options.shouldApplyBasicTeraGlow() && event.getPokemon().getPersistentData().method_10545("is_tera")) {
            GlowHandler.applyTeraGlow(event.getPokemonEntity());
        }
        return Unit.INSTANCE;
    }
}

