/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.gimmick.handlers;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.dispatch.UntilDispatch;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.provismet.cobblemon.gimmick.GimmeThatGimmickMain;
import com.provismet.cobblemon.gimmick.api.data.registry.EffectsData;
import com.provismet.cobblemon.gimmick.api.event.DynamaxEvents;
import com.provismet.cobblemon.gimmick.config.Options;
import com.provismet.cobblemon.gimmick.handlers.CobblemonEventHandler;
import com.provismet.cobblemon.gimmick.registry.GTGStatusEffects;
import com.provismet.cobblemon.gimmick.util.DelayedTicker;
import com.provismet.cobblemon.gimmick.util.GlowHandler;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import kotlin.Unit;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public abstract class DynamaxEventHandler {
    public static void register() {
        DynamaxEvents.DYNAMAX_START.register(Event.DEFAULT_PHASE, DynamaxEventHandler::startDynamax);
        DynamaxEvents.DYNAMAX_END.register(Event.DEFAULT_PHASE, DynamaxEventHandler::endDynamax);
    }

    public static void scaleDownDynamax(final PokemonEntity pokemonEntity) {
        DelayedTicker.add(new DelayedTicker(Options.getDynamaxScaleDuration()){

            @Override
            protected void function() {
                if (!pokemonEntity.method_31481() && pokemonEntity.method_6059(GTGStatusEffects.DYNAMAX)) {
                    pokemonEntity.method_26082(new class_1293(GTGStatusEffects.DYNAMAX, Integer.MAX_VALUE, this.maxAge - this.age, true, true, true), null);
                } else {
                    this.age = this.maxAge;
                }
                if (this.age == this.maxAge) {
                    pokemonEntity.method_6016(class_1294.field_5912);
                    pokemonEntity.method_6016(GTGStatusEffects.DYNAMAX);
                }
            }
        });
    }

    private static void startDynamax(PokemonBattle pokemonBattle, BattlePokemon pokemon, boolean gmax) {
        PokemonEntity pokemonEntity;
        if (gmax) {
            pokemonBattle.dispatchToFront(() -> {
                new StringSpeciesFeature("dynamax_form", "gmax").apply(pokemon.getEffectedPokemon());
                CobblemonEventHandler.updatePokemonPackets(pokemonBattle, pokemon, false);
                return new UntilDispatch(() -> true);
            });
        }
        if ((pokemonEntity = pokemon.getEntity()) == null) {
            return;
        }
        List<String> prioritisedEffects = List.of("dynamax_" + pokemon.getEffectedPokemon().getSpecies().showdownId(), "dynamax");
        for (String effectName : prioritisedEffects) {
            class_2960 key = GimmeThatGimmickMain.identifier(effectName);
            Optional<class_6880.class_6883<EffectsData>> effect = EffectsData.get(pokemonEntity.method_56673(), key);
            if (!effect.isPresent()) continue;
            Optional<PokemonEntity> other = StreamSupport.stream(pokemonBattle.getActivePokemon().spliterator(), false).map(ActiveBattlePokemon::getBattlePokemon).filter(active -> pokemon.getFacedOpponents().contains(active)).filter(Objects::nonNull).map(BattlePokemon::getEntity).filter(Objects::nonNull).findAny();
            ((EffectsData)effect.get().comp_349()).run(pokemonEntity, other.orElse(null), pokemonBattle);
            break;
        }
        DelayedTicker.add(new DelayedTicker(Options.getDynamaxScaleDuration()){

            @Override
            protected void function() {
                if (!pokemonEntity.method_31481()) {
                    pokemonEntity.method_6092(new class_1293(GTGStatusEffects.DYNAMAX, Integer.MAX_VALUE, this.age, true, true, true));
                } else {
                    this.age = this.maxAge;
                }
            }
        });
        pokemonBattle.dispatchWaitingToFront((float)Options.getDynamaxScaleDuration() / 20.0f, () -> Unit.INSTANCE);
        if (Options.shouldApplyBasicDynamaxGlow()) {
            GlowHandler.applyDynamaxGlow(pokemonEntity);
        }
    }

    private static void endDynamax(PokemonBattle pokemonBattle, BattlePokemon pokemon) {
        pokemonBattle.dispatchToFront(() -> {
            pokemon.getEffectedPokemon().getFeatures().removeIf(speciesFeature -> speciesFeature.getName().equalsIgnoreCase("dynamax_form"));
            pokemon.getEffectedPokemon().updateAspects();
            return new UntilDispatch(() -> true);
        });
        PokemonEntity pokemonEntity = pokemon.getEntity();
        if (pokemonEntity == null) {
            return;
        }
        DynamaxEventHandler.scaleDownDynamax(pokemonEntity);
    }
}

