/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.gimmick.item.forms;

import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.properties.CustomPokemonProperty;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.gimmick.item.forms.GenericFormChangeHeldItem;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public class MoveChangingFormChangeHeldItem
extends GenericFormChangeHeldItem {
    private final List<String> movesGainedOnGive;
    private final List<String> movesLostOnGive;
    private final List<String> movesGainedOnTake;
    private final List<String> movesLostOnTake;

    public MoveChangingFormChangeHeldItem(class_1792.class_1793 settings, class_1792 baseVanillaItem, PolymerModelData modelData, int tooltipLines, class_2960 species, CustomPokemonProperty apply, CustomPokemonProperty remove, List<String> movesGainedOnGive, List<String> movesLostOnGive, List<String> movesGainedOnTake, List<String> movesLostOnTake) {
        super(settings, baseVanillaItem, modelData, tooltipLines, species, apply, remove);
        this.movesGainedOnGive = movesGainedOnGive;
        this.movesLostOnGive = movesLostOnGive;
        this.movesGainedOnTake = movesGainedOnTake;
        this.movesLostOnTake = movesLostOnTake;
    }

    @Override
    public void giveToPokemon(Pokemon pokemon) {
        super.giveToPokemon(pokemon);
        this.swapMoves(pokemon, this.movesGainedOnGive, this.movesLostOnGive);
    }

    @Override
    public void removeFromPokemon(Pokemon pokemon) {
        super.removeFromPokemon(pokemon);
        this.swapMoves(pokemon, this.movesGainedOnTake, this.movesLostOnTake);
    }

    private void swapMoves(Pokemon pokemon, List<String> gainedMoves, List<String> lostMoves) {
        MoveTemplate template;
        for (String move : lostMoves) {
            template = Moves.INSTANCE.getByName(move);
            if (template == null) continue;
            for (int i = 0; i < pokemon.getMoveSet().getMovesWithNulls().size(); ++i) {
                Move currentMove = pokemon.getMoveSet().get(i);
                if (currentMove == null || !currentMove.getTemplate().getName().equals(template.getName())) continue;
                pokemon.getMoveSet().setMove(i, null);
            }
            BenchedMove removeThis = null;
            for (BenchedMove benchedMove : pokemon.getBenchedMoves()) {
                if (!benchedMove.getMoveTemplate().getName().equals(template.getName())) continue;
                removeThis = benchedMove;
                break;
            }
            if (removeThis == null) continue;
            pokemon.getBenchedMoves().remove(removeThis);
        }
        for (String move : gainedMoves) {
            template = Moves.INSTANCE.getByName(move);
            if (template == null) continue;
            if (pokemon.getMoveSet().hasSpace()) {
                pokemon.getMoveSet().add(template.create());
                continue;
            }
            pokemon.getBenchedMoves().add(new BenchedMove(template, 0));
        }
    }
}

