/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.gimmick.item.forms;

import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.gimmick.GimmeThatGimmickMain;
import com.provismet.cobblemon.gimmick.api.data.registry.EffectsData;
import com.provismet.cobblemon.gimmick.item.PolymerPokemonSelectingItem;
import com.provismet.cobblemon.gimmick.item.forms.FormChangeFusionItem;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class ReinsOfUnityItem
extends PolymerPokemonSelectingItem
implements FormChangeFusionItem {
    private static final String FEATURE = "king_steed";
    private static final Set<String> HORSES = Set.of("cobblemon:glastrier", "cobblemon:spectrier");

    public ReinsOfUnityItem(class_1792.class_1793 settings, class_1792 baseVanillaItem, PolymerModelData modelData) {
        super(settings, baseVanillaItem, modelData, 1);
    }

    @Override
    public boolean canBeMerged(class_1799 stack, Pokemon other) {
        return HORSES.contains(other.getSpecies().getResourceIdentifier().toString());
    }

    @Override
    public void applyUnplitForme(class_1799 stack, Pokemon pokemon) {
        new StringSpeciesFeature(FEATURE, "none").apply(pokemon);
        if (pokemon.getEntity() != null) {
            EffectsData.run(pokemon.getEntity(), GimmeThatGimmickMain.identifier("reins_of_unity_unfuse"));
        }
    }

    @Override
    public void applyFusedForme(class_1799 stack, Pokemon pokemon, Pokemon other) {
        String forme = other.getSpecies().getResourceIdentifier().method_12832().equals("glastrier") ? "ice" : "shadow";
        new StringSpeciesFeature(FEATURE, forme).apply(pokemon);
        if (pokemon.getEntity() != null) {
            EffectsData.run(pokemon.getEntity(), GimmeThatGimmickMain.identifier("reins_of_unity_fuse"));
        }
    }

    public boolean canUseOnPokemon(@NotNull Pokemon pokemon) {
        return pokemon.getSpecies().getResourceIdentifier().toString().equals("cobblemon:calyrex");
    }
}

