/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.cobblemon.gimmick.util;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.provismet.cobblemon.gimmick.GimmeThatGimmickMain;
import com.provismet.cobblemon.gimmick.api.data.component.MegaEvolution;
import com.provismet.cobblemon.gimmick.api.data.registry.EffectsData;
import com.provismet.cobblemon.gimmick.registry.GTGItemDataComponents;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_6880;

public class MegaHelper {
    public static final List<String> MEGA_ASPECTS = List.of("mega", "mega_x", "mega_y");

    public static boolean checkForMega(class_3222 player) {
        boolean canHaveAnyMegaForm;
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        PCStore playerPCStore = Cobblemon.INSTANCE.getStorage().getPC(player);
        for (Pokemon pokemon : playerPartyStore) {
            canHaveAnyMegaForm = pokemon.getSpecies().getForms().stream().flatMap(form -> form.getLabels().stream()).anyMatch(MEGA_ASPECTS::contains);
            if (!canHaveAnyMegaForm || !MegaHelper.hasMegaAspect(pokemon)) continue;
            return true;
        }
        for (Pokemon pokemon : playerPCStore) {
            canHaveAnyMegaForm = pokemon.getSpecies().getForms().stream().flatMap(form -> form.getLabels().stream()).anyMatch(MEGA_ASPECTS::contains);
            if (!canHaveAnyMegaForm || !MegaHelper.hasMegaAspect(pokemon)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMegaAspect(Pokemon pokemon) {
        return pokemon.getAspects().stream().anyMatch(MEGA_ASPECTS::contains) || pokemon.getPersistentData().method_10545("is_mega");
    }

    public static boolean megaEvolve(Pokemon pokemon, boolean inBattle) {
        class_1799 megaStone = pokemon.heldItem();
        MegaEvolution mega = (MegaEvolution)megaStone.method_57825(GTGItemDataComponents.MEGA_EVOLUTION, (Object)MegaEvolution.DEFAULT);
        if (inBattle || mega.pokemon().matches(pokemon) || MegaEvolution.RAYQUAZA.pokemon().matches(pokemon)) {
            mega.onApply().apply(pokemon);
            pokemon.getPersistentData().method_10556("is_mega", true);
            if (pokemon.getTradeable()) {
                pokemon.getPersistentData().method_10556("megaNoTrade", true);
                pokemon.setTradeable(false);
            }
            return true;
        }
        return false;
    }

    public static void megaDevolve(Pokemon pokemon) {
        class_1799 megaStone = pokemon.heldItem();
        MegaEvolution mega = (MegaEvolution)megaStone.method_57825(GTGItemDataComponents.MEGA_EVOLUTION, (Object)MegaEvolution.DEFAULT);
        mega.onRemove().apply(pokemon);
        pokemon.getPersistentData().method_10551("is_mega");
        if (pokemon.getPersistentData().method_10545("megaNoTrade")) {
            pokemon.setTradeable(true);
            pokemon.getPersistentData().method_10551("megaNoTrade");
        }
        if (pokemon.getEntity() == null) {
            return;
        }
        List<String> prioritisedEffects = List.of("mega_devolution_" + pokemon.showdownId(), "mega_devolution");
        for (String id : prioritisedEffects) {
            Optional<class_6880.class_6883<EffectsData>> effectsData = EffectsData.get(pokemon.getEntity().method_56673(), GimmeThatGimmickMain.identifier(id));
            if (!effectsData.isPresent()) continue;
            ((EffectsData)effectsData.get().comp_349()).run(pokemon.getEntity());
            break;
        }
    }
}

