/*
 * Decompiled with CFR 0.152.
 */
package deus.guidebookmd.components;

import deus.guidebookmd.components.MDComponent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.Items;

public class MDFakeSlot
extends MDComponent {
    protected static final Map<String, Item> ITEMS = MDFakeSlot.initializeItems();
    private static final Item DEFAULT_ITEM = Items.AMMO_PEBBLE;
    Item item;
    ItemElement itemElement;

    public MDFakeSlot(String item) {
        this.item = ITEMS.getOrDefault(item, Items.AMMO_PEBBLE);
        this.itemElement = new ItemElement(this.mc);
        this.width = 18;
        this.height = 18;
    }

    @Override
    public void render(int x, int y, int mx, int my) {
        super.render(x, y, mx, my);
        this.drawTexturedIcon(x, y, this.width, this.height, TextureRegistry.getTexture((String)"guidebookmd:gui/hud/slot"));
        this.itemElement.render(this.item.getDefaultStack(), x, y);
    }

    private static Map<String, Item> initializeItems() {
        HashMap<String, Item> items = new HashMap<String, Item>();
        try {
            Field[] fields;
            for (Field field : fields = Items.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !Item.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                Object value = field.get(null);
                if (!(value instanceof Item)) continue;
                items.put(((Item)value).namespaceID.toString(), (Item)value);
            }
        }
        catch (IllegalAccessException e) {
            System.err.println("Failed to initialize items map: " + e.getMessage());
            e.printStackTrace();
        }
        return items;
    }
}

