/*
 * Decompiled with CFR 0.152.
 */
package deus.guidebookmd.components;

import deus.guidebookmd.components.MDComponent;
import deus.guidebookmd.formats.MarkdownColor;
import deus.guidebookmd.formats.TextPart;
import java.util.ArrayList;
import java.util.List;

public class MDText
extends MDComponent {
    public boolean centered = false;
    public int argbColor = 0xFFFFFF;
    public String originalText = "";
    public List<TextPart> parts = new ArrayList<TextPart>();

    public MDText(String text) {
        this.height = this.mc.font.fontHeight;
        this.width = Math.max(143, this.mc.font.getStringWidth(text));
        this.originalText = text;
        this.parts = this.parseTextWithFormatting(text);
    }

    private List<TextPart> parseTextWithFormatting(String text) {
        ArrayList<TextPart> parsed = new ArrayList<TextPart>();
        int color = 0xFFFFFF;
        boolean shadow = false;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '&' && i + 1 < text.length()) {
                int newColor;
                char code = text.charAt(i + 1);
                ++i;
                if (buffer.length() > 0) {
                    parsed.add(new TextPart(buffer.toString(), color, shadow));
                    buffer.setLength(0);
                }
                if ((newColor = MarkdownColor.get(code)) != -1) {
                    color = newColor;
                    continue;
                }
                switch (code) {
                    case 's': {
                        shadow = true;
                        break;
                    }
                    case 'r': {
                        color = 0xFFFFFF;
                        shadow = false;
                    }
                }
                continue;
            }
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            parsed.add(new TextPart(buffer.toString(), color, shadow));
        }
        return parsed;
    }

    @Override
    public void render(int x, int y, int mx, int my) {
        int drawX = this.x + x;
        int drawY = this.y + y;
        int offsetX = 0;
        for (TextPart part : this.parts) {
            int color = part.color;
            String text = part.text;
            if (this.centered) {
                this.drawStringCentered(this.mc.font, text, drawX, drawY, color);
                continue;
            }
            if (part.shadow) {
                this.drawString(this.mc.font, text, drawX + offsetX, drawY, color);
            } else {
                this.drawStringNoShadow(this.mc.font, text, drawX + offsetX, drawY, color);
            }
            offsetX += this.mc.font.getStringWidth(text);
        }
    }
}

