/*
 * Decompiled with CFR 0.152.
 */
package deus.guidebookmd.config;

import com.google.gson.Gson;
import deus.guidebookmd.Guidebookmd;
import deus.guidebookmd.config.PageConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Consumer;

public class BookConfig {
    public String defaultPageTexture = "/assets/minecraft/textures/gui/container/guidebook/guidebook.png";
    public String frontPage = "/assets/guidebookmd/textures/gui/generic_cover.png";
    public String backPage = "/assets/guidebookmd/textures/gui/generic_back.png";
    public int[] backPageOffsets = new int[]{0, 0};
    public int[] frontBackPageWH = new int[]{158, 220};
    public int pageSkipAmount = 2;
    public int[] pageTexturePositions = new int[]{-79, 79};
    public int[] textXPositions = new int[]{-153, 166};
    public int[] textYPositions = new int[]{0, 0};
    public boolean pairButtons = true;
    public PageConfig defaultPageConfig = new PageConfig();

    public BookConfig(Consumer<BookConfig> config) {
        config.accept(this);
    }

    public BookConfig() {
    }

    public static BookConfig fromJsonResource(Class<?> c, String path) {
        BookConfig bookConfig;
        BufferedReader reader = new BufferedReader(new InputStreamReader(c.getResourceAsStream(path)));
        try {
            Gson gson = new Gson();
            bookConfig = (BookConfig)gson.fromJson((Reader)reader, BookConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Guidebookmd.LOGGER.error("Error reading JSON file: {}, {}", (Object)path, (Object)e);
                return new BookConfig();
            }
        }
        reader.close();
        return bookConfig;
    }
}

