/*
 * Decompiled with CFR 0.152.
 */
package deus.guidebookmd.gui;

import deus.guidebookmd.MarkdownCompiler;
import deus.guidebookmd.components.MDComponent;
import deus.guidebookmd.config.BookConfig;
import deus.guidebookmd.gui.MDPage;
import deus.guidebookmd.gui.MDScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.core.sound.SoundCategory;
import org.lwjgl.opengl.GL11;

public class MDBookScreen
extends MDScreen {
    protected BookConfig config = new BookConfig(c -> {});
    protected int currentPageNumber = -1;
    protected final List<MDPage> pages = new ArrayList<MDPage>();
    public int xOffset;
    public int yOffset;

    public void init() {
        super.init();
        this.xOffset = (this.width - 158) / 2;
        this.yOffset = (this.height - 220) / 2;
        this.shareReferenceToComponents();
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        if (this.currentPageNumber != -1) {
            this.currentPage = this.getCurrentPage().mdComponents;
        }
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        if (this.currentPageNumber == -1) {
            this.mc.textureManager.loadTexture(this.config.frontPage).bind();
            this.drawTexturedModalRect(this.xOffset, this.yOffset, 0, 0, this.config.frontBackPageWH[0], this.config.frontBackPageWH[1]);
        } else {
            this.mc.textureManager.loadTexture(this.config.backPage).bind();
            this.drawTexturedModalRect(this.xOffset + this.config.backPageOffsets[0], this.yOffset + this.config.backPageOffsets[1], 0, 0, this.config.frontBackPageWH[0], this.config.frontBackPageWH[1]);
            for (int i = 0; i < this.config.pageTexturePositions.length; ++i) {
                int pageIndex = this.currentPageNumber + i;
                if (pageIndex >= this.pages.size()) continue;
                int textX = this.config.textXPositions.length > i ? this.config.textXPositions[i] : 0;
                int textY = this.config.textYPositions.length > i ? this.config.textYPositions[i] : 0;
                int textureX = this.config.pageTexturePositions.length > i ? this.config.pageTexturePositions[i] : 0;
                MDPage page = this.pages.get(pageIndex);
                if (this.config.pairButtons && pageIndex % 2 == 0) {
                    page.hasNextButton = true;
                    page.hasPreviousButton = false;
                } else if (this.config.pairButtons) {
                    page.hasNextButton = false;
                    page.hasPreviousButton = true;
                }
                page.updateMousePos(mx, my);
                page.x = this.xOffset;
                page.y = this.yOffset;
                page.render(textX, textY, textureX);
            }
        }
        GL11.glPopMatrix();
    }

    public void goBack() {
        this.currentPageNumber -= this.config.pageSkipAmount;
        if (this.currentPageNumber < 0) {
            this.currentPageNumber = -1;
        }
        this.playPageSound();
    }

    public void goNext() {
        if (this.currentPageNumber == -1) {
            this.currentPageNumber = 0;
        } else {
            this.currentPageNumber += this.config.pageSkipAmount;
            if (this.currentPageNumber >= this.pages.size()) {
                this.currentPageNumber = 0;
            }
            this.playPageSound();
        }
    }

    public void goTo(int pageNumber) {
        this.currentPageNumber = pageNumber;
        if (this.currentPageNumber % this.config.pageSkipAmount != 0) {
            --this.currentPageNumber;
        }
        if (this.currentPageNumber < 0) {
            this.currentPageNumber = 0;
        }
        if (this.currentPageNumber >= this.pages.size()) {
            this.currentPageNumber = 0;
        }
        int diff = this.currentPageNumber - pageNumber;
        for (int i = 0; i < diff; ++i) {
            this.playPageSound();
        }
    }

    protected void buttonReleased(ButtonElement button) {
        super.buttonReleased(button);
        if (button.id == 0 && this.currentPageNumber > 0) {
            this.goBack();
        }
        if (button.id == 1 && this.currentPageNumber + 1 < this.pages.size()) {
            this.goNext();
        }
    }

    public void mouseClicked(int mx, int my, int buttonNum) {
        if (this.currentPageNumber == -1) {
            this.currentPageNumber = 0;
        } else {
            for (int i = 0; i < this.config.pageTexturePositions.length; ++i) {
                int pageIndex = this.currentPageNumber + i;
                if (pageIndex >= this.pages.size()) continue;
                MDPage page = this.pages.get(pageIndex);
                page.mouseClick(mx, my);
            }
        }
    }

    public void loadMarkdownPage(String path) {
        this.pages.add(MarkdownCompiler.compile(path, ((Object)((Object)this)).getClass()));
    }

    public void loadMarkdownPages(String ... paths) {
        for (String path : paths) {
            this.loadMarkdownPage(path);
        }
    }

    public MDPage getCurrentPage() {
        return this.pages.get(this.currentPageNumber);
    }

    public void playPageSound() {
        Random r = new Random();
        this.mc.sndManager.playSound("random.page", SoundCategory.GUI_SOUNDS, 0.8f, 0.9f + (r.nextFloat() - r.nextFloat()) * 0.1f);
    }

    private void shareReferenceToComponents() {
        for (MDPage page : this.pages) {
            page.setScreen(this);
            for (MDComponent mdComponent : page.mdComponents) {
                mdComponent.setScreen(this);
            }
        }
    }
}

