/*
 * Decompiled with CFR 0.152.
 */
package deus.guidebookmd;

import com.mojang.nbt.tags.CompoundTag;
import deus.guidebookmd.Guidebookmd;
import deus.guidebookmd.components.MDComponent;
import deus.guidebookmd.config.BookConfig;
import deus.guidebookmd.gui.MDEditablePage;
import deus.guidebookmd.gui.MarkdownGuidebook;
import deus.guidebookmd.gui.elements.PageButton;
import deus.guidebookmd.gui.elements.TextEditor;
import deus.guidebookmd.item.Items;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import org.lwjgl.input.Keyboard;

public class EditableBook
extends MarkdownGuidebook<MDEditablePage> {
    private boolean editable = true;
    private final PageButton exportBookButton = new PageButton("guidebookmd:gui/hud/export");
    private final PageButton addPageButton = new PageButton("guidebookmd:gui/hud/add");
    private final PageButton cloneButton = new PageButton("guidebookmd:gui/hud/clone");
    private final TextEditor titleTextArea = new TextEditor();
    private final ItemStack itemStack;
    private final Player player;

    public EditableBook(Player player, ItemStack itemStack, boolean editable) {
        this.itemStack = itemStack;
        this.player = player;
        String path = "/assets/guidebookmd/markdown/editablebook/";
        this.editable = editable;
        this.config = BookConfig.fromJsonResource(((Object)((Object)this)).getClass(), path + "config.json");
        List<List<Character>> content = EditableBook.loadFromStack(itemStack);
        if (content != null && !content.isEmpty()) {
            this.loadFromLLC(content);
        } else {
            this.addPage();
        }
        String title = itemStack.getData().getString("title");
        this.titleTextArea.drawBackground = false;
        this.titleTextArea.maxTextLength = 15;
        this.titleTextArea.drawBorder = this.editable;
        this.titleTextArea.drawCursor = this.editable;
        this.titleTextArea.drawExtraCursors = false;
        this.titleTextArea.drawLineCount = false;
        this.titleTextArea.drawLineCharCount = false;
        this.titleTextArea.maxLines = 17;
        this.titleTextArea.height = 170;
        this.titleTextArea.width = 80;
        this.titleTextArea.setContent(title.chars().mapToObj(ch -> Character.valueOf((char)ch)).collect(Collectors.toList()));
        this.exportBookButton.onClick = this::exportBookButtonOnclick;
        this.cloneButton.onClick = this::cloneButtonOnclick;
        this.addPageButton.onClick = this::addPageButtonOnclick;
        this.addPageButton.disabled = !this.editable;
        this.cloneButton.disabled = this.addPageButton.disabled;
        this.exportBookButton.disabled = this.addPageButton.disabled;
    }

    public EditableBook(Player player, ItemStack itemStack) {
        this(player, itemStack, itemStack.getData().getBoolean("editable"));
    }

    public void saveEditorsToItemStack(Player editor, ItemStack stack) {
        String title;
        CompoundTag data = stack.getData();
        String editorsRaw = data.getString("editors");
        ArrayList<String> editors = new ArrayList<String>();
        if (editorsRaw != null && !editorsRaw.isEmpty()) {
            for (String name : editorsRaw.split(",")) {
                if (name.isEmpty()) continue;
                editors.add(name);
            }
        }
        if (!editors.contains(editor.nickname)) {
            editors.add(editor.nickname);
        }
        data.putString("title", (title = this.titleTextArea.getContentAsString()).isEmpty() ? "" : title);
        data.putString("editors", String.join((CharSequence)",", editors));
        stack.setData(data);
    }

    public void savePagesToItemStack(ItemStack stack) {
        CompoundTag data = stack.getData();
        ArrayList<String> pageStrings = new ArrayList<String>();
        for (List<Character> page : this.getAllPagesContent()) {
            StringBuilder sb = new StringBuilder();
            for (Character c : page) {
                if (c.charValue() == ',') {
                    sb.append("\\,");
                    continue;
                }
                sb.append(c);
            }
            pageStrings.add(sb.toString());
        }
        data.putString("pages", String.join((CharSequence)",", pageStrings));
        stack.setData(data);
    }

    public void completeSaveToItemStack(Player author, ItemStack stack) {
        this.saveEditorsToItemStack(author, stack);
        this.savePagesToItemStack(stack);
    }

    public ItemStack createCloneStack(Player author, ItemStack stack, boolean editable) {
        this.completeSaveToItemStack(author, stack);
        CompoundTag data = stack.getData();
        data.putString("author", author.nickname);
        ItemStack newStack = new ItemStack(editable ? Items.MD_ITEM_EDITABLE_BOOK : Items.MD_ITEM_READONLY_BOOK, 1);
        newStack.setData(stack.getData());
        return newStack;
    }

    public ItemStack exportItemStackBook(Player author, ItemStack stack, boolean editable) {
        ItemStack itemStack1 = this.createCloneStack(author, stack, editable);
        CompoundTag data = itemStack1.getData();
        data.putBoolean("editable", editable);
        itemStack1.setData(data);
        return itemStack1;
    }

    public static List<List<Character>> loadFromStack(ItemStack stack) {
        ArrayList<List<Character>> result = new ArrayList<List<Character>>();
        CompoundTag data = stack.getData();
        String raw = data.getString("pages");
        if (raw != null && !raw.isEmpty()) {
            StringBuilder current = new StringBuilder();
            ArrayList<String> pages = new ArrayList<String>();
            boolean escaping = false;
            for (int i = 0; i < raw.length(); ++i) {
                char c = raw.charAt(i);
                if (escaping) {
                    current.append(c);
                    escaping = false;
                    continue;
                }
                if (c == '\\') {
                    escaping = true;
                    continue;
                }
                if (c == ',') {
                    pages.add(current.toString());
                    current = new StringBuilder();
                    continue;
                }
                current.append(c);
            }
            if (current.length() > 0) {
                pages.add(current.toString());
            }
            for (String page : pages) {
                ArrayList<Character> charList = new ArrayList<Character>();
                for (char c : page.toCharArray()) {
                    charList.add(Character.valueOf(c));
                }
                result.add(charList);
            }
        }
        return result;
    }

    public void loadFromLLC(List<List<Character>> content) {
        this.pages.clear();
        for (List<Character> characters : content) {
            MDEditablePage p = this.addPage();
            p.textArea.setContent(characters);
            if (this.editable) continue;
            p.compileContent();
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        super.render(mx, my, partialTick);
        if (this.currentPageNumber != -1) {
            for (ButtonElement buttonElement : this.buttons) {
                buttonElement.drawButton(this.mc, mx, my);
            }
            this.drawButtons(mx, my);
        } else {
            this.drawTextarea(mx, my);
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        if (!this.titleTextArea.isHovered()) {
            super.mouseClicked(mx, my, buttonNum);
        }
        this.cloneButton.mouseClick(mx, my);
        this.addPageButton.mouseClick(mx, my);
        this.exportBookButton.mouseClick(mx, my);
    }

    public MDEditablePage addPage() {
        MDEditablePage p = new MDEditablePage(null, new ArrayList<MDComponent>(), this.editable);
        this.pages.add(p);
        this.shareReferenceToComponents();
        return p;
    }

    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.completeSaveToItemStack(this.player, this.itemStack);
            this.mc.displayScreen((Screen)null);
        }
        if (eventKey == Keyboard.KEY_TAB) {
            this.mc.displayScreen((Screen)null);
        }
    }

    public void drawTextarea(int mx, int my) {
        this.titleTextArea.x = (this.width - this.titleTextArea.width) / 2;
        this.titleTextArea.y = this.height / 2 - 85;
        if (this.editable) {
            this.titleTextArea.updateMousePos(mx, my);
            this.titleTextArea.update();
        }
        this.titleTextArea.render();
    }

    public void drawButtons(int mx, int my) {
        int startY = this.height / 2 - 85;
        int buttonX = this.width / 2 + 157;
        int base = 16;
        this.addPageButton.x = buttonX;
        this.cloneButton.x = buttonX;
        this.exportBookButton.x = buttonX;
        this.addPageButton.y = startY + base;
        this.cloneButton.y = startY + base * 2;
        this.exportBookButton.y = startY + base * 3;
        this.cloneButton.updateMousePos(mx, my);
        this.cloneButton.update();
        this.cloneButton.render();
        this.addPageButton.updateMousePos(mx, my);
        this.addPageButton.update();
        this.addPageButton.render();
        this.exportBookButton.updateMousePos(mx, my);
        this.exportBookButton.update();
        this.exportBookButton.render();
    }

    public List<List<Character>> getAllPagesContent() {
        ArrayList<List<Character>> data = new ArrayList<List<Character>>();
        for (MDEditablePage page : this.pages) {
            data.add(page.textArea.cloneContent());
        }
        return data;
    }

    public void addPageButtonOnclick() {
        this.addPage();
        this.goNext();
    }

    public void cloneButtonOnclick() {
        if (this.player.inventory.consumeInventoryItem(net.minecraft.core.item.Items.BOOK.id)) {
            this.player.world.dropItem((int)this.player.x, (int)this.player.y, (int)this.player.z, this.exportItemStackBook(this.player, this.itemStack, true));
            this.player.sendMessage("\u00a7aBook successfully cloned.");
        } else {
            this.player.sendMessage("\u00a7cYou need an editable-book to clone this book.");
        }
        this.mc.displayScreen((Screen)null);
    }

    public void exportBookButtonOnclick() {
        if (this.player.inventory.consumeInventoryItem(net.minecraft.core.item.Items.BOOK.id)) {
            this.player.world.dropItem((int)this.player.x, (int)this.player.y, (int)this.player.z, this.exportItemStackBook(this.player, this.itemStack, false));
            this.player.sendMessage("\u00a7aBook successfully exported.");
        } else {
            this.player.sendMessage("\u00a7cYou need an book to export this book.");
        }
        this.mc.displayScreen((Screen)null);
    }

    public static void exportMarkdownFolder(Player player, ItemStack stack, String ttitle) {
        Objects.requireNonNull(player, "Player cannot be null");
        Objects.requireNonNull(stack, "ItemStack cannot be null");
        Objects.requireNonNull(ttitle, "Title cannot be null");
        String title = ttitle.trim();
        if (title.isEmpty()) {
            title = "unnamed_book";
        }
        title = title.replaceAll("[<>:\"/\\\\|?*]", "_");
        String directoryPath = Guidebookmd.BOOKS_DIRECTORY + "/exported/" + title;
        Path dir = Paths.get(directoryPath, new String[0]);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            List<List<Character>> content = EditableBook.loadFromStack(stack);
            if (content == null || content.isEmpty()) {
                Guidebookmd.LOGGER.warn("No pages found in ItemStack for book: {}", (Object)title);
                player.sendMessage("No pages to export");
                return;
            }
            List pages = content.stream().map(characters -> {
                if (characters == null || characters.isEmpty()) {
                    return "";
                }
                List<String> linesResult = TextEditor.getLines(characters, 26, true);
                if (linesResult instanceof List) {
                    return linesResult.stream().collect(Collectors.joining("\n"));
                }
                return linesResult.toString();
            }).collect(Collectors.toList());
            if (pages.isEmpty()) {
                Guidebookmd.LOGGER.error("No pages to export for book: {}", (Object)title);
                return;
            }
            DecimalFormat formatter = new DecimalFormat("000");
            for (int i = 0; i < pages.size(); ++i) {
                String fileName = "page_" + formatter.format(i + 1) + ".md";
                Path filePath = dir.resolve(fileName);
                try (FileWriter fileWriter = new FileWriter(filePath.toFile());){
                    fileWriter.write((String)pages.get(i));
                    continue;
                }
                catch (IOException e) {
                    Guidebookmd.LOGGER.error("Failed to write page {}: {}", (Object)fileName, (Object)e.getMessage());
                }
            }
            player.sendMessage("Successfully exported " + pages.size() + " pages to " + directoryPath);
            Guidebookmd.LOGGER.info("Successfully exported {} pages to {}", (Object)pages.size(), (Object)directoryPath);
        }
        catch (IOException e) {
            Guidebookmd.LOGGER.error("Failed to create directory or export pages for book {}: {}", (Object)title, (Object)e.getMessage());
        }
    }
}

