/*
 * Decompiled with CFR 0.152.
 */
package deus.guidebookmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.ArgumentTypeString;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.nbt.tags.CompoundTag;
import deus.guidebookmd.EditableBook;
import deus.guidebookmd.Guidebookmd;
import deus.guidebookmd.gui.elements.TextEditor;
import deus.guidebookmd.item.Items;
import deus.guidebookmd.utils.RLoading;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;

public class GuideBookCommand
implements CommandManager.CommandRegistry {
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"guidebook").then(ArgumentBuilderLiteral.literal((String)"export").then(ArgumentBuilderRequired.argument((String)"title", (ArgumentType)ArgumentTypeString.string()).executes(this::executeExport)))).then(ArgumentBuilderLiteral.literal((String)"load").then(ArgumentBuilderRequired.argument((String)"title", (ArgumentType)ArgumentTypeString.string()).executes(this::executeLoad))));
    }

    private int executeExport(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        Player player = source.getSender();
        String title = (String)context.getArgument("title", String.class);
        ItemStack stack = player.inventory.getCurrentItem();
        if (stack == null) {
            source.sendMessage("You must be holding an editable-book to export");
            return 0;
        }
        if (stack.itemID != Items.MD_ITEM_EDITABLE_BOOK.id) {
            source.sendMessage("You must hold an editable book to export");
            return 0;
        }
        try {
            EditableBook.exportMarkdownFolder(player, stack, title);
            return 1;
        }
        catch (Exception e) {
            Guidebookmd.LOGGER.error("Failed to export book '{}': {}", (Object)title, (Object)e.getMessage());
            source.sendMessage("Failed to export book: " + e.getMessage());
            return 0;
        }
    }

    private int executeLoad(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        Player player = source.getSender();
        String title = (String)context.getArgument("title", String.class);
        ItemStack stack = player.inventory.getCurrentItem();
        if (stack == null) {
            source.sendMessage("You must be holding an book to load a book");
            return 0;
        }
        if (stack.itemID != net.minecraft.core.item.Items.BOOK.id) {
            source.sendMessage("You must hold an book to load a book");
            return 0;
        }
        try {
            if (player.inventory.consumeInventoryItem(net.minecraft.core.item.Items.BOOK.id)) {
                ItemStack newStack = new ItemStack(Items.MD_ITEM_EDITABLE_BOOK, 1);
                CompoundTag compoundTag = newStack.getData();
                String pages = TextEditor.fuseStrings(RLoading.loadMarkdownFilesFromFolderName(title));
                compoundTag.putString("pages", pages);
                newStack.setData(compoundTag);
                player.world.dropItem((int)player.x, (int)player.y, (int)player.z, newStack);
                player.sendMessage("\u00a7aBook successfully loaded.");
            } else {
                player.sendMessage("\u00a7cYou need an book to load a book.");
            }
            return 1;
        }
        catch (Exception e) {
            Guidebookmd.LOGGER.error("Failed to load book '{}': {}", (Object)title, (Object)e.getMessage());
            source.sendMessage("Failed to load book: " + e.getMessage());
            return 0;
        }
    }
}

