/*
 * Decompiled with CFR 0.152.
 */
package deus.guidebookmd.formats;

import deus.guidebookmd.Guidebookmd;
import deus.guidebookmd.components.MDComponent;
import deus.guidebookmd.components.MDFakeSlot;
import deus.guidebookmd.components.MDImage;
import deus.guidebookmd.components.MDLink;
import deus.guidebookmd.components.MDText;
import deus.guidebookmd.components.MDTitle;
import deus.guidebookmd.components.MDWorbench;
import deus.guidebookmd.config.PageConfig;
import deus.guidebookmd.gui.MDPage;
import deus.guidebookmd.utils.Tuple;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MarkdownCompiler {
    private static final List<PatternType> patterns = new ArrayList<PatternType>();

    public static MDPage compile(List<String> lines, int maxLines) {
        String[] splitLines;
        ArrayList<MDComponent> currentPage = new ArrayList<MDComponent>();
        int lineCount = 0;
        String fullText = String.join((CharSequence)"\n", lines);
        Tuple<PageConfig, String> info = MarkdownCompiler.extractConfig(fullText);
        fullText = (String)info.y;
        for (String line : splitLines = fullText.split("\n")) {
            if (maxLines > 0 && lineCount >= maxLines) {
                Guidebookmd.LOGGER.warn("Max lines for MD reached: {}", (Object)maxLines);
                break;
            }
            boolean matched = false;
            ++lineCount;
            for (PatternType pt : patterns) {
                String type;
                Matcher m = pt.pattern.matcher(line);
                if (!m.find()) continue;
                String content = m.groupCount() >= 1 ? m.group(1) : "";
                block13 : switch (type = pt.type) {
                    case "IMAGE": {
                        String imageType = m.group(5);
                        if (imageType == null) {
                            imageType = "default";
                        }
                        currentPage.add(new MDImage(content, m.group(2), Integer.parseInt(m.group(3)), Integer.parseInt(m.group(4)), imageType));
                        break;
                    }
                    case "H1": {
                        currentPage.add(new MDTitle(content, 2.0f));
                        break;
                    }
                    case "H2": {
                        currentPage.add(new MDTitle(content, 1.5f));
                        break;
                    }
                    case "H3": {
                        currentPage.add(new MDTitle(content, 1.25f));
                        break;
                    }
                    case "H4": {
                        currentPage.add(new MDTitle(content, 0.8f));
                        break;
                    }
                    case "H5": {
                        currentPage.add(new MDTitle(content, 0.45f));
                        break;
                    }
                    case "H6": {
                        currentPage.add(new MDTitle(content, 0.25f));
                        break;
                    }
                    case "LIST": {
                        currentPage.add(new MDText("\u2022 " + content));
                        break;
                    }
                    case "TEXT": {
                        currentPage.add(new MDText(content));
                        break;
                    }
                    case "LINK": {
                        currentPage.add(new MDLink(content, m.group(2)));
                        break;
                    }
                    case "SPECIAL": {
                        switch (content) {
                            case "slot": {
                                currentPage.add(new MDFakeSlot(m.group(2)));
                                break block13;
                            }
                            case "workbench": {
                                currentPage.add(new MDWorbench(m.group(2)));
                            }
                        }
                    }
                }
                matched = true;
                break;
            }
            if (matched) continue;
            System.out.println("Can't recognize: " + line);
        }
        return new MDPage((PageConfig)info.x, currentPage);
    }

    public static Tuple<PageConfig, String> extractConfig(String fullText) {
        Matcher configMatcher = MarkdownCompiler.patterns.get((int)0).pattern.matcher(fullText);
        if (configMatcher.find() && "config".equals(configMatcher.group(1))) {
            try {
                PageConfig config = PageConfig.fromJsonString(configMatcher.group(2));
                int start = configMatcher.start();
                int end = configMatcher.end();
                String before = fullText.substring(0, start).trim();
                String after = fullText.substring(end).trim();
                String cleanedText = before + "\n" + after;
                return new Tuple<PageConfig, CallSite>(config, (CallSite)((Object)cleanedText));
            }
            catch (Exception e) {
                Guidebookmd.LOGGER.error("Invalid config block", (Throwable)e);
            }
        }
        return new Tuple<Object, String>(null, fullText);
    }

    public static MDPage compile(List<String> lines) {
        return MarkdownCompiler.compile(lines, -1);
    }

    public static MDPage compile(String path, Class<?> c, int maxLines) {
        MDPage mDPage;
        BufferedReader reader = new BufferedReader(new InputStreamReader(c.getResourceAsStream(path)));
        try {
            List<String> lines = reader.lines().collect(Collectors.toList());
            mDPage = MarkdownCompiler.compile(lines, maxLines);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading Markdown file: " + path, e);
            }
        }
        reader.close();
        return mDPage;
    }

    public static MDPage compile(String path, Class<?> c) {
        return MarkdownCompiler.compile(path, c, -1);
    }

    static {
        patterns.add(new PatternType(Pattern.compile("!\\[([^]]*)\\]\\((.*?)\\)", 32), "SPECIAL"));
        patterns.add(new PatternType(Pattern.compile("\\[([^\\]]+)]\\(([^)]+)\\)\\((\\d+),(\\d+)(?:,\\s*([^\\)]+))?\\)"), "IMAGE"));
        patterns.add(new PatternType(Pattern.compile("\\[([^\\]]+)\\]\\(([^\\)]+)\\)"), "LINK"));
        patterns.add(new PatternType(Pattern.compile("^######\\s+(.+)$"), "H6"));
        patterns.add(new PatternType(Pattern.compile("^#####\\s+(.+)$"), "H5"));
        patterns.add(new PatternType(Pattern.compile("^####\\s+(.+)$"), "H4"));
        patterns.add(new PatternType(Pattern.compile("^###\\s+(.+)$"), "H3"));
        patterns.add(new PatternType(Pattern.compile("^##\\s+(.+)$"), "H2"));
        patterns.add(new PatternType(Pattern.compile("^#\\s+(.+)$"), "H1"));
        patterns.add(new PatternType(Pattern.compile("^[+*]\\s+(.+)$"), "LIST"));
        patterns.add(new PatternType(Pattern.compile("^\\s*(?![#*+])(.*)$"), "TEXT"));
    }

    private static class PatternType {
        public Pattern pattern;
        public String type;

        public PatternType(Pattern pattern, String type) {
            this.pattern = pattern;
            this.type = type;
        }
    }
}

