/*
 * Decompiled with CFR 0.152.
 */
package deus.guidebookmd.gui;

import deus.guidebookmd.components.MDComponent;
import deus.guidebookmd.config.PageConfig;
import deus.guidebookmd.formats.MarkdownCompiler;
import deus.guidebookmd.gui.MDPage;
import deus.guidebookmd.gui.MarkdownGuidebook;
import deus.guidebookmd.gui.elements.PageButton;
import deus.guidebookmd.gui.elements.TextEditor;
import java.util.ArrayList;
import java.util.List;

public class MDEditablePage
extends MDPage {
    public boolean editable = true;
    public boolean canEdit = true;
    public TextEditor textArea = new TextEditor();
    private PageButton deleteButton = null;
    private PageButton lockButton = new PageButton("guidebookmd:gui/hud/lock");
    private PageButton moveLeftButton = null;
    private PageButton moveRightButton = null;
    private final PageButton[] buttons;

    public MDEditablePage(PageConfig config, List<MDComponent> mdComponents) {
        super(config, mdComponents);
        this.deleteButton = new PageButton("guidebookmd:gui/hud/delete");
        this.moveLeftButton = new PageButton("guidebookmd:gui/hud/moveleft");
        this.moveRightButton = new PageButton("guidebookmd:gui/hud/moveright");
        this.buttons = new PageButton[]{this.lockButton, this.deleteButton, this.moveLeftButton, this.moveRightButton};
        this.moveLeftButton.onClick = this::moveLeft;
        this.moveRightButton.onClick = this::moveRight;
        this.deleteButton.onClick = this::delete;
        this.lockButton.onClick = this::lock;
        this.textArea.drawBackground = false;
        this.textArea.autoWrap = false;
        this.textArea.maxTextLength = 26;
        this.textArea.drawLineCount = false;
        this.textArea.textOffsetX = 2;
        this.textArea.maxLines = 22;
        this.disableScissor = true;
    }

    public MDEditablePage(PageConfig config, List<MDComponent> mdComponents, boolean editable) {
        this(config, mdComponents);
        this.editable = editable;
        if (!editable) {
            this.editable = true;
            this.lock();
            this.lockButton.texture = "guidebookmd:gui/hud/blocked_lock";
            this.editable = false;
            this.lockButton.disabled = true;
            this.deleteButton.disabled = true;
            this.moveLeftButton.disabled = true;
            this.moveRightButton.disabled = true;
        }
    }

    @Override
    public void render(int textXPos, int textYPos, int pageXTexturePos) {
        super.render(textXPos, textYPos, pageXTexturePos);
        this.textArea.x = this.x + textXPos;
        this.textArea.y = this.y + textYPos;
        PageConfig pageConfig = this.config == null ? this.screen.config.defaultPageConfig : this.config;
        this.textArea.width = pageConfig.pageTextureWidth - 15;
        this.textArea.height = pageConfig.pageTextureHeight - 10;
        int buttonY = this.y + textYPos - 20;
        int startX = this.x + textXPos + pageConfig.pageTextureWidth - 128;
        int base = 16;
        this.lockButton.x = startX;
        this.deleteButton.x = startX + base;
        this.moveLeftButton.x = startX + base * 2;
        this.moveRightButton.x = startX + base * 3;
        this.moveRightButton.y = this.moveLeftButton.y = buttonY;
        this.deleteButton.y = this.moveLeftButton.y;
        this.lockButton.y = this.moveLeftButton.y;
        for (PageButton button : this.buttons) {
            button.updateMousePos(this.mx, this.my);
            button.render();
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.canEdit) {
            this.textArea.updateMousePos(this.mx, this.my);
            this.textArea.update();
        }
    }

    @Override
    protected void drawMarkdown(int textXPos, int textYPos, boolean centered, boolean centeredMaxWidth) {
        if (this.canEdit) {
            this.textArea.render();
        } else {
            super.drawMarkdown(textXPos, textYPos, centered, centeredMaxWidth);
        }
    }

    @Override
    public void mouseClick(int mx, int my) {
        super.mouseClick(mx, my);
        for (PageButton button : this.buttons) {
            button.mouseClick(mx, my);
        }
    }

    public boolean canEdit() {
        return this.editable && this.canEdit;
    }

    public void compileContent() {
        this.mdComponents = MarkdownCompiler.compile(this.textArea.getLines((boolean)false)).mdComponents;
        this.config = MarkdownCompiler.compile(this.textArea.getLines((boolean)false)).config;
    }

    public void moveLeft() {
        if (this.screen instanceof MarkdownGuidebook) {
            MarkdownGuidebook p = (MarkdownGuidebook)this.screen;
            if (this.number <= 0) {
                return;
            }
            MDEditablePage a = (MDEditablePage)((Object)p.pages.get(this.number));
            MDEditablePage b = (MDEditablePage)((Object)p.pages.get(this.number - 1));
            p.pages.set(this.number, b);
            p.pages.set(this.number - 1, a);
        }
    }

    public void moveRight() {
        if (this.screen instanceof MarkdownGuidebook) {
            MarkdownGuidebook p = (MarkdownGuidebook)this.screen;
            int index = p.currentPageNumber;
            if (index >= p.pages.size() - 1) {
                return;
            }
            MDEditablePage a = (MDEditablePage)((Object)p.pages.get(index));
            MDEditablePage b = (MDEditablePage)((Object)p.pages.get(index + 1));
            p.pages.set(index, b);
            p.pages.set(index + 1, a);
        }
    }

    public void delete() {
        if (this.screen instanceof MarkdownGuidebook) {
            MarkdownGuidebook p = (MarkdownGuidebook)this.screen;
            if (this.canEdit && p.pages.size() > 1) {
                int index = p.pages.indexOf((Object)this);
                p.pages.remove((Object)this);
                p.goTo(p.pages.size() - 1);
            }
        }
    }

    public void add() {
        if (this.screen instanceof MarkdownGuidebook) {
            MarkdownGuidebook p = (MarkdownGuidebook)this.screen;
            MDEditablePage page = new MDEditablePage(new PageConfig(), new ArrayList<MDComponent>());
            page.setScreen(this.screen);
            p.pages.add(page);
            p.goTo(p.pages.size() - 1);
        }
    }

    public void lock() {
        this.mdComponents = MarkdownCompiler.compile(this.textArea.getLines((boolean)true)).mdComponents;
        this.config = MarkdownCompiler.compile(this.textArea.getLines((boolean)false)).config;
        if (this.editable) {
            boolean bl = this.canEdit = !this.canEdit;
            if (this.canEdit) {
                this.lockButton.texture = "guidebookmd:gui/hud/lock";
                this.deleteButton.texture = "guidebookmd:gui/hud/delete";
            } else {
                this.lockButton.texture = "guidebookmd:gui/hud/unlock";
                this.deleteButton.texture = "guidebookmd:gui/hud/cant_delete";
            }
        }
    }
}

