/*
 * Decompiled with CFR 0.152.
 */
package deus.guidebookmd.gui;

import deus.guidebookmd.components.MDComponent;
import deus.guidebookmd.config.BookConfig;
import deus.guidebookmd.config.PageConfig;
import deus.guidebookmd.gui.MarkdownBook;
import deus.guidebookmd.gui.elements.MDGui;
import deus.guidebookmd.gui.elements.PageTurnIndicator;
import deus.guidebookmd.utils.RenderUtils;
import java.util.List;
import java.util.Objects;
import org.lwjgl.opengl.GL11;

public class MDPage
extends MDGui {
    public PageConfig config;
    public int number = 0;
    public boolean hasNextButton = true;
    public boolean hasPreviousButton = true;
    public MarkdownBook screen;
    public boolean disableScissor = false;
    List<MDComponent> mdComponents;
    private final PageTurnIndicator button0 = new PageTurnIndicator(0, this);
    private final PageTurnIndicator button1 = new PageTurnIndicator(1, this);

    public MDPage(PageConfig config, List<MDComponent> mdComponents) {
        this.config = config;
        this.mdComponents = mdComponents;
    }

    public static void renderMarkdownComponents(List<MDComponent> page, int x, int y, int mouseX, int mouseY, int width, int yOffset, boolean centered, boolean centeredMaxWidth) {
        if (page == null || page.isEmpty()) {
            return;
        }
        int currentY = y;
        int maxWidth = 0;
        if (centeredMaxWidth) {
            for (MDComponent mdComponent : page) {
                maxWidth = Math.max(maxWidth, mdComponent.width);
            }
        }
        for (MDComponent mdComponent : page) {
            Objects.requireNonNull(mdComponent, "MDComponent cannot be null");
            int renderX = x;
            if (centered) {
                renderX = centeredMaxWidth ? (width - maxWidth) / 2 + x : (width - mdComponent.width) / 2 + x;
            }
            mdComponent.render(renderX, currentY + yOffset, mouseX, mouseY);
            currentY += mdComponent.height;
        }
    }

    public void setScreen(MarkdownBook screen) {
        this.screen = screen;
    }

    public void render(int textXPos, int textYPos, int pageXTexturePos) {
        BookConfig bkConfig = this.screen.config;
        PageConfig pageConfig = this.config == null ? bkConfig.defaultPageConfig : this.config;
        this.mc.textureManager.loadTexture(pageConfig.pageTexture).bind();
        this.button0.texture = pageConfig.pageTexture;
        this.button1.texture = pageConfig.pageTexture;
        this.drawTexturedModalRect(this.x + pageXTexturePos, this.y, 0, 0, pageConfig.pageTextureWidth, pageConfig.pageTextureHeight);
        this.drawString(this.mc.font, "" + this.number, this.x + textXPos, this.y - 9, 0xFFFFFF);
        if (!this.disableScissor) {
            GL11.glEnable((int)3089);
            RenderUtils.applyScissor(this.mc, this.x + textXPos, this.y, pageConfig.scissorWH[0], pageConfig.scissorWH[1], this.screen.width, this.screen.height);
        }
        this.drawMarkdown(this.x + textXPos, textYPos, pageConfig.centered, this.screen.centeredMaxWidth);
        if (!this.disableScissor) {
            GL11.glDisable((int)3089);
        }
        if (this.hasNextButton) {
            this.button0.x = this.x + pageXTexturePos + 24;
            this.button0.y = this.y + pageConfig.pageTextureHeight;
            this.button0.render();
        }
        if (this.hasPreviousButton) {
            this.button1.x = this.x + pageXTexturePos + pageConfig.pageTextureWidth;
            this.button1.y = this.y + pageConfig.pageTextureHeight;
            this.button1.render();
        }
    }

    protected void drawMarkdown(int textXPos, int textYPos, boolean centered, boolean centeredMaxWidth) {
        MDPage.renderMarkdownComponents(this.mdComponents, textXPos, textYPos, this.mx, this.my, this.screen.width, this.screen.yOffset, centered, centeredMaxWidth);
    }

    @Override
    public void updateMousePos(int mx, int my) {
        super.updateMousePos(mx, my);
        this.button0.updateMousePos(mx, my);
        this.button1.updateMousePos(mx, my);
    }

    @Override
    public void mouseClick(int mx, int my) {
        super.mouseClick(mx, my);
        this.button0.mouseClick(mx, my);
        this.button1.mouseClick(mx, my);
    }
}

