/*
 * Decompiled with CFR 0.152.
 */
package deus.guidebookmd.gui.elements;

import deus.guidebookmd.gui.elements.MDGui;
import deus.guidebookmd.utils.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class TextEditor
extends MDGui {
    private boolean wasClicked = false;
    private boolean wasClickedOut = false;
    private boolean focused = false;
    protected List<Character> characters = new ArrayList<Character>();
    protected final List<List<Character>> undoStack = new ArrayList<List<Character>>();
    protected final List<List<Character>> redoStack = new ArrayList<List<Character>>();
    public int maxUndoHistory = 100;
    protected int currentCharPos = 0;
    protected int currentLine = 1;
    protected int currentLineCharCount = 1;
    protected final List<List<Character>> clipboard = new ArrayList<List<Character>>();
    protected boolean isSelecting = false;
    protected int selectStartChar = 0;
    protected int selectLastChar = 0;
    public boolean drawBackground = true;
    public boolean drawBorder = true;
    public boolean drawLineCharCount = true;
    public boolean drawLineCount = true;
    public boolean drawExtraCursors = true;
    protected int cursorX = 0;
    protected int cursorY = 0;
    int cursorBlinkInterval = 500;
    private long lastCursorToggle = 0L;
    public boolean drawCursor = true;
    public boolean animateCursor = true;
    String cursorCharacter = "_";
    String charCursorCharacter = ".";
    String lineCursorCharacter = "|";
    public boolean autoWrap = true;
    public int maxTextLength = 20;
    public int maxLines = 22;
    public int minTextOffsetx;
    public int textOffsetX = this.minTextOffsetx = 12;
    public int focusBackgroundColor = -16777216;
    public int focusTextColor = -1457046;
    public int focusBorderColor = -1457046;
    public int backgroundColor = -16777216;
    public int textColor = -1;
    public int borderColor = -1;
    public int cursorColor = -1;
    public int lineCountColor = 0xB2B3B3;
    protected boolean isCtrl = false;
    protected boolean isShift = false;
    public final Signal<List<Character>> $onTextChanged = new Signal();

    public TextEditor() {
        this.currentCharPos = this.characters.size();
        this.$onTextChanged.connect((s, chars) -> {
            if (!this.undoStack.isEmpty() && this.undoStack.get(this.undoStack.size() - 1).equals(this.characters)) {
                return;
            }
            this.undoStack.add(new ArrayList<Character>(this.characters));
            if (this.undoStack.size() > this.maxUndoHistory) {
                this.undoStack.remove(0);
            }
            this.redoStack.clear();
        });
    }

    public List<Character> cloneContent() {
        return new ArrayList<Character>(this.characters);
    }

    public void setContent(List<Character> characters) {
        this.characters = characters;
    }

    protected void paste() {
        if (!this.clipboard.isEmpty()) {
            this.$onTextChanged.emit(this.characters);
            this.characters.addAll(this.currentCharPos, (Collection<Character>)this.clipboard.get(this.clipboard.size() - 1));
            this.currentCharPos = this.characters.size();
        }
    }

    protected void copy(int start, int end) {
        int from = Math.min(start, end);
        int to = Math.max(start, end);
        this.clipboard.add(new ArrayList<Character>(this.characters.subList(from, to)));
    }

    protected void cut(int start, int end) {
        this.$onTextChanged.emit(this.characters);
        this.copy(start, end);
        int from = Math.min(start, end);
        int to = Math.max(start, end);
        for (int i = 0; i < to - from; ++i) {
            this.characters.remove(from);
        }
    }

    protected void undo() {
        if (!this.undoStack.isEmpty()) {
            this.redoStack.add(new ArrayList<Character>(this.characters));
            this.characters = this.undoStack.remove(this.undoStack.size() - 1);
            this.currentCharPos = Math.min(this.currentCharPos, this.characters.size());
        }
    }

    protected void redo() {
        if (!this.redoStack.isEmpty()) {
            // empty if block
        }
    }

    protected void deleteSequence(int start, int end) {
        this.$onTextChanged.emit(this.characters);
        int from = Math.min(start, end);
        int to = Math.max(start, end);
        for (int i = 0; i < to - from; ++i) {
            this.characters.remove(from);
        }
    }

    private void deleteWord() {
        this.$onTextChanged.emit(this.characters);
        while (!(this.isAtEnd() || this.isSpace(this.peek()) || this.wordDeleteIgnore(this.peek()))) {
            this.deleteCharacter();
        }
    }

    protected void drawBackground() {
        int backgroundColor = this.focused ? this.focusBackgroundColor : this.backgroundColor;
        this.drawRect(this.x, this.y, this.x + this.width + this.textOffsetX, this.y + this.height, backgroundColor);
    }

    protected void drawBorder() {
        int borderColor = this.focused ? this.focusBorderColor : this.borderColor;
        int left = this.x;
        int right = this.x + this.width + this.textOffsetX;
        int top = this.y;
        int bottom = this.y + this.height;
        this.drawRect(left, top - 1, right, top, borderColor);
        this.drawRect(left, bottom, right, bottom + 1, borderColor);
        this.drawRect(left - 1, top, left, bottom, borderColor);
        this.drawRect(right, top, right + 1, bottom, borderColor);
    }

    protected void drawText() {
        int i;
        int textColor = this.focused ? this.focusTextColor : this.textColor;
        int lineHeight = this.mc.font.fontHeight;
        int textStartY = this.y + 4;
        StringBuilder lineBuffer = new StringBuilder();
        int drawY = textStartY;
        int lineCharCount = 0;
        int cursorLine = 0;
        int pixelX = 0;
        int tempCharPos = 0;
        this.cursorX = 4;
        this.cursorY = 4;
        for (i = 0; i < this.characters.size(); ++i) {
            char c;
            if (tempCharPos == this.currentCharPos) {
                this.cursorX = this.textOffsetX + pixelX;
                this.cursorY = 4 + cursorLine * lineHeight;
            }
            if ((c = this.characters.get(i).charValue()) == '\n' || lineCharCount >= this.maxTextLength && cursorLine < this.maxLines + 1) {
                this.drawString(this.mc.font, lineBuffer.toString(), this.x + this.textOffsetX, drawY, textColor);
                drawY += lineHeight;
                lineBuffer.setLength(0);
                lineCharCount = 0;
                pixelX = 0;
                ++cursorLine;
                if (c != '\n') {
                    lineBuffer.append(c);
                    pixelX += this.mc.font.getCharWidth(c);
                    ++lineCharCount;
                }
            } else if (cursorLine < this.maxLines + 1) {
                lineBuffer.append(c);
                pixelX += this.mc.font.getCharWidth(c);
                ++lineCharCount;
            }
            ++tempCharPos;
        }
        if (this.currentCharPos == this.characters.size()) {
            this.cursorX = this.textOffsetX + pixelX;
            this.cursorY = 4 + cursorLine * lineHeight;
        }
        this.currentLineCharCount = lineCharCount;
        this.currentLine = cursorLine + 1;
        if (this.drawLineCount) {
            for (i = 0; i < cursorLine + 1; ++i) {
                this.drawString(this.mc.font, "" + i, this.x, this.y + 4 + i * this.mc.font.fontHeight, this.lineCountColor);
            }
        }
        if (lineBuffer.length() > 0) {
            this.drawString(this.mc.font, lineBuffer.toString(), this.x + this.textOffsetX, drawY, textColor);
        }
    }

    protected void drawCursor() {
        this.drawString(this.mc.font, this.cursorCharacter, this.x + this.cursorX, this.y + this.cursorY, this.cursorColor);
    }

    protected void drawAlternativeCursors() {
        this.drawString(this.mc.font, this.lineCursorCharacter, this.x + this.width - 1 + this.textOffsetX, this.y + this.cursorY, 0xFF0000);
        this.drawString(this.mc.font, this.charCursorCharacter, this.x + this.cursorX, this.y - 7, 0xFF0000);
    }

    protected void drawLineCharCount() {
        String lineCharCount = String.valueOf(this.currentLineCharCount);
        this.drawString(this.mc.font, lineCharCount, this.x + this.cursorX, this.y + this.cursorY + this.mc.font.fontHeight, this.lineCountColor);
    }

    @Override
    public void render() {
        if (this.drawBackground) {
            this.drawBackground();
        }
        if (this.drawBorder) {
            this.drawBorder();
        }
        if (this.drawLineCharCount) {
            this.drawLineCharCount();
        }
        this.drawText();
        if (this.drawCursor) {
            this.drawCursor();
        }
        if (this.drawExtraCursors) {
            this.drawAlternativeCursors();
        }
    }

    @Override
    public void updateMousePos(int mx, int my) {
        super.updateMousePos(mx, my);
        boolean hovered = this.isHovered();
        boolean buttonDown = Mouse.isButtonDown((int)0);
        if (hovered) {
            if (buttonDown) {
                if (!this.wasClicked) {
                    this.onPush();
                    this.wasClicked = true;
                }
                this.whilePressed();
                this.wasClickedOut = false;
            } else {
                if (this.wasClicked) {
                    this.onRelease();
                    this.wasClicked = false;
                }
                if (buttonDown) {
                    if (!this.wasClickedOut) {
                        this.onPushOut();
                        this.wasClickedOut = true;
                    }
                } else {
                    this.wasClickedOut = false;
                }
            }
        } else if (buttonDown) {
            if (!this.wasClickedOut) {
                this.onPushOut();
                this.wasClickedOut = true;
            }
        } else {
            this.wasClicked = false;
            this.wasClickedOut = false;
        }
    }

    @Override
    public void update() {
        long currentTime;
        if (this.autoWrap) {
            this.maxTextLength = this.width / 6 - 1;
        }
        this.isCtrl = Keyboard.isKeyDown((int)Keyboard.KEY_LCONTROL);
        this.isShift = Keyboard.isKeyDown((int)Keyboard.KEY_LSHIFT);
        if (this.drawLineCount) {
            this.textOffsetX = Math.max(this.minTextOffsetx, this.mc.font.getStringWidth("" + this.currentLine) + 1);
        }
        if (!this.focused) {
            return;
        }
        if (this.animateCursor && (currentTime = System.currentTimeMillis()) - this.lastCursorToggle > (long)this.cursorBlinkInterval) {
            this.drawCursor = !this.drawCursor;
            this.lastCursorToggle = currentTime;
        }
        if (Keyboard.isKeyDown((int)Keyboard.KEY_LCONTROL) && Keyboard.isKeyDown((int)Keyboard.KEY_BACK)) {
            this.deleteWord();
            return;
        }
        if (Keyboard.isKeyDown((int)Keyboard.KEY_LCONTROL) && Keyboard.isKeyDown((int)Keyboard.KEY_DELETE)) {
            this.deleteWord();
            return;
        }
        while (Keyboard.next()) {
            if (!Keyboard.getEventKeyState()) continue;
            int key = Keyboard.getEventKey();
            char character = Keyboard.getEventCharacter();
            if (this.isShift && key == Keyboard.KEY_LEFT) {
                if (!this.isSelecting) {
                    this.selectStartChar = this.currentCharPos;
                    this.isSelecting = true;
                }
                if (this.currentCharPos > 0) {
                    --this.currentCharPos;
                }
                this.selectLastChar = this.currentCharPos;
                return;
            }
            if (this.isShift && key == Keyboard.KEY_RIGHT) {
                if (!this.isSelecting) {
                    this.selectStartChar = this.currentCharPos;
                    this.isSelecting = true;
                }
                if (this.currentCharPos < this.characters.size()) {
                    ++this.currentCharPos;
                }
                this.selectLastChar = this.currentCharPos;
                return;
            }
            if (key == Keyboard.KEY_C && this.isCtrl) {
                if (this.selectStartChar != this.selectLastChar) {
                    this.copy(this.selectStartChar, this.selectLastChar);
                }
                return;
            }
            if (this.isCtrl && Keyboard.isKeyDown((int)Keyboard.KEY_V)) {
                this.paste();
                this.isSelecting = false;
                continue;
            }
            if (this.isCtrl && Keyboard.isKeyDown((int)Keyboard.KEY_Z)) {
                this.undo();
                continue;
            }
            if (this.isCtrl && Keyboard.isKeyDown((int)Keyboard.KEY_Y)) {
                this.redo();
                continue;
            }
            if (this.isCtrl && Keyboard.isKeyDown((int)Keyboard.KEY_END)) {
                this.currentCharPos = this.characters.size() - 1;
                continue;
            }
            if (this.isCtrl && Keyboard.isKeyDown((int)Keyboard.KEY_HOME)) {
                this.currentCharPos = 0;
                continue;
            }
            if (this.isShift && key == Keyboard.KEY_BACK) {
                this.deleteSequence(this.selectStartChar, this.selectLastChar);
                return;
            }
            if (key == Keyboard.KEY_BACK) {
                this.deleteCharacter();
                continue;
            }
            if (key == Keyboard.KEY_ESCAPE) {
                this.focused = false;
                continue;
            }
            if (key == Keyboard.KEY_RETURN) {
                this.jumpLine();
                continue;
            }
            if (key == Keyboard.KEY_LEFT) {
                if (this.currentCharPos <= 0) continue;
                --this.currentCharPos;
                continue;
            }
            if (key == Keyboard.KEY_RIGHT) {
                if (this.currentCharPos >= this.characters.size()) continue;
                ++this.currentCharPos;
                continue;
            }
            if (key == Keyboard.KEY_UP || key == Keyboard.KEY_DOWN) continue;
            if (key == Keyboard.KEY_END) {
                this.currentCharPos = this.getEndOfCurrentLineCharPos();
                continue;
            }
            if (key == Keyboard.KEY_HOME) {
                this.currentCharPos = this.getCurrentLineCharPos();
                continue;
            }
            if (!Character.isDefined(character) || Character.isISOControl(character)) continue;
            this.addCharacter(character);
        }
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\n';
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean wordDeleteIgnore(char c) {
        return this.isSpace(c) || c == '.' || c == ',';
    }

    private boolean isAtEnd() {
        return this.currentCharPos <= 0;
    }

    private char peek() {
        if (this.currentCharPos < 0) {
            return '\u0000';
        }
        return this.characters.get(this.currentCharPos - 1).charValue();
    }

    private char peekPrev() {
        if (this.characters.isEmpty()) {
            return '\u0000';
        }
        return this.characters.get(this.currentCharPos - 2).charValue();
    }

    public boolean isFocused() {
        return this.focused;
    }

    public boolean isHovered() {
        return this.mx >= this.x && this.my >= this.y && this.mx < this.x + this.width && this.my < this.y + this.height;
    }

    private void addCharacter(char character) {
        if (this.currentLine <= this.maxLines + 1) {
            this.$onTextChanged.emit(this.characters);
            this.characters.add(this.currentCharPos, Character.valueOf(character));
            ++this.currentCharPos;
        }
    }

    private void deleteCharacter() {
        if (this.focused && this.currentCharPos > 0) {
            this.$onTextChanged.emit(this.characters);
            this.characters.remove(this.currentCharPos - 1);
            --this.currentCharPos;
        }
    }

    private void jumpLine() {
        if (this.currentLine - 1 >= this.maxLines) {
            return;
        }
        this.$onTextChanged.emit(this.characters);
        this.characters.add(this.currentCharPos, Character.valueOf('\n'));
        ++this.currentCharPos;
    }

    public List<String> getLines(boolean maxTextLengthSeparator) {
        return TextEditor.getLines(this.characters, this.maxTextLength, maxTextLengthSeparator);
    }

    public static List<String> getLines(List<Character> characters, int maxTextLength, boolean maxTextLengthSeparator) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder lineBuffer = new StringBuilder();
        int lineCharCount = 0;
        boolean startsWithExclamation = false;
        for (char c : characters) {
            if (lineBuffer.length() == 0 && c == '!') {
                startsWithExclamation = true;
            }
            if (c == '\n') {
                lines.add(lineBuffer.toString());
                lineBuffer.setLength(0);
                lineCharCount = 0;
                startsWithExclamation = false;
                continue;
            }
            lineBuffer.append(c);
            if (!maxTextLengthSeparator || ++lineCharCount < maxTextLength || startsWithExclamation) continue;
            lines.add(lineBuffer.toString());
            lineBuffer.setLength(0);
            lineCharCount = 0;
        }
        if (lineBuffer.length() > 0) {
            lines.add(lineBuffer.toString());
        }
        return lines;
    }

    public String getContentAsString() {
        StringBuilder sb = new StringBuilder();
        for (Character character : this.characters) {
            sb.append(character);
        }
        return sb.toString();
    }

    private int getCharAt(int charX, int line) {
        return line * this.maxTextLength + charX;
    }

    private int getEndOfCurrentLineCharPos() {
        int i;
        for (i = this.getCurrentLineCharPos(); i < this.characters.size() && this.characters.get(i).charValue() != '\n'; ++i) {
        }
        return i;
    }

    private int getCurrentLineCharPos() {
        if (this.currentCharPos <= 0) {
            return 0;
        }
        if (this.currentCharPos >= this.characters.size()) {
            this.currentCharPos = this.characters.size() - 1;
        }
        for (int i = this.currentCharPos; i >= 0; --i) {
            if (i == 0 || this.characters.get(i - 1).charValue() != '\n') continue;
            return i;
        }
        return this.currentCharPos;
    }

    int charIndexInLine() {
        int startOfLine = this.getCurrentLineCharPos();
        return this.currentCharPos - startOfLine;
    }

    private int getLineNumber() {
        int line = 0;
        for (int i = 0; i < this.currentCharPos; ++i) {
            if (this.characters.get(i).charValue() != '\n') continue;
            ++line;
        }
        return line;
    }

    public static String fuseStrings(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String character : strings) {
            sb.append(character);
        }
        return sb.toString();
    }

    private int getLineCharCount(int targetLine) {
        if (targetLine >= this.maxLines) {
            return 0;
        }
        int currentLine = 0;
        int currentLineCharCount = 0;
        for (int i = 0; i < this.characters.size(); ++i) {
            char c = this.characters.get(i).charValue();
            if (c == '\n' || currentLineCharCount >= this.maxTextLength) {
                if (currentLine == targetLine) {
                    return currentLineCharCount;
                }
                ++currentLine;
                currentLineCharCount = 0;
                if (c != '\n') {
                    currentLineCharCount = 1;
                }
                if (currentLine <= targetLine) continue;
                break;
            }
            ++currentLineCharCount;
        }
        if (currentLine == targetLine) {
            return currentLineCharCount;
        }
        return 0;
    }

    public void whilePressed() {
    }

    public void onPush() {
        this.focused = true;
    }

    public void onPushOut() {
        this.focused = false;
    }

    public void onRelease() {
    }
}

