/*
 * Decompiled with CFR 0.152.
 */
package deus.guidebookmd.utils;

import deus.guidebookmd.Guidebookmd;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RLoading {
    public static List<String> loadMarkdownFilesFromFolderName(String name) {
        Objects.requireNonNull(name, "Folder name cannot be null");
        String folderPath = Guidebookmd.BOOKS_DIRECTORY + "load/" + name + "/";
        Path dir = Paths.get(folderPath, new String[0]).normalize();
        if (!dir.startsWith(Paths.get(Guidebookmd.BOOKS_DIRECTORY, new String[0]))) {
            Guidebookmd.LOGGER.error("Invalid folder name '{}' attempted path traversal", (Object)name);
            throw new RuntimeException("Invalid folder name: attempted path traversal: " + name);
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            Guidebookmd.LOGGER.error("Folder does not exist: {}", (Object)folderPath);
            throw new RuntimeException("Folder does not exist: " + folderPath);
        }
        ArrayList<String> pages = new ArrayList<String>();
        try {
            File[] files = dir.toFile().listFiles((file, fileName) -> fileName.toLowerCase().endsWith(".md"));
            if (files == null || files.length == 0) {
                Guidebookmd.LOGGER.warn("No Markdown files found in folder: {}", (Object)folderPath);
                return pages;
            }
            for (File file2 : files) {
                try (BufferedReader reader = new BufferedReader(new FileReader(file2));){
                    String content = reader.lines().collect(Collectors.joining("\n"));
                    Guidebookmd.LOGGER.info("Read {} characters from {}", (Object)content.length(), (Object)file2.getPath());
                    pages.add(content);
                }
                catch (IOException e) {
                    Guidebookmd.LOGGER.error("Error reading Markdown file {}: {}", (Object)file2.getPath(), (Object)e.getMessage());
                }
            }
            if (pages.isEmpty()) {
                Guidebookmd.LOGGER.warn("No valid Markdown files read from folder: {}", (Object)folderPath);
            } else {
                Guidebookmd.LOGGER.info("Successfully read {} pages from folder: {}", (Object)pages.size(), (Object)folderPath);
            }
            return pages;
        }
        catch (Exception e) {
            Guidebookmd.LOGGER.error("Failed to process folder {}: {}", (Object)folderPath, (Object)e.getMessage());
            throw new RuntimeException("Error processing folder: " + folderPath, e);
        }
    }
}

