/*
 * Decompiled with CFR 0.152.
 */
package deus.guidebookmd.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Signal<T> {
    private final List<Listener<T>> listeners = new ArrayList<Listener<T>>();
    private final List<Listener<T>> removeQueue = new ArrayList<Listener<T>>();
    private boolean emitting = false;
    public boolean silenced = false;

    public List<Listener<T>> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void connect(Listener<T> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void disconnect(Listener<T> listener) {
        if (!this.emitting) {
            this.listeners.remove(listener);
        } else {
            this.removeQueue.add(listener);
        }
    }

    public void emit(T t) {
        if (!this.silenced) {
            this.emitting = true;
            for (Listener<T> listener : new ArrayList<Listener<T>>(this.listeners)) {
                listener.signalEmitted(this, t);
            }
            for (Listener<T> listener : this.removeQueue) {
                this.listeners.remove(listener);
            }
            this.removeQueue.clear();
            this.emitting = false;
        }
    }

    public static interface Listener<T> {
        public void signalEmitted(Signal<T> var1, T var2);
    }
}

