/*
 * Decompiled with CFR 0.152.
 */
package harderbeds.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModConfig {
    public static final Logger LOGGER;
    private static final String SETTINGS_FILE = "harderbeds/settings.json";
    private static final Gson GSON;
    private static HarderBedsSettings settings;
    private static final List<String> configErrors;
    public static boolean isInitialized;

    public static HarderBedsSettings getSettings() {
        if (settings == null) {
            LOGGER.error("CRITICAL: Settings accessed before initialization or after a critical failure. Using emergency defaults.");
            settings = new HarderBedsSettings();
        }
        return settings;
    }

    public static void saveSettings() {
        if (!isInitialized) {
            LOGGER.error("Attempted to save settings before initialization.");
            return;
        }
        try {
            Path settingsPath = FabricLoader.getInstance().getConfigDir().resolve(SETTINGS_FILE);
            ModConfig.saveSettingsConfig(settingsPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void loadOrCreateSettingsConfig() {
        Path settingsPath = FabricLoader.getInstance().getConfigDir().resolve(SETTINGS_FILE);
        try {
            Path configDir = settingsPath.getParent();
            if (configDir != null && !Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            if (!Files.exists(settingsPath, new LinkOption[0])) {
                LOGGER.info("Creating default settings file for HarderBeds.");
                ModConfig.createDefaultSettingsConfig(settingsPath);
            } else {
                LOGGER.info("Loading HarderBeds settings from file.");
                ModConfig.loadSettingsFromFile(settingsPath);
            }
        }
        catch (Exception e) {
            String error = "Failed to load or create settings config: " + e.getMessage();
            LOGGER.error(error, (Throwable)e);
            configErrors.add(error);
            settings = new HarderBedsSettings();
        }
    }

    private static void createDefaultSettingsConfig(Path settingsPath) throws IOException {
        settings = new HarderBedsSettings();
        ModConfig.saveSettingsConfig(settingsPath);
    }

    private static void loadSettingsFromFile(Path settingsPath) throws IOException {
        try {
            String content = Files.readString(settingsPath, StandardCharsets.UTF_8);
            settings = (HarderBedsSettings)GSON.fromJson(content, HarderBedsSettings.class);
            if (settings == null) {
                LOGGER.warn("Settings file was empty or corrupted. Reverting to default settings.");
                configErrors.add("Settings file was empty or corrupted. Reverted to defaults.");
                ModConfig.createDefaultSettingsConfig(settingsPath);
            }
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Malformed JSON in settings file. Reverting to defaults.", (Throwable)e);
            configErrors.add("Malformed JSON in settings file: " + e.getMessage() + ". Reverted to defaults.");
            ModConfig.createDefaultSettingsConfig(settingsPath);
        }
    }

    private static void saveSettingsConfig(Path settingsPath) throws IOException {
        if (settings == null) {
            LOGGER.warn("Attempted to save null settings, initializing to defaults first.");
            settings = new HarderBedsSettings();
        }
        try {
            Path parentDir = settingsPath.getParent();
            if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            if (Files.exists(settingsPath, new LinkOption[0])) {
                Path backupPath = settingsPath.resolveSibling(String.valueOf(settingsPath.getFileName()) + ".backup");
                Files.copy(settingsPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
            }
            String jsonString = GSON.toJson((Object)settings);
            Path tempFile = settingsPath.resolveSibling(String.valueOf(settingsPath.getFileName()) + ".tmp");
            Files.writeString(tempFile, (CharSequence)jsonString, StandardCharsets.UTF_8, new OpenOption[0]);
            Files.move(tempFile, settingsPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            String error = "Failed to save settings config: " + e.getMessage();
            LOGGER.error(error, (Throwable)e);
            configErrors.add(error);
            throw e;
        }
    }

    static {
        block2: {
            LOGGER = LoggerFactory.getLogger((String)"harderbeds");
            GSON = new GsonBuilder().setPrettyPrinting().create();
            configErrors = new ArrayList<String>();
            isInitialized = false;
            try {
                ModConfig.loadOrCreateSettingsConfig();
                isInitialized = true;
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize HarderBeds config", (Throwable)e);
                configErrors.add("Critical initialization error: " + e.getMessage());
                if (settings != null) break block2;
                settings = new HarderBedsSettings();
            }
        }
    }

    public static class HarderBedsSettings {
        private boolean simulateMobPathingOnSleep = true;
        private boolean visualizeMobPath = true;
        private boolean preventBedDropInVillages = true;
        private boolean enableVillageBedPenalty = true;
        private boolean disablePhantomSpawning = true;

        public boolean shouldSimulateMobPathingOnSleep() {
            return this.simulateMobPathingOnSleep;
        }

        public void setSimulateMobPathingOnSleep(boolean simulateMobPathingOnSleep) {
            this.simulateMobPathingOnSleep = simulateMobPathingOnSleep;
        }

        public boolean isMobPathVisualizationEnabled() {
            return this.visualizeMobPath;
        }

        public void setVisualizeMobPath(boolean visualizeMobPath) {
            this.visualizeMobPath = visualizeMobPath;
        }

        public boolean shouldPreventBedDropInVillages() {
            return this.preventBedDropInVillages;
        }

        public void setPreventBedDropInVillages(boolean preventBedDropInVillages) {
            this.preventBedDropInVillages = preventBedDropInVillages;
        }

        public boolean isVillageBedPenaltyEnabled() {
            return this.enableVillageBedPenalty;
        }

        public void setEnableVillageBedPenalty(boolean enableVillageBedPenalty) {
            this.enableVillageBedPenalty = enableVillageBedPenalty;
        }

        public boolean isPhantomSpawningDisabled() {
            return this.disablePhantomSpawning;
        }

        public void setPhantomSpawningDisabled(boolean disablePhantomSpawning) {
            this.disablePhantomSpawning = disablePhantomSpawning;
        }
    }
}

