/*
 * Decompiled with CFR 0.152.
 */
package harderbeds.util;

import harderbeds.config.ModConfig;
import harderbeds.util.CheckBedLocation;
import net.minecraft.class_11;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1972;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9;

public class BedSafetyChecker {
    private static final int HORIZONTAL_SEARCH_RADIUS = 20;
    private static final int VERTICAL_SEARCH_RADIUS = 10;
    private static final int INNER_EXCLUSION_RADIUS = 3;
    private static final int MIN_LIGHT_LEVEL = 8;

    public static boolean isBedAllowed(class_1937 world, class_2338 bedPos) {
        return !CheckBedLocation.isWithinVillageStructure(world, bedPos);
    }

    public static boolean isBedSafe(class_1937 world, class_2338 bedPos, class_1657 player) {
        if (world.method_8608() || !(world instanceof class_3218)) {
            return true;
        }
        class_3218 serverWorld = (class_3218)world;
        if (serverWorld.method_8407() == class_1267.field_5801) {
            return true;
        }
        class_6880 biomeEntry = world.method_23753(bedPos);
        if (biomeEntry.method_40225(class_1972.field_9462)) {
            return true;
        }
        class_2338 potentialSpawnPos = BedSafetyChecker.findSpawnLocationAndPathing(serverWorld, bedPos, player);
        return potentialSpawnPos == null;
    }

    private static class_2338 findSpawnLocationAndPathing(class_3218 world, class_2338 bedPos, class_1657 player) {
        class_5819 random = world.method_8409();
        int horizontalRange = 41;
        int verticalRange = 21;
        int[] xCoords = new int[horizontalRange];
        int[] zCoords = new int[horizontalRange];
        for (int i = 0; i < horizontalRange; ++i) {
            xCoords[i] = bedPos.method_10263() - 20 + i;
            zCoords[i] = bedPos.method_10260() - 20 + i;
        }
        int topY = bedPos.method_10264() + 10;
        int bottomY = bedPos.method_10264() - 10;
        for (int y = topY; y >= bottomY; --y) {
            if (Math.abs(y - bedPos.method_10264()) <= 3) continue;
            BedSafetyChecker.shuffleArray(xCoords, random);
            BedSafetyChecker.shuffleArray(zCoords, random);
            for (int x : xCoords) {
                if (Math.abs(x - bedPos.method_10263()) <= 3) continue;
                for (int z : zCoords) {
                    class_2338.class_2339 testPos;
                    if (Math.abs(z - bedPos.method_10260()) <= 3 || !world.method_22340((class_2338)(testPos = new class_2338.class_2339(x, y, z))) || world.method_8320((class_2338)testPos).method_26215() || !world.method_8320((class_2338)testPos).method_26212((class_1922)world, (class_2338)testPos)) continue;
                    class_2338 abovePos = testPos.method_10084();
                    class_2338 twoAbovePos = testPos.method_10086(2);
                    if (!world.method_8320(abovePos).method_26215() || !world.method_8320(twoAbovePos).method_26215() || world.method_8314(class_1944.field_9282, abovePos) >= 8 || !BedSafetyChecker.canMobReachBed(world, testPos.method_10062(), bedPos, player)) continue;
                    return testPos.method_10062();
                }
            }
        }
        return null;
    }

    private static void shuffleArray(int[] array, class_5819 random) {
        for (int i = array.length - 1; i > 0; --i) {
            int j = random.method_43048(i + 1);
            int temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }

    private static boolean canMobReachBed(class_3218 world, class_2338 start, class_2338 target, class_1657 player) {
        class_1642 dummyMob = new class_1642(class_1299.field_6051, (class_1937)world);
        dummyMob.method_5803(true);
        dummyMob.method_5648(true);
        dummyMob.method_5942().method_6354(true);
        dummyMob.method_23327((double)start.method_10263() + 0.5, (double)start.method_10264(), (double)start.method_10260() + 0.5);
        dummyMob.method_5943((class_5425)world, world.method_8404(start), class_3730.field_16462, null);
        dummyMob.method_5980((class_1309)player);
        for (int i = 0; i < 2; ++i) {
            dummyMob.method_5773();
        }
        class_11 path = dummyMob.method_5942().method_6349((class_1297)player, 0);
        if (path == null) {
            return false;
        }
        if (path.method_38() < 2) {
            return false;
        }
        if (BedSafetyChecker.pathContainsBlockingDoor(path, (class_1937)world)) {
            return false;
        }
        if (path != null && path.method_21655() && ModConfig.getSettings().isMobPathVisualizationEnabled()) {
            BedSafetyChecker.spawnPathParticles(path, (class_1309)dummyMob);
            return true;
        }
        if (path != null) {
            class_9 endNode = path.method_45();
            class_2338 pathEndPos = new class_2338(endNode.field_40, endNode.field_39, endNode.field_38);
            double squaredDistance = target.method_10262((class_2382)pathEndPos);
            if (squaredDistance <= 1.0) {
                if (ModConfig.getSettings().isMobPathVisualizationEnabled()) {
                    BedSafetyChecker.spawnPathParticles(path, (class_1309)dummyMob);
                }
                return true;
            }
        }
        if (dummyMob != null) {
            dummyMob.method_31472();
            dummyMob = null;
        }
        return false;
    }

    private static boolean pathContainsBlockingDoor(class_11 path, class_1937 world) {
        for (int i = 0; i < path.method_38(); ++i) {
            Boolean open;
            class_9 node = path.method_40(i);
            class_2338 pos = new class_2338(node.field_40, node.field_39, node.field_38);
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof class_2323) || (open = (Boolean)state.method_11654((class_2769)class_2323.field_10945)) != null && open.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static void spawnPathParticles(class_11 path, class_1309 entityworld) {
        class_3218 serverWorld = (class_3218)entityworld.method_73183();
        class_9 endNode = path.method_45();
        class_2338 endPos = new class_2338((int)endNode.method_35496().method_10216(), (int)endNode.method_35496().method_10214(), (int)endNode.method_35496().method_10215());
        serverWorld.method_65096((class_2394)class_2398.field_11240, (double)endPos.method_10263() + 0.5, (double)endPos.method_10264() + 0.5, (double)endPos.method_10260() + 0.5, 30, 0.2, 0.2, 0.2, 0.0);
        int nodeCount = path.method_38();
        for (int i = 0; i < nodeCount; ++i) {
            class_9 node = path.method_40(i);
            class_2338 nodePos = new class_2338((int)node.method_35496().method_10216(), (int)node.method_35496().method_10214(), (int)node.method_35496().method_10215());
            serverWorld.method_65096((class_2394)class_2398.field_22246, (double)nodePos.method_10263() + 0.5, (double)nodePos.method_10264() + 0.5, (double)nodePos.method_10260() + 0.5, 20, 0.1, 0.1, 0.1, 0.0);
        }
    }
}

