/*
 * Decompiled with CFR 0.152.
 */
package me.wheelershigley.silktouchplus.data;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import me.wheelershigley.silktouchplus.SilkTouchPlus;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_131;
import net.minecraft.class_1799;
import net.minecraft.class_2203;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3542;
import net.minecraft.class_3837;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5651;
import net.minecraft.class_5652;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableObject;

public class CopyBlockEntityDataLootFunction
extends class_120 {
    public static final MapCodec<CopyBlockEntityDataLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> CopyBlockEntityDataLootFunction.method_53344((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_5652.field_45882.fieldOf("source").forGetter(function -> function.source), (App)Operation.CODEC.listOf().fieldOf("ops").forGetter(function -> function.operations))).apply((Applicative)instance, CopyBlockEntityDataLootFunction::new));
    private final class_5651 source;
    private final List<Operation> operations;

    protected CopyBlockEntityDataLootFunction(List<class_5341> conditions, class_5651 source, List<Operation> operations) {
        super(conditions);
        this.source = source;
        this.operations = List.copyOf(operations);
    }

    public class_5339<class_3837> method_29321() {
        return class_131.field_49443;
    }

    public class_1799 method_522(class_1799 stack, class_47 context) {
        class_2520 nbtElement = this.source.method_32440(context);
        if (nbtElement == null) {
            return stack;
        }
        MutableObject mutableObject = new MutableObject();
        Supplier<class_2520> supplier = () -> {
            if (mutableObject.getValue() == null) {
                mutableObject.setValue((Object)((class_9279)stack.method_58695(class_9334.field_49611, (Object)class_9279.field_49302)).method_57461());
            }
            return (class_2520)mutableObject.getValue();
        };
        this.operations.forEach(operation -> operation.execute(supplier, nbtElement));
        class_2487 nbtCompound = (class_2487)mutableObject.getValue();
        if (nbtCompound != null) {
            class_9279.method_57453((class_9331)class_9334.field_49611, (class_1799)stack, (class_2487)nbtCompound);
        }
        return stack;
    }

    public record Operation(class_2203.class_2209 parsedSourcePath, class_2203.class_2209 parsedTargetPath, Operator operator) {
        public static final Codec<Operation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2203.class_2209.field_50034.fieldOf("source").forGetter(Operation::parsedSourcePath), (App)class_2203.class_2209.field_50034.fieldOf("target").forGetter(Operation::parsedTargetPath), (App)Operator.CODEC.fieldOf("op").forGetter(Operation::operator)).apply((Applicative)instance, Operation::new));

        public void execute(Supplier<class_2520> itemNbtGetter, class_2520 sourceEntityNbt) {
            try {
                List list = this.parsedSourcePath.method_9366(sourceEntityNbt);
                if (!list.isEmpty()) {
                    this.operator.merge(itemNbtGetter.get(), this.parsedTargetPath, list);
                }
            }
            catch (CommandSyntaxException var4) {
                SilkTouchPlus.LOGGER.error("Error in BlockEntity LootFunction copy-execution.");
            }
        }
    }

    public static enum Operator implements class_3542
    {
        REPLACE("replace"){

            @Override
            public void merge(class_2520 itemNbt, class_2203.class_2209 targetPath, List<class_2520> sourceNbts) throws CommandSyntaxException {
                targetPath.method_35722(itemNbt, (class_2520)Iterables.getLast(sourceNbts));
            }
        }
        ,
        APPEND("append"){

            @Override
            public void merge(class_2520 itemNbt, class_2203.class_2209 targetPath, List<class_2520> sourceNbts) throws CommandSyntaxException {
                List list = targetPath.method_9367(itemNbt, class_2499::new);
                list.forEach(foundNbt -> {
                    if (foundNbt instanceof class_2499) {
                        sourceNbts.forEach(sourceNbt -> ((class_2499)foundNbt).add((Object)sourceNbt.method_10707()));
                    }
                });
            }
        }
        ,
        MERGE("merge"){

            @Override
            public void merge(class_2520 itemNbt, class_2203.class_2209 targetPath, List<class_2520> sourceNbts) throws CommandSyntaxException {
                List list = targetPath.method_9367(itemNbt, class_2487::new);
                list.forEach(foundNbt -> {
                    if (foundNbt instanceof class_2487) {
                        sourceNbts.forEach(sourceNbt -> {
                            if (sourceNbt instanceof class_2487) {
                                ((class_2487)foundNbt).method_10543((class_2487)sourceNbt);
                            }
                        });
                    }
                });
            }
        };

        public static final Codec<Operator> CODEC;
        private final String name;

        public abstract void merge(class_2520 var1, class_2203.class_2209 var2, List<class_2520> var3) throws CommandSyntaxException;

        private Operator(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Operator::values);
        }
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private final class_5651 source;
        private final List<Operation> operations = Lists.newArrayList();

        public Builder(class_5651 source) {
            this.source = source;
        }

        public Builder withOperation(String source, String target, Operator operator) {
            try {
                this.operations.add(new Operation(class_2203.class_2209.method_58472((String)source), class_2203.class_2209.method_58472((String)target), operator));
                return this;
            }
            catch (CommandSyntaxException var5) {
                throw new IllegalArgumentException(var5);
            }
        }

        public Builder withOperation(String source, String target) {
            return this.withOperation(source, target, Operator.REPLACE);
        }

        protected Builder getThisBuilder() {
            return this;
        }

        public class_117 method_515() {
            return new CopyBlockEntityDataLootFunction(this.method_526(), this.source, this.operations);
        }
    }
}

