/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.goldgolemlaunch.init;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mcreator.goldgolemlaunch.GoldGolemMod;
import net.mcreator.goldgolemlaunch.init.GoldGolemModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GoldGolemModVillagerProfessions {
    private static final Map<String, ProfessionPoiType> POI_TYPES = new HashMap<String, ProfessionPoiType>();
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"gold_golem");
    public static final RegistryObject<VillagerProfession> ARCHAEOLOGIST_VILLAGER = GoldGolemModVillagerProfessions.registerProfession("archaeologist_villager", () -> (Block)GoldGolemModBlocks.ARCHAEOLOGISTS_TABLE.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"block.gravel.break")));
    public static final RegistryObject<VillagerProfession> ENDO_EXPLORIST = GoldGolemModVillagerProfessions.registerProfession("endo_explorist", () -> (Block)GoldGolemModBlocks.ENDO_EXPLORIST_BLOCK.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"block.ender_chest.open")));
    public static final RegistryObject<VillagerProfession> VENDECOLORI_VILLAGER = GoldGolemModVillagerProfessions.registerProfession("vendecolori_villager", () -> (Block)GoldGolemModBlocks.VENDECOLORI_WORKBENCH.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"block.fire.extinguish")));
    public static final RegistryObject<VillagerProfession> STONE_VILLAGER = GoldGolemModVillagerProfessions.registerProfession("stone_villager", () -> (Block)GoldGolemModBlocks.STONE_VILLAGER_TABLE.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"block.stone.break")));
    public static final RegistryObject<VillagerProfession> ELITE_VILLAGER = GoldGolemModVillagerProfessions.registerProfession("elite_villager", () -> (Block)GoldGolemModBlocks.ELITE_VILLAGER_WORKBENCH.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.villager.work_cartographer")));

    private static RegistryObject<VillagerProfession> registerProfession(String name, Supplier<Block> block, Supplier<SoundEvent> soundEvent) {
        POI_TYPES.put(name, new ProfessionPoiType(block, null));
        return PROFESSIONS.register(name, () -> {
            Predicate<Holder> poiPredicate = poiTypeHolder -> GoldGolemModVillagerProfessions.POI_TYPES.get((Object)name).poiType != null && poiTypeHolder.get() == GoldGolemModVillagerProfessions.POI_TYPES.get((Object)name).poiType.get();
            return new VillagerProfession("gold_golem:" + name, poiPredicate, poiPredicate, ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)soundEvent.get());
        });
    }

    @SubscribeEvent
    public static void registerProfessionPointsOfInterest(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.POI_TYPES, registerHelper -> {
            for (Map.Entry<String, ProfessionPoiType> entry : POI_TYPES.entrySet()) {
                Block block = entry.getValue().block.get();
                String name = entry.getKey();
                Optional existingCheck = PoiTypes.m_218075_((BlockState)block.m_49966_());
                if (existingCheck.isPresent()) {
                    GoldGolemMod.LOGGER.error("Skipping villager profession " + name + " that uses POI block " + String.valueOf(block) + " that is already in use by " + String.valueOf(existingCheck));
                    continue;
                }
                PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()), 1, 1);
                registerHelper.register(name, (Object)poiType);
                entry.getValue().poiType = (Holder)ForgeRegistries.POI_TYPES.getHolder((Object)poiType).get();
            }
        });
    }

    private static class ProfessionPoiType {
        final Supplier<Block> block;
        Holder<PoiType> poiType;

        ProfessionPoiType(Supplier<Block> block, Holder<PoiType> poiType) {
            this.block = block;
            this.poiType = poiType;
        }
    }
}

