/*
 * Decompiled with CFR 0.152.
 */
package net.juniorwmg.paytheprice;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.juniorwmg.paytheprice.config.ConfigManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zone.rong.mixinbooter.ILateMixinLoader;

@Mod(modid="paytheprice", name="Don't play nice, pay the price", version="1.1.0", dependencies="required-after:mixinbooter@[10.0,);after:gadgetsngoodies@[1.2.2,);after:signpic@[2.8.1,);after:grimpack@[6.0.0.6,);after:mca@[6.0.0,);after:secretroomsmod@[5.6.0,)")
public class Main
implements ILateMixinLoader {
    public static final Logger LOGGER = LogManager.getLogger((String)"DPNPTP");
    private static boolean configLoaded = false;

    public List<String> getMixinConfigs() {
        ConditionalMixin[] conditionalMixins;
        if (!configLoaded) {
            ConfigManager.PayThePriceConfig();
            configLoaded = true;
        }
        ArrayList<String> mixinConfigs = new ArrayList<String>();
        ArrayList<String> skippedConfigs = new ArrayList<String>();
        mixinConfigs.add("mixins.paytheprice.json");
        for (ConditionalMixin mixin : conditionalMixins = new ConditionalMixin[]{new ConditionalMixin("gadgetsngoodies", ConfigManager.enableGadgetsNGoodiesMixin), new ConditionalMixin("grimpack", ConfigManager.enableGrimPackMixin), new ConditionalMixin("signpic", ConfigManager.enableSignPicMixin), new ConditionalMixin("mca", ConfigManager.enableComesAliveMixin), new ConditionalMixin("secretroomsmod", ConfigManager.enableSecretRoomsMixin)}) {
            String configName = "mixins.paytheprice." + mixin.modId + ".json";
            if (Loader.isModLoaded((String)mixin.modId) && mixin.enabled) {
                mixinConfigs.add(configName);
                continue;
            }
            String reason = !Loader.isModLoaded((String)mixin.modId) ? "mod not loaded" : "disabled in config";
            skippedConfigs.add(configName + " (" + reason + ")");
        }
        this.logMixinConfigs(mixinConfigs, skippedConfigs);
        return ImmutableList.copyOf(mixinConfigs);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER.info("Reached pre-init.");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LOGGER.info("Reached init.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LOGGER.info("Reached post-init.");
    }

    private void logMixinConfigs(List<String> loaded, List<String> skipped) {
        LOGGER.info("Loading mixin configurations:");
        loaded.forEach(config -> LOGGER.info("  - {}", config));
        if (!skipped.isEmpty()) {
            LOGGER.info("Skipped mixin configurations:");
            skipped.forEach(config -> LOGGER.info("  - {}", config));
        }
    }

    private static class ConditionalMixin {
        final String modId;
        final boolean enabled;

        ConditionalMixin(String modId, boolean enabled) {
            this.modId = modId;
            this.enabled = enabled;
        }
    }
}

