/*
 * Decompiled with CFR 0.152.
 */
package dev.larrox.locatorBarRemover.util;

import dev.larrox.locatorBarRemover.LocatorBarRemover;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;

public class Gamerules {
    private final LocatorBarRemover plugin;

    public Gamerules(LocatorBarRemover plugin) {
        this.plugin = plugin;
    }

    public void apply() {
        String gamerule = "locatorBar";
        boolean value = this.plugin.getConfig().getBoolean("value", false);
        List ignoredWorlds = this.plugin.getConfig().getStringList("ignored-worlds");
        for (World world : Bukkit.getWorlds()) {
            if (ignoredWorlds.contains(world.getName())) continue;
            if (world.isGameRule(gamerule)) {
                if (!((Boolean)world.getGameRuleValue(GameRule.LOCATOR_BAR)).booleanValue()) {
                    Bukkit.getLogger().info("Gamerule " + gamerule + " already set in world: " + world.getName() + ", skipping.");
                    continue;
                }
                world.setGameRuleValue(gamerule, Boolean.toString(value));
                Bukkit.getLogger().info("Set gamerule " + gamerule + "=" + value + " in world: " + world.getName());
                continue;
            }
            Bukkit.getLogger().warning("World '" + world.getName() + "' does not support gamerule: " + gamerule);
            Bukkit.getServer().getVersion();
        }
    }
}

