/*
 * Decompiled with CFR 0.152.
 */
package dev.larrox;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatUtil {
    public static String color(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static void send(CommandSender sender, String message) {
        sender.sendMessage(ChatUtil.color(message));
    }

    public static void send(Player player, String message) {
        player.sendMessage(ChatUtil.color(message));
    }

    public static void sendTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        player.sendTitle(ChatUtil.color(title), ChatUtil.color(subtitle), fadeIn, stay, fadeOut);
    }

    public static void sendTitle(Player player, String title, int fadeIn, int stay, int fadeOut) {
        player.sendTitle(ChatUtil.color(title), null, fadeIn, stay, fadeOut);
    }

    public static void sendSubtitle(Player player, String subtitle, int fadeIn, int stay, int fadeOut) {
        player.sendTitle(null, ChatUtil.color(subtitle), fadeIn, stay, fadeOut);
    }

    public static void sendActionBar(Player player, String message) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ChatUtil.color(message)));
    }

    public String hexColor(String message) {
        Pattern pattern = Pattern.compile("(?i)&\\#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(message);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            StringBuilder replacement = new StringBuilder("\u00a7x");
            for (char c : hex.toCharArray()) {
                replacement.append("\u00a7").append(c);
            }
            matcher.appendReplacement(sb, replacement.toString());
        }
        matcher.appendTail(sb);
        return sb.toString().replace("&", "\u00a7");
    }
}

