/*
 * Decompiled with CFR 0.152.
 */
package dev.larrox;

import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    private final ItemStack item;
    private final ItemMeta meta;

    public ItemBuilder(Material material) {
        this.item = new ItemStack(material);
        this.meta = this.item.getItemMeta();
    }

    public ItemBuilder setName(String name) {
        this.meta.setDisplayName(name.replace("&", "\u00a7"));
        return this;
    }

    public ItemBuilder setLore(String ... lore) {
        ArrayList<String> loreList = new ArrayList<String>();
        for (String line : lore) {
            loreList.add(line.replace("&", "\u00a7"));
        }
        this.meta.setLore(loreList);
        return this;
    }

    public ItemBuilder addEnchant(Enchantment ench, int level) {
        this.meta.addEnchant(ench, level, true);
        return this;
    }

    public ItemBuilder addFlags(ItemFlag ... flags) {
        this.meta.addItemFlags(flags);
        return this;
    }

    public ItemBuilder setOwner(OfflinePlayer owner) {
        if (this.meta instanceof SkullMeta) {
            ((SkullMeta)this.meta).setOwningPlayer(owner);
        }
        return this;
    }

    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        return this.item;
    }
}

