/*
 * Decompiled with CFR 0.152.
 */
package dev.larrox.locatorBarRemover.cmd;

import dev.larrox.locatorBarRemover.LocatorBarRemover;
import dev.larrox.locatorBarRemover.util.Gamerules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class LocatorBarRemoverCMD
implements CommandExecutor,
TabCompleter {
    private final LocatorBarRemover plugin;
    private final Gamerules gamerules;
    private final String reloadPermission = "locatorbarremover.reload";

    public LocatorBarRemoverCMD(LocatorBarRemover plugin, Gamerules gamerules) {
        this.plugin = plugin;
        this.gamerules = gamerules;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("locatorbarremover.reload")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a78[\u00a7aLocatorBarRemover\u00a78] \u00a77usage: /locatorbarremover <reload/run/all>");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.plugin.reloadConfig();
                sender.sendMessage("\u00a7aLocatorBarRemover config reloaded.");
                break;
            }
            case "run": {
                this.gamerules.apply();
                sender.sendMessage("\u00a7aLocatorBarRemover gamerules applied.");
                break;
            }
            case "all": {
                this.plugin.reloadConfig();
                this.gamerules.apply();
                sender.sendMessage("\u00a7aLocatorBarRemover config reloaded and gamerules applied.");
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUnknown subcommand. Use: /" + label + " reload");
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("locatorbarremover.reload")) {
            return List.of();
        }
        if (args.length == 1) {
            List<String> options = Arrays.asList("reload", "run", "all");
            String input = args[0].toLowerCase();
            ArrayList<String> matches = new ArrayList<String>();
            for (String option : options) {
                if (!option.startsWith(input)) continue;
                matches.add(option);
            }
            return matches;
        }
        return List.of();
    }
}

