/*
 * Decompiled with CFR 0.152.
 */
package dev.larrox.locatorBarRemover.util;

import dev.larrox.Logger;
import dev.larrox.locatorBarRemover.LocatorBarRemover;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;

public class Gamerules {
    private final LocatorBarRemover plugin;

    public Gamerules(LocatorBarRemover plugin) {
        this.plugin = plugin;
    }

    public void apply() {
        GameRule gamerule = GameRule.LOCATOR_BAR;
        boolean value = this.plugin.getConfig().getBoolean("value", false);
        List ignoredWorlds = this.plugin.getConfig().getStringList("ignored-worlds");
        for (World world : Bukkit.getWorlds()) {
            if (ignoredWorlds.contains(world.getName())) continue;
            Boolean currentValue = (Boolean)world.getGameRuleValue(gamerule);
            String consolePrefix = this.plugin.getConfig().getString("console-prefix");
            String consoleSuffix = this.plugin.getConfig().getString("console-suffix");
            if (currentValue != null && currentValue == value) {
                Logger.info(consolePrefix + gamerule.getName() + " already set to " + value + " in world: " + world.getName() + ", skipping." + consoleSuffix);
                continue;
            }
            world.setGameRule(gamerule, (Object)value);
            Logger.info(consolePrefix + "Set gamerule " + gamerule.getName() + "=" + value + " in world: " + world.getName() + consoleSuffix);
        }
    }
}

