/*
 * Decompiled with CFR 0.152.
 */
package dev.larrox.locatorBarRemover;

import dev.larrox.locatorBarRemover.cmd.ReloadCMD;
import dev.larrox.locatorBarRemover.util.Gamerules;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LocatorBarRemover
extends JavaPlugin {
    public void onEnable() {
        this.checkServerVersion();
        this.saveDefaultConfig();
        Gamerules gamerules = new Gamerules(this);
        this.getCommand("locatorbarremover").setExecutor((CommandExecutor)new ReloadCMD(this, gamerules));
    }

    private void checkServerVersion() {
        new BukkitRunnable(){

            public void run() {
                String bukkitVersion = Bukkit.getBukkitVersion();
                String versionOnly = bukkitVersion.split("-")[0];
                if (!LocatorBarRemover.this.isVersionAtLeast(versionOnly, "1.21.6")) {
                    LocatorBarRemover.this.getLogger().warning("This plugin requires Minecraft version 1.21.6 or higher!");
                    LocatorBarRemover.this.getLogger().warning("Detected version: " + versionOnly);
                    LocatorBarRemover.this.getLogger().warning("Disabling plugin...");
                    Bukkit.getPluginManager().disablePlugin((Plugin)LocatorBarRemover.this);
                } else {
                    LocatorBarRemover.this.getLogger().info("Running on compatible version: " + versionOnly);
                    Gamerules gamerules = new Gamerules(LocatorBarRemover.this);
                    gamerules.apply();
                }
            }
        }.runTaskLater((Plugin)this, 200L);
    }

    private boolean isVersionAtLeast(String current, String required) {
        String[] cur = current.split("\\.");
        String[] req = required.split("\\.");
        for (int i = 0; i < Math.max(cur.length, req.length); ++i) {
            int reqPart;
            int curPart = i < cur.length ? Integer.parseInt(cur[i]) : 0;
            int n = reqPart = i < req.length ? Integer.parseInt(req[i]) : 0;
            if (curPart < reqPart) {
                return false;
            }
            if (curPart <= reqPart) continue;
            return true;
        }
        return true;
    }
}

