/*
 * Decompiled with CFR 0.152.
 */
package dev.larrox.locatorBarRemover.cmd;

import dev.larrox.locatorBarRemover.LocatorBarRemover;
import dev.larrox.locatorBarRemover.util.Gamerules;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class ReloadCMD
implements CommandExecutor,
TabCompleter {
    private final LocatorBarRemover plugin;
    private final Gamerules gamerules;

    public ReloadCMD(LocatorBarRemover plugin, Gamerules gamerules) {
        this.plugin = plugin;
        this.gamerules = gamerules;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("locatorbarremover.reload")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length == 0) {
            this.gamerules.apply();
            sender.sendMessage("\u00a7aGamerule applied to all applicable worlds.");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.plugin.reloadConfig();
                sender.sendMessage("\u00a7aLocatorBarRemover config reloaded.");
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUnknown subcommand. Use: /" + label + " reload");
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if ("reload".startsWith(args[0].toLowerCase())) {
                completions.add("reload");
            }
            return completions;
        }
        return Collections.emptyList();
    }
}

