/*
 * Decompiled with CFR 0.152.
 */
package me.f4dev.trader.gui;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.f4dev.trader.services.ConfigService;
import me.f4dev.trader.services.Locale;
import me.f4dev.trader.services.LocaleService;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0016\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"createTradeMenu", "Lorg/bukkit/inventory/Inventory;", "createLine", "", "menu", "iter", "", "initialPosition", "createFunctionsLine", "trader"})
public final class TradeGUIKt {
    @NotNull
    public static final Inventory createTradeMenu() {
        Inventory inventory = Bukkit.createInventory(null, (int)45, (String)LocaleService.INSTANCE.get(Locale.Trading.INSTANCE));
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        Inventory menu = inventory;
        for (int i = 0; i < 5; ++i) {
            TradeGUIKt.createLine(menu, i, i * 9);
        }
        TradeGUIKt.createFunctionsLine(menu, 36);
        return menu;
    }

    public static final void createLine(@NotNull Inventory menu, int iter, int initialPosition) {
        ItemMeta cancelButtonMeta;
        ItemMeta paneMeta;
        Intrinsics.checkNotNullParameter(menu, "menu");
        ItemStack pane = new ItemStack(Material.BLACK_STAINED_GLASS_PANE, 1);
        ItemMeta itemMeta = paneMeta = pane.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(" ");
        }
        pane.setItemMeta(paneMeta);
        ItemStack cancelButton = new ItemStack(Material.BARRIER, 1);
        ItemMeta itemMeta2 = cancelButtonMeta = cancelButton.getItemMeta();
        if (itemMeta2 != null) {
            itemMeta2.setDisplayName(LocaleService.INSTANCE.get(Locale.Cancel.INSTANCE));
        }
        cancelButton.setItemMeta(cancelButtonMeta);
        if (iter == 2) {
            menu.setItem(initialPosition + 4, cancelButton);
        } else {
            menu.setItem(initialPosition + 4, pane);
        }
    }

    public static final void createFunctionsLine(@NotNull Inventory menu, int initialPosition) {
        ItemMeta paneMeta;
        ItemMeta confirmPaneMeta;
        Intrinsics.checkNotNullParameter(menu, "menu");
        ItemStack confirmPane = new ItemStack(Material.RED_STAINED_GLASS_PANE, 1);
        ItemMeta itemMeta = confirmPaneMeta = confirmPane.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(LocaleService.INSTANCE.get(Locale.Confirm.INSTANCE));
        }
        confirmPane.setItemMeta(confirmPaneMeta);
        ItemStack coin = new ItemStack(Material.GOLD_NUGGET, 1);
        ItemMeta coinMeta = coin.getItemMeta();
        int multiplier = ConfigService.INSTANCE.getConfig().getInt("balance-multiplier");
        ItemMeta itemMeta2 = coinMeta;
        if (itemMeta2 != null) {
            itemMeta2.setDisplayName(LocaleService.INSTANCE.get(Locale.Money.INSTANCE) + " " + ConfigService.INSTANCE.getConfig().getString("balance-prefix") + " 0");
        }
        ItemMeta itemMeta3 = coinMeta;
        if (itemMeta3 != null) {
            String[] stringArray = new String[]{"", LocaleService.INSTANCE.get(Locale.MouseLeft.INSTANCE) + " -" + multiplier, LocaleService.INSTANCE.get(Locale.MouseRight.INSTANCE) + " +" + multiplier};
            itemMeta3.setLore(CollectionsKt.listOf(stringArray));
        }
        coin.setItemMeta(coinMeta);
        ItemStack pane = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE, 1);
        ItemMeta itemMeta4 = paneMeta = pane.getItemMeta();
        if (itemMeta4 != null) {
            itemMeta4.setDisplayName(" ");
        }
        pane.setItemMeta(paneMeta);
        ItemStack blackPane = new ItemStack(Material.BLACK_STAINED_GLASS_PANE, 1);
        blackPane.setItemMeta(paneMeta);
        if (ConfigService.INSTANCE.getConfig().getBoolean("balance-support")) {
            menu.setItem(initialPosition + 2, coin);
            menu.setItem(initialPosition + 6, coin);
        } else {
            menu.setItem(initialPosition + 2, pane);
            menu.setItem(initialPosition + 6, pane);
        }
        menu.setItem(initialPosition, confirmPane);
        menu.setItem(initialPosition + 1, pane);
        menu.setItem(initialPosition + 3, pane);
        menu.setItem(initialPosition + 4, blackPane);
        menu.setItem(initialPosition + 5, pane);
        menu.setItem(initialPosition + 7, pane);
        menu.setItem(initialPosition + 8, confirmPane);
    }
}

