/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak;

import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TriState;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.tintankgames.peak.Config;
import net.tintankgames.peak.attachments.InteractTarget;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.core.component.PeakDataComponents;
import net.tintankgames.peak.core.particles.PeakParticleTypes;
import net.tintankgames.peak.core.registries.PeakDataMaps;
import net.tintankgames.peak.network.AssistMessage;
import net.tintankgames.peak.network.syncher.PeakEntityDataSerializers;
import net.tintankgames.peak.stamina.AfflictionType;
import net.tintankgames.peak.stamina.AfflictionTypes;
import net.tintankgames.peak.stamina.StaminaBar;
import net.tintankgames.peak.world.entity.FallenScout;
import net.tintankgames.peak.world.entity.PeakEntityTypes;
import net.tintankgames.peak.world.entity.UnconsciousScout;
import net.tintankgames.peak.world.item.PeakCreativeModeTabs;
import net.tintankgames.peak.world.item.PeakItems;
import net.tintankgames.peak.world.item.component.PeakConsumable;
import net.tintankgames.peak.world.item.component.Poisonous;
import net.tintankgames.peak.world.level.block.PeakBlocks;
import net.tintankgames.peak.world.level.block.entity.PeakBlockEntityTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="peak")
public class Peak {
    public static final String MOD_ID = "peak";
    public static final String MOD_VERSION = "1.0.2";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation ENERGY_MODIFIER_ID = Peak.id("energy");
    public static final AttributeModifier SPEED_MODIFIER_ENERGY = new AttributeModifier(ENERGY_MODIFIER_ID, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);

    public Peak(IEventBus bus, ModContainer modContainer) {
        LOGGER.info("Initializing PEAK Craft v{}", (Object)MOD_VERSION);
        PeakAttachmentTypes.register(bus);
        PeakParticleTypes.register(bus);
        PeakDataComponents.register(bus);
        PeakEntityDataSerializers.register(bus);
        PeakEntityTypes.register(bus);
        PeakBlocks.register(bus);
        PeakItems.register(bus);
        PeakBlockEntityTypes.register(bus);
        PeakCreativeModeTabs.register(bus);
        NeoForge.EVENT_BUS.addListener(this::tick);
        NeoForge.EVENT_BUS.addListener(this::effectToAffliction);
        NeoForge.EVENT_BUS.addListener(this::pickup);
        NeoForge.EVENT_BUS.addListener(this::damage);
        NeoForge.EVENT_BUS.addListener(this::interact);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void tick(PlayerTickEvent.Post event) {
        StaminaBar bar = (StaminaBar)event.getEntity().getData(PeakAttachmentTypes.STAMINA_BAR);
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((Boolean)player2.getData(PeakAttachmentTypes.ASSISTED)).booleanValue()) {
                player2.resetFallDistance();
            }
            if (player2.onGround() || ((Boolean)player2.getData(PeakAttachmentTypes.GRABBING_PITON)).booleanValue()) {
                player2.setData(PeakAttachmentTypes.ASSISTED, (Object)false);
            }
            player2.setNoGravity((Boolean)player2.getData(PeakAttachmentTypes.CLIMBING) != false && (player2.level().getBlockState(player2.blockPosition().relative(Peak.getNearestViewDirection((Player)player2))).isFaceSturdy((BlockGetter)player2.level(), player2.blockPosition().relative(Peak.getNearestViewDirection((Player)player2)), Peak.getNearestViewDirection((Player)player2).getOpposite()) || player2.level().getBlockState(player2.blockPosition().above().relative(Peak.getNearestViewDirection((Player)player2))).isFaceSturdy((BlockGetter)player2.level(), player2.blockPosition().above().relative(Peak.getNearestViewDirection((Player)player2)), Peak.getNearestViewDirection((Player)player2).getOpposite())) && bar.hasStamina((Entity)player2, true));
            if (((Boolean)player2.getData(PeakAttachmentTypes.CLIMBING)).booleanValue() && (player2.level().getBlockState(player2.blockPosition().relative(Peak.getNearestViewDirection((Player)player2))).isFaceSturdy((BlockGetter)player2.level(), player2.blockPosition().relative(Peak.getNearestViewDirection((Player)player2)), Peak.getNearestViewDirection((Player)player2).getOpposite()) || player2.level().getBlockState(player2.blockPosition().above().relative(Peak.getNearestViewDirection((Player)player2))).isFaceSturdy((BlockGetter)player2.level(), player2.blockPosition().above().relative(Peak.getNearestViewDirection((Player)player2)), Peak.getNearestViewDirection((Player)player2).getOpposite())) && (bar.hasStamina((Entity)player2, true) || ((Vec3)player2.getData(PeakAttachmentTypes.MOVEMENT_LUNGE)).length() > 0.05 || ((Vec3)player2.getData(PeakAttachmentTypes.MOVEMENT_ASSIST)).length() > 0.05)) {
                float staminaSpeedModifier = Mth.clamp((float)(bar.getStamina(true) * 5.0f), (float)0.002f, (float)1.0f);
                Vec2 movement = (Vec2)player2.getData(PeakAttachmentTypes.INPUT);
                if (movement.length() > 0.05f && (Integer)player2.getData(PeakAttachmentTypes.MOVE_OFF_PITON_COOLDOWN) <= 0) {
                    bar.useStamina((Entity)player2, 0.01f * staminaSpeedModifier, true);
                    player2.setData(PeakAttachmentTypes.GRABBING_PITON, (Object)false);
                    player2.setData(PeakAttachmentTypes.GRABBED_PITON, (Object)BlockPos.ZERO);
                    player2.setData(PeakAttachmentTypes.ASSISTED, (Object)false);
                }
                if (player2.level().getBlockState(player2.blockPosition().relative(Peak.getNearestViewDirection((Player)player2))).is(Blocks.MAGMA_BLOCK) || player2.level().getBlockState(player2.blockPosition().above().relative(Peak.getNearestViewDirection((Player)player2))).is(Blocks.MAGMA_BLOCK)) {
                    bar.addStatus((LivingEntity)player2, AfflictionTypes.HOT, 0.002f);
                }
                if (player2.level().getBlockState(player2.blockPosition().relative(Peak.getNearestViewDirection((Player)player2))).is(BlockTags.ICE) || player2.level().getBlockState(player2.blockPosition().above().relative(Peak.getNearestViewDirection((Player)player2))).is(BlockTags.ICE)) {
                    bar.addStatus((LivingEntity)player2, AfflictionTypes.COLD, 0.002f);
                }
                if ((Integer)player2.getData(PeakAttachmentTypes.INFINITE_TIMER) > 160) {
                    player2.setData(PeakAttachmentTypes.INFINITE_TIMER, (Object)160);
                }
                if ((Integer)player2.getData(PeakAttachmentTypes.ENERGY_TIMER) > 160) {
                    player2.setData(PeakAttachmentTypes.ENERGY_TIMER, (Object)160);
                }
                player2.resetFallDistance();
            } else {
                player2.setData(PeakAttachmentTypes.MOVEMENT_LUNGE, (Object)Vec3.ZERO);
                player2.setData(PeakAttachmentTypes.MOVEMENT_ASSIST, (Object)Vec3.ZERO);
                player2.setData(PeakAttachmentTypes.ASSISTED, (Object)false);
                player2.setData(PeakAttachmentTypes.PLACE_PITON_COOLDOWN, (Object)0);
                if (player2.isSprinting() || ((Boolean)player2.getData(PeakAttachmentTypes.SPRINTING)).booleanValue()) {
                    bar.useStamina((Entity)player2, 0.0025f, false);
                } else if (bar.getStaminaRegenCooldown() <= 0 && (player2.onGround() || ((Boolean)player2.getData(PeakAttachmentTypes.GRABBING_PITON)).booleanValue())) {
                    bar.addStamina(0.01f);
                }
            }
            if (((Boolean)player2.getData(PeakAttachmentTypes.GRABBING_PITON)).booleanValue()) {
                Vec3 pos = ((BlockPos)player2.getData(PeakAttachmentTypes.GRABBED_PITON)).below().getBottomCenter();
                player2.teleportTo(pos.x(), pos.y(), pos.z());
                player2.setDeltaMovement(0.0, 0.0, 0.0);
                player2.resetFallDistance();
            }
            if (((Boolean)player2.getData(PeakAttachmentTypes.INTERACTING)).booleanValue() && player2.getMainHandItem() == player2.getData(PeakAttachmentTypes.INTERACT_ITEM)) {
                if ((Integer)player2.getData(PeakAttachmentTypes.INTERACT_TIMER) > 0) {
                    player2.setData(PeakAttachmentTypes.INTERACT_TIMER, (Object)((Integer)player2.getData(PeakAttachmentTypes.INTERACT_TIMER) - 1));
                }
            } else {
                player2.setData(PeakAttachmentTypes.INTERACT_TIMER, (Object)-1);
                player2.setData(PeakAttachmentTypes.INTERACT_TYPE, (Object)-1);
                player2.setData(PeakAttachmentTypes.INTERACT_ITEM, (Object)ItemStack.EMPTY);
                player2.setData(PeakAttachmentTypes.INTERACT_TARGET, (Object)new InteractTarget(Optional.empty()));
            }
            if ((Integer)player2.getData(PeakAttachmentTypes.INFINITE_TIMER) > 0) {
                bar.setStamina(1.0f - bar.getTotalAffliction());
                player2.setData(PeakAttachmentTypes.INFINITE_TIMER, (Object)((Integer)player2.getData(PeakAttachmentTypes.INFINITE_TIMER) - 1));
            } else if ((Integer)player2.getData(PeakAttachmentTypes.INFINITE_TIMER) == 0) {
                player2.setData(PeakAttachmentTypes.SLEEPY_TIMER, (Object)200);
                player2.setData(PeakAttachmentTypes.INFINITE_TIMER, (Object)-1);
            }
            if ((Integer)player2.getData(PeakAttachmentTypes.ENERGY_TIMER) > 0) {
                player2.setData(PeakAttachmentTypes.ENERGY_TIMER, (Object)((Integer)player2.getData(PeakAttachmentTypes.ENERGY_TIMER) - 1));
            } else if ((Integer)player2.getData(PeakAttachmentTypes.ENERGY_TIMER) == 0) {
                bar.addStatus((LivingEntity)player2, AfflictionTypes.DROWSY, 0.25f + ((Float)player2.getData(PeakAttachmentTypes.STORED_DROWSY)).floatValue());
                player2.setData(PeakAttachmentTypes.STORED_DROWSY, (Object)Float.valueOf(0.0f));
                player2.setData(PeakAttachmentTypes.ENERGY_TIMER, (Object)-1);
            } else {
                player2.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(SPEED_MODIFIER_ENERGY.id());
            }
            if ((Integer)player2.getData(PeakAttachmentTypes.EXPLOSION_TIMER) > 0) {
                player2.setData(PeakAttachmentTypes.EXPLOSION_TIMER, (Object)((Integer)player2.getData(PeakAttachmentTypes.EXPLOSION_TIMER) - 1));
            }
            if ((Integer)player2.getData(PeakAttachmentTypes.SLEEPY_TIMER) > 0) {
                bar.addStatus((LivingEntity)player2, AfflictionTypes.DROWSY, 0.001625f);
                player2.setData(PeakAttachmentTypes.SLEEPY_TIMER, (Object)((Integer)player2.getData(PeakAttachmentTypes.SLEEPY_TIMER) - 1));
            }
            if ((Integer)player2.getData(PeakAttachmentTypes.POISON_COOLDOWN) > 0) {
                player2.setData(PeakAttachmentTypes.POISON_COOLDOWN, (Object)((Integer)player2.getData(PeakAttachmentTypes.POISON_COOLDOWN) - 1));
            }
            if ((Integer)player2.getData(PeakAttachmentTypes.POISON_TIMER) > 0 && (Integer)player2.getData(PeakAttachmentTypes.POISON_COOLDOWN) <= 0) {
                bar.addStatus((LivingEntity)player2, AfflictionTypes.POISON, 0.00125f);
                player2.setData(PeakAttachmentTypes.POISON_TIMER, (Object)((Integer)player2.getData(PeakAttachmentTypes.POISON_TIMER) - 1));
            }
            if ((Integer)player2.getData(PeakAttachmentTypes.MOVE_OFF_PITON_COOLDOWN) > 0) {
                player2.setData(PeakAttachmentTypes.MOVE_OFF_PITON_COOLDOWN, (Object)((Integer)player2.getData(PeakAttachmentTypes.MOVE_OFF_PITON_COOLDOWN) - 1));
            }
            if ((Integer)player2.getData(PeakAttachmentTypes.PLACE_PITON_COOLDOWN) > 0) {
                player2.setData(PeakAttachmentTypes.PLACE_PITON_COOLDOWN, (Object)((Integer)player2.getData(PeakAttachmentTypes.PLACE_PITON_COOLDOWN) - 1));
            }
            if (((Boolean)player2.getData(PeakAttachmentTypes.SNEAKING)).booleanValue() && ((Boolean)player2.getData(PeakAttachmentTypes.GRABBING_PITON)).booleanValue()) {
                player2.setData(PeakAttachmentTypes.GRABBING_PITON, (Object)false);
                player2.setData(PeakAttachmentTypes.GRABBED_PITON, (Object)BlockPos.ZERO);
            }
            if (!player2.isCreative() && player2.level().getBlockState(BlockPos.containing((Position)player2.position().subtract(0.0, 1.0E-6, 0.0))).is(Blocks.BLUE_ICE) && player2.onGround()) {
                bar.addStatus((LivingEntity)player2, AfflictionTypes.COLD, 0.0025f);
            }
        }
        if (!((Boolean)event.getEntity().getData(PeakAttachmentTypes.CLIMBING)).booleanValue()) {
            event.getEntity().setData(PeakAttachmentTypes.MOVEMENT_LUNGE, (Object)Vec3.ZERO);
            event.getEntity().setData(PeakAttachmentTypes.MOVEMENT_ASSIST, (Object)Vec3.ZERO);
            event.getEntity().setData(PeakAttachmentTypes.PLACE_PITON_COOLDOWN, (Object)0);
        }
        if (((Boolean)event.getEntity().getData(PeakAttachmentTypes.CLIMBING)).booleanValue() && (event.getEntity().level().getBlockState(event.getEntity().blockPosition().relative(Peak.getNearestViewDirection(event.getEntity()))).isFaceSturdy((BlockGetter)event.getEntity().level(), event.getEntity().blockPosition().relative(Peak.getNearestViewDirection(event.getEntity())), Peak.getNearestViewDirection(event.getEntity()).getOpposite()) || event.getEntity().level().getBlockState(event.getEntity().blockPosition().above().relative(Peak.getNearestViewDirection(event.getEntity()))).isFaceSturdy((BlockGetter)event.getEntity().level(), event.getEntity().blockPosition().above().relative(Peak.getNearestViewDirection(event.getEntity())), Peak.getNearestViewDirection(event.getEntity()).getOpposite())) && (bar.hasStamina((Entity)event.getEntity(), true) || ((Vec3)event.getEntity().getData(PeakAttachmentTypes.MOVEMENT_LUNGE)).length() > 0.05 || ((Vec3)event.getEntity().getData(PeakAttachmentTypes.MOVEMENT_ASSIST)).length() > 0.05)) {
            event.getEntity().setYBodyRot(Peak.getNearestViewDirection(event.getEntity()).toYRot());
        }
        ((AnimationState)event.getEntity().getData(PeakAttachmentTypes.CLIMBING_STATE)).animateWhen(((Vec2)event.getEntity().getData(PeakAttachmentTypes.INPUT)).length() > 0.05f && (Boolean)event.getEntity().getData(PeakAttachmentTypes.GRABBING_PITON) == false && (Boolean)event.getEntity().getData(PeakAttachmentTypes.CLIMBING) != false && (event.getEntity().level().getBlockState(event.getEntity().blockPosition().relative(Peak.getNearestViewDirection(event.getEntity()))).isFaceSturdy((BlockGetter)event.getEntity().level(), event.getEntity().blockPosition().relative(Peak.getNearestViewDirection(event.getEntity())), Peak.getNearestViewDirection(event.getEntity()).getOpposite()) || event.getEntity().level().getBlockState(event.getEntity().blockPosition().above().relative(Peak.getNearestViewDirection(event.getEntity()))).isFaceSturdy((BlockGetter)event.getEntity().level(), event.getEntity().blockPosition().above().relative(Peak.getNearestViewDirection(event.getEntity())), Peak.getNearestViewDirection(event.getEntity()).getOpposite())) && (((StaminaBar)event.getEntity().getData(PeakAttachmentTypes.STAMINA_BAR)).hasStamina((Entity)event.getEntity(), true) || ((Vec3)event.getEntity().getData(PeakAttachmentTypes.MOVEMENT_LUNGE)).length() > 0.05 || ((Vec3)event.getEntity().getData(PeakAttachmentTypes.MOVEMENT_ASSIST)).length() > 0.05), event.getEntity().tickCount);
        ((AnimationState)event.getEntity().getData(PeakAttachmentTypes.CLIMBING_IDLE_STATE)).animateWhen(((Vec2)event.getEntity().getData(PeakAttachmentTypes.INPUT)).length() <= 0.05f && (Boolean)event.getEntity().getData(PeakAttachmentTypes.GRABBING_PITON) == false && (Boolean)event.getEntity().getData(PeakAttachmentTypes.CLIMBING) != false && (event.getEntity().level().getBlockState(event.getEntity().blockPosition().relative(Peak.getNearestViewDirection(event.getEntity()))).isFaceSturdy((BlockGetter)event.getEntity().level(), event.getEntity().blockPosition().relative(Peak.getNearestViewDirection(event.getEntity())), Peak.getNearestViewDirection(event.getEntity()).getOpposite()) || event.getEntity().level().getBlockState(event.getEntity().blockPosition().above().relative(Peak.getNearestViewDirection(event.getEntity()))).isFaceSturdy((BlockGetter)event.getEntity().level(), event.getEntity().blockPosition().above().relative(Peak.getNearestViewDirection(event.getEntity())), Peak.getNearestViewDirection(event.getEntity()).getOpposite())) && (((StaminaBar)event.getEntity().getData(PeakAttachmentTypes.STAMINA_BAR)).hasStamina((Entity)event.getEntity(), true) || ((Vec3)event.getEntity().getData(PeakAttachmentTypes.MOVEMENT_LUNGE)).length() > 0.05 || ((Vec3)event.getEntity().getData(PeakAttachmentTypes.MOVEMENT_ASSIST)).length() > 0.05), event.getEntity().tickCount);
        ((AnimationState)event.getEntity().getData(PeakAttachmentTypes.HOLDING_PITON_STATE)).animateWhen(((Boolean)event.getEntity().getData(PeakAttachmentTypes.GRABBING_PITON)).booleanValue(), event.getEntity().tickCount);
    }

    private void effectToAffliction(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            if (p instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)p;
                StaminaBar bar = (StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR);
                if (event.getEffectInstance().getEffect() == MobEffects.POISON) {
                    bar.addStatus((LivingEntity)player, AfflictionTypes.POISON, 0.1f * (float)(event.getEffectInstance().getAmplifier() + 1));
                } else if (event.getEffectInstance().getEffect() == MobEffects.WITHER) {
                    bar.addStatus((LivingEntity)player, AfflictionTypes.POISON, 0.00125f * (float)(event.getEffectInstance().getAmplifier() + 1));
                } else if (event.getEffectInstance().getEffect() == MobEffects.INSTANT_DAMAGE) {
                    bar.addStatus((LivingEntity)player, AfflictionTypes.INJURY, 0.15f * (float)(event.getEffectInstance().getAmplifier() + 1));
                } else if (event.getEffectInstance().getEffect() == MobEffects.INSTANT_HEALTH) {
                    bar.removeStatus(AfflictionTypes.INJURY, 0.1f * (float)(event.getEffectInstance().getAmplifier() + 1));
                } else if (event.getEffectInstance().getEffect() == MobEffects.HEALTH_BOOST) {
                    bar.removeStatus(AfflictionTypes.INJURY, 0.15f * (float)(event.getEffectInstance().getAmplifier() + 1));
                } else if (event.getEffectInstance().getEffect() == MobEffects.REGENERATION) {
                    bar.removeStatus(AfflictionTypes.INJURY, 0.4f * (float)(event.getEffectInstance().getAmplifier() + 1));
                } else if (event.getEffectInstance().getEffect() == MobEffects.SATURATION) {
                    bar.removeStatus(AfflictionTypes.HUNGER, 0.15f * (float)(event.getEffectInstance().getAmplifier() + 1));
                } else if (event.getEffectInstance().getEffect() == MobEffects.ABSORPTION) {
                    bar.addExtraStamina(0.1f * (float)(event.getEffectInstance().getAmplifier() + 1));
                } else if (event.getEffectInstance().getEffect() == MobEffects.STRENGTH) {
                    bar.addExtraStamina(0.3f * (float)(event.getEffectInstance().getAmplifier() + 1));
                } else if (event.getEffectInstance().getEffect() == MobEffects.HUNGER) {
                    bar.addStatus((LivingEntity)player, AfflictionTypes.HUNGER, 0.1f * (float)(event.getEffectInstance().getAmplifier() + 1));
                } else if (event.getEffectInstance().getEffect() == MobEffects.FIRE_RESISTANCE) {
                    bar.removeStatus(AfflictionTypes.HOT, 2.0f);
                } else if (event.getEffectInstance().getEffect() == MobEffects.SPEED) {
                    player.setData(PeakAttachmentTypes.STORED_DROWSY, (Object)Float.valueOf(bar.getStatus(AfflictionTypes.DROWSY)));
                    bar.removeStatus(AfflictionTypes.DROWSY, 2.0f);
                    player.setData(PeakAttachmentTypes.ENERGY_TIMER, (Object)220);
                    player.getAttribute(Attributes.MOVEMENT_SPEED).addOrUpdateTransientModifier(SPEED_MODIFIER_ENERGY);
                }
            }
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    private void pickup(ItemEntityPickupEvent.Pre event) {
        if (!((Boolean)event.getPlayer().getData(PeakAttachmentTypes.SNEAKING)).booleanValue()) {
            event.setCanPickup(TriState.FALSE);
        }
    }

    private void damage(LivingDamageEvent.Pre event) {
        LivingEntity entity;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof UnconsciousScout) {
            UnconsciousScout scout = (UnconsciousScout)livingEntity;
            v0 = scout.getOwner();
        } else {
            v0 = entity = event.getEntity();
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float damage = event.getOriginalDamage();
            if (event.getSource().is(DamageTypeTags.DAMAGES_HELMET) && !player.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                this.doHurtEquipment((LivingEntity)player, event.getSource(), event.getOriginalDamage(), EquipmentSlot.HEAD);
                damage *= 0.75f;
            }
            damage = this.getDamageAfterArmorAbsorb((LivingEntity)player, event.getSource(), damage);
            damage = this.getDamageAfterMagicAbsorb((LivingEntity)player, event.getSource(), damage);
            StaminaBar bar = (StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR);
            if (event.getSource().is(DamageTypes.DRAGON_BREATH) || event.getSource().is(DamageTypes.SPIT)) {
                bar.addStatus((LivingEntity)player, AfflictionTypes.POISON, damage * 0.05f);
            } else if (event.getSource().is(DamageTypes.STING)) {
                bar.addStatus((LivingEntity)player, AfflictionTypes.POISON, damage * 0.1f);
            } else if (event.getSource().is(DamageTypes.FREEZE)) {
                bar.addStatus((LivingEntity)player, AfflictionTypes.COLD, damage * 0.05f);
            } else if (event.getSource().is(DamageTypes.LIGHTNING_BOLT)) {
                bar.addStatus((LivingEntity)player, AfflictionTypes.INJURY, 1.0f);
                bar.addStatus((LivingEntity)player, AfflictionTypes.HOT, 1.0f);
            } else if (event.getSource().is(DamageTypes.LAVA)) {
                bar.addStatus((LivingEntity)player, AfflictionTypes.INJURY, damage * 0.03125f);
                bar.addStatus((LivingEntity)player, AfflictionTypes.HOT, damage * 0.0625f);
            } else if (event.getSource().is(DamageTypes.CAMPFIRE) || event.getSource().is(DamageTypes.IN_FIRE) || event.getSource().is(DamageTypes.ON_FIRE) || event.getSource().is(DamageTypes.FIREBALL) || event.getSource().is(DamageTypes.UNATTRIBUTED_FIREBALL)) {
                bar.addStatus((LivingEntity)player, AfflictionTypes.HOT, damage * 0.05f);
            } else if (event.getSource().is(DamageTypes.HOT_FLOOR)) {
                bar.addStatus((LivingEntity)player, AfflictionTypes.HOT, damage * 0.025f);
            } else if (event.getSource().is(DamageTypes.CACTUS) || event.getSource().is(DamageTypes.SWEET_BERRY_BUSH) || event.getSource().is(DamageTypes.THORNS)) {
                bar.addStatus((LivingEntity)player, AfflictionTypes.THORNS, damage * 0.05f);
            } else if (event.getSource().is(DamageTypes.OUTSIDE_BORDER) || event.getSource().is(DamageTypes.GENERIC_KILL)) {
                bar.addStatus((LivingEntity)player, AfflictionTypes.CURSE, damage * 0.05f);
            } else {
                bar.addStatus((LivingEntity)player, AfflictionTypes.INJURY, damage * 0.05f);
            }
            event.setNewDamage(0.01f);
        }
    }

    private void interact(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof ServerPlayer) {
            ServerPlayer other = (ServerPlayer)entity;
            entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (((Boolean)other.getData(PeakAttachmentTypes.CLIMBING)).booleanValue() && (other.level().getBlockState(other.blockPosition().relative(Peak.getNearestViewDirection((Player)other))).isFaceSturdy((BlockGetter)other.level(), other.blockPosition().relative(Peak.getNearestViewDirection((Player)other)), Peak.getNearestViewDirection((Player)other).getOpposite()) || other.level().getBlockState(other.blockPosition().above().relative(Peak.getNearestViewDirection((Player)other))).isFaceSturdy((BlockGetter)other.level(), other.blockPosition().above().relative(Peak.getNearestViewDirection((Player)other)), Peak.getNearestViewDirection((Player)other).getOpposite()))) {
                    other.setData(PeakAttachmentTypes.MOVEMENT_ASSIST, (Object)Vec3.directionFromRotation((float)(-player.getXRot()), (float)(-player.getYHeadRot())).multiply(0.7, 0.7, 0.7));
                    PacketDistributor.sendToPlayer((ServerPlayer)other, (CustomPacketPayload)new AssistMessage(-player.getXRot(), -player.getYHeadRot(), 0.5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    other.setData(PeakAttachmentTypes.ASSISTED, (Object)true);
                    event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS_SERVER);
                    event.setCanceled(true);
                } else {
                    if ((Integer)player.getData(PeakAttachmentTypes.INTERACT_TIMER) != -1 && ((InteractTarget)player.getData(PeakAttachmentTypes.INTERACT_TARGET)).uuid().isPresent() && !((InteractTarget)player.getData(PeakAttachmentTypes.INTERACT_TARGET)).uuid().get().toString().equals(other.getStringUUID())) {
                        player.setData(PeakAttachmentTypes.INTERACT_TIMER, (Object)-1);
                        player.setData(PeakAttachmentTypes.INTERACT_TYPE, (Object)-1);
                        player.setData(PeakAttachmentTypes.INTERACT_ITEM, (Object)ItemStack.EMPTY);
                        player.setData(PeakAttachmentTypes.INTERACT_TARGET, (Object)new InteractTarget(Optional.empty()));
                    }
                    if ((Integer)player.getData(PeakAttachmentTypes.INTERACT_TIMER) == -1) {
                        stack = event.getItemStack();
                        PeakConsumable peakConsumable = (PeakConsumable)stack.get(PeakDataComponents.CONSUMABLE);
                        if (peakConsumable == null) {
                            peakConsumable = (PeakConsumable)BuiltInRegistries.ITEM.getData(PeakDataMaps.CONSUMABLES, stack.getItemHolder().getKey());
                        }
                        if (peakConsumable != null) {
                            player.setData(PeakAttachmentTypes.INTERACT_TIMER, (Object)((Consumable)stack.getOrDefault(DataComponents.CONSUMABLE, (Object)Consumable.builder().build())).consumeTicks());
                            player.setData(PeakAttachmentTypes.INTERACT_TYPE, (Object)0);
                            player.setData(PeakAttachmentTypes.INTERACT_ITEM, (Object)stack);
                            player.setData(PeakAttachmentTypes.INTERACT_TARGET, (Object)new InteractTarget(Optional.of(other.getUUID())));
                            player.stopUsingItem();
                            event.setCancellationResult((InteractionResult)InteractionResult.CONSUME);
                            event.setCanceled(true);
                        } else if (stack.isEmpty() && ((StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR)).getStatus(AfflictionTypes.HUNGER) >= 0.7f) {
                            player.setData(PeakAttachmentTypes.INTERACT_TIMER, (Object)32);
                            player.setData(PeakAttachmentTypes.INTERACT_TYPE, (Object)1);
                            player.setData(PeakAttachmentTypes.INTERACT_ITEM, (Object)stack);
                            player.setData(PeakAttachmentTypes.INTERACT_TARGET, (Object)new InteractTarget(Optional.of(other.getUUID())));
                        }
                    } else if ((Integer)player.getData(PeakAttachmentTypes.INTERACT_TIMER) == 0) {
                        if ((Integer)player.getData(PeakAttachmentTypes.INTERACT_TYPE) == 0) {
                            stack = event.getItemStack();
                            Consumable consumable = (Consumable)stack.get(DataComponents.CONSUMABLE);
                            if (consumable != null) {
                                this.emitParticlesAndSounds(other.getRandom(), (LivingEntity)other, stack, 16, consumable);
                                other.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                                CriteriaTriggers.CONSUME_ITEM.trigger(other, stack);
                                PeakConsumable peakConsumable = (PeakConsumable)stack.get(PeakDataComponents.CONSUMABLE);
                                if (peakConsumable == null) {
                                    peakConsumable = (PeakConsumable)BuiltInRegistries.ITEM.getData(PeakDataMaps.CONSUMABLES, stack.getItemHolder().getKey());
                                }
                                if (peakConsumable != null) {
                                    Poisonous poisonous;
                                    StaminaBar bar = (StaminaBar)other.getData(PeakAttachmentTypes.STAMINA_BAR);
                                    peakConsumable.effects().forEach((key, value) -> bar.addStatus((LivingEntity)player, (ResourceKey<AfflictionType>)key, value.floatValue()));
                                    bar.addExtraStamina(peakConsumable.extraStamina());
                                    if (((Float)stack.getOrDefault(PeakDataComponents.INFINITE_STAMINA, (Object)Float.valueOf(0.0f))).floatValue() > 0.0f) {
                                        other.setData(PeakAttachmentTypes.INFINITE_TIMER, (Object)((int)(((Float)stack.getOrDefault(PeakDataComponents.INFINITE_STAMINA, (Object)Float.valueOf(0.0f))).floatValue() * 20.0f)));
                                    }
                                    if ((poisonous = (Poisonous)stack.get(PeakDataComponents.POISONOUS)) == null) {
                                        poisonous = (Poisonous)BuiltInRegistries.ITEM.getData(PeakDataMaps.POISONOUS, stack.getItemHolder().getKey());
                                    }
                                    if (poisonous != null) {
                                        if ((Integer)other.getData(PeakAttachmentTypes.POISON_TIMER) > 0 && (Integer)other.getData(PeakAttachmentTypes.POISON_COOLDOWN) <= 0) {
                                            other.setData(PeakAttachmentTypes.POISON_TIMER, (Object)((int)(poisonous.time() * 20.0f) + (int)(poisonous.cooldown() * 20.0f) + (Integer)other.getData(PeakAttachmentTypes.POISON_TIMER)));
                                        } else {
                                            other.setData(PeakAttachmentTypes.POISON_COOLDOWN, (Object)((int)(poisonous.cooldown() * 20.0f)));
                                            other.setData(PeakAttachmentTypes.POISON_TIMER, (Object)((int)(poisonous.time() * 20.0f)));
                                        }
                                    }
                                } else {
                                    stack.getAllOfType(ConsumableListener.class).forEach(listener -> listener.onConsume((Level)other.level(), (LivingEntity)other, stack, consumable));
                                    consumable.onConsumeEffects().forEach(effect -> effect.apply((Level)other.level(), stack, (LivingEntity)other));
                                }
                                other.gameEvent((Holder)(consumable.animation() == ItemUseAnimation.DRINK ? GameEvent.DRINK : GameEvent.EAT));
                                if (stack.getMaxDamage() <= 0) {
                                    stack.consume(1, (LivingEntity)player);
                                } else {
                                    stack.hurtAndBreak(1, (LivingEntity)player, event.getHand());
                                }
                                event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS_SERVER);
                                event.setCanceled(true);
                            }
                        } else if ((Integer)player.getData(PeakAttachmentTypes.INTERACT_TYPE) == 1) {
                            StaminaBar otherBar = (StaminaBar)other.getData(PeakAttachmentTypes.STAMINA_BAR);
                            otherBar.addStatus((LivingEntity)other, AfflictionTypes.INJURY, 1.0f - otherBar.getTotalAffliction());
                            other.setData(PeakAttachmentTypes.PASS_OUT_TIMER, (Object)0);
                            other.setData(PeakAttachmentTypes.DEATH_TIMER, (Object)0);
                            FallenScout body = (FallenScout)((EntityType)PeakEntityTypes.FALLEN_SCOUT.get()).create(player.level(), null, player.blockPosition(), EntitySpawnReason.CONVERSION, false, false);
                            if (body != null) {
                                body.teleportTo(other.level(), other.getX(), other.getY(), other.getZ(), Set.of(), other.getYRot(), other.getXRot(), true);
                                body.setOwner((LivingEntity)other);
                                body.setGameMode(other.gameMode());
                                body.setYRot(other.getYRot());
                                body.setYBodyRot(other.yBodyRot);
                                body.setYHeadRot(other.getYHeadRot());
                                body.setXRot(other.getXRot());
                                body.setXRot(other.getXRot());
                                body.setInvulnerable(true);
                                other.level().tryAddFreshEntityWithPassengers((Entity)body);
                            }
                            for (int i = 0; i < other.getInventory().getNonEquipmentItems().size(); ++i) {
                                ItemStack itemstack = (ItemStack)other.getInventory().getNonEquipmentItems().get(i);
                                if (itemstack.isEmpty()) continue;
                                other.drop(itemstack, true, false);
                                other.getInventory().getNonEquipmentItems().set(i, (Object)ItemStack.EMPTY);
                            }
                            if (!other.getOffhandItem().isEmpty()) {
                                other.drop(other.getOffhandItem(), true, false);
                                other.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                            }
                            other.setGameMode(GameType.SPECTATOR);
                            StaminaBar bar = (StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR);
                            bar.removeStatus(AfflictionTypes.HUNGER, 2.0f);
                            bar.addStatus((LivingEntity)player, AfflictionTypes.CURSE, 0.1f);
                            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 0.5f, Mth.randomBetween((RandomSource)player.getRandom(), (float)0.9f, (float)1.0f));
                            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS_SERVER);
                            event.setCanceled(true);
                        }
                        player.setData(PeakAttachmentTypes.INTERACT_TIMER, (Object)-1);
                        player.setData(PeakAttachmentTypes.INTERACT_TYPE, (Object)-1);
                        player.setData(PeakAttachmentTypes.INTERACT_ITEM, (Object)ItemStack.EMPTY);
                        player.setData(PeakAttachmentTypes.INTERACT_TARGET, (Object)new InteractTarget(Optional.empty()));
                    } else {
                        Consumable consumable;
                        if ((Integer)player.getData(PeakAttachmentTypes.INTERACT_TYPE) == 1 && this.shouldEmitParticlesAndSounds((Integer)player.getData(PeakAttachmentTypes.INTERACT_TIMER))) {
                            this.emitParticlesAndSounds(player.getRandom(), (LivingEntity)player, 5);
                        }
                        if ((Integer)player.getData(PeakAttachmentTypes.INTERACT_TYPE) == 0 && this.shouldEmitParticlesAndSounds((Integer)player.getData(PeakAttachmentTypes.INTERACT_TIMER)) && (consumable = (Consumable)event.getItemStack().get(DataComponents.CONSUMABLE)) != null) {
                            this.emitParticlesAndSounds(other.getRandom(), (LivingEntity)other, event.getItemStack(), 5, consumable);
                        }
                        if ((Integer)player.getData(PeakAttachmentTypes.INTERACT_TYPE) == 0 && this.shouldEmitParticlesAndSounds((Integer)player.getData(PeakAttachmentTypes.INTERACT_TIMER))) {
                            player.stopUsingItem();
                        }
                    }
                }
            }
        }
    }

    public void emitParticlesAndSounds(RandomSource randomSource, LivingEntity living, int count) {
        living.spawnItemParticles(new ItemStack((ItemLike)Items.COOKED_CHICKEN), count);
        living.level().playSound(null, living.getX(), living.getY(), living.getZ(), (SoundEvent)SoundEvents.GENERIC_EAT.value(), SoundSource.PLAYERS, randomSource.nextBoolean() ? 0.5f : 1.0f, randomSource.triangle(1.0f, 0.2f));
    }

    public void emitParticlesAndSounds(RandomSource randomSource, LivingEntity living, ItemStack stack, int count, Consumable consumable) {
        SoundEvent soundevent;
        float f5;
        float f = randomSource.nextBoolean() ? 0.5f : 1.0f;
        float f1 = randomSource.triangle(1.0f, 0.2f);
        float f3 = Mth.randomBetween((RandomSource)randomSource, (float)0.9f, (float)1.0f);
        float f4 = consumable.animation() == ItemUseAnimation.DRINK ? 0.5f : f;
        float f2 = f5 = consumable.animation() == ItemUseAnimation.DRINK ? f3 : f1;
        if (consumable.hasConsumeParticles()) {
            living.spawnItemParticles(stack, count);
        }
        if (living instanceof Consumable.OverrideConsumeSound) {
            Consumable.OverrideConsumeSound overrideConsumeSound = (Consumable.OverrideConsumeSound)living;
            soundevent = overrideConsumeSound.getConsumeSound(stack);
        } else {
            soundevent = (SoundEvent)consumable.sound().value();
        }
        living.level().playSound(null, living.getX(), living.getY(), living.getZ(), soundevent, SoundSource.PLAYERS, f4, f5);
    }

    protected boolean shouldEmitParticlesAndSounds(int p_366816_) {
        int i = 32 - p_366816_;
        int j = 7;
        boolean flag = i > j;
        return flag && p_366816_ % 4 == 0;
    }

    protected void doHurtEquipment(LivingEntity entity, DamageSource p_330843_, float p_330394_, EquipmentSlot ... p_331314_) {
        if (!(p_330394_ <= 0.0f)) {
            int i = (int)Math.max(1.0f, p_330394_ / 4.0f);
            CommonHooks.onArmorHurt((DamageSource)p_330843_, (EquipmentSlot[])p_331314_, (float)i, (LivingEntity)entity);
        }
    }

    protected float getDamageAfterMagicAbsorb(LivingEntity entity, DamageSource source, float damage) {
        float f3;
        if (source.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return damage;
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        if (source.is(DamageTypeTags.BYPASSES_ENCHANTMENTS)) {
            return damage;
        }
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f3 = EnchantmentHelper.getDamageProtection((ServerLevel)serverlevel, (LivingEntity)entity, (DamageSource)source);
        } else {
            f3 = 0.0f;
        }
        if (f3 > 0.0f) {
            damage = CombatRules.getDamageAfterMagicAbsorb((float)damage, (float)f3);
        }
        return damage;
    }

    protected float getDamageAfterArmorAbsorb(LivingEntity entity, DamageSource source, float damage) {
        if (!source.is(DamageTypeTags.BYPASSES_ARMOR)) {
            this.doHurtEquipment(entity, source, damage, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
            damage = CombatRules.getDamageAfterAbsorb((LivingEntity)entity, (float)damage, (DamageSource)source, (float)entity.getArmorValue(), (float)((float)entity.getAttributeValue(Attributes.ARMOR_TOUGHNESS)));
        }
        return damage;
    }

    private static Vec3 getViewVector(float p_20253_, Player player) {
        return player.calculateViewVector(0.0f, player.getViewYRot(p_20253_));
    }

    private static Direction getNearestViewDirection(Player player) {
        return Direction.getApproximateNearest((Vec3)Peak.getViewVector(1.0f, player));
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

