/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.client;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import net.tintankgames.peak.Peak;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.client.model.EdiblePlayerModel;
import net.tintankgames.peak.client.model.PeakModels;
import net.tintankgames.peak.stamina.AfflictionTypes;
import net.tintankgames.peak.stamina.StaminaBar;
import net.tintankgames.peak.world.level.block.PeakBlocks;

@EventBusSubscriber(modid="peak", value={Dist.CLIENT})
public class PeakClient {
    public static final ContextKey<Boolean> IS_LOCAL_PLAYER = new ContextKey(Peak.id("is_local_player"));
    public static final ContextKey<Boolean> IS_CHICKEN = new ContextKey(Peak.id("is_chicken"));
    public static final ContextKey<Boolean> IS_CLIMBING = new ContextKey(Peak.id("is_climbing"));
    public static final ContextKey<Boolean> IS_HOLDING_PITON = new ContextKey(Peak.id("is_holding_piton"));
    public static final ContextKey<Boolean> IS_MOVING = new ContextKey(Peak.id("is_moving"));
    public static final ContextKey<Float> STAMINA = new ContextKey(Peak.id("stamina"));
    public static final ContextKey<AnimationState> CLIMBING = new ContextKey(Peak.id("climbing"));
    public static final ContextKey<AnimationState> CLIMBING_IDLE = new ContextKey(Peak.id("climbing_idle"));
    public static final ContextKey<AnimationState> HOLDING_PITON = new ContextKey(Peak.id("holding_piton"));
    public static Supplier<EdiblePlayerModel> chickenMan = Suppliers.memoize(() -> new EdiblePlayerModel(Minecraft.getInstance().getEntityModels().bakeLayer(PeakModels.EDIBLE_PLAYER)));

    @SubscribeEvent
    public static void renderStateMods(RegisterRenderStateModifiersEvent event) {
        event.registerEntityModifier(PlayerRenderer.class, (player, renderState) -> {
            renderState.setRenderData(CLIMBING, (Object)((AnimationState)player.getData(PeakAttachmentTypes.CLIMBING_STATE)));
            renderState.setRenderData(CLIMBING_IDLE, (Object)((AnimationState)player.getData(PeakAttachmentTypes.CLIMBING_IDLE_STATE)));
            renderState.setRenderData(HOLDING_PITON, (Object)((AnimationState)player.getData(PeakAttachmentTypes.HOLDING_PITON_STATE)));
            renderState.setRenderData(STAMINA, (Object)Float.valueOf(((StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR)).getStamina(true)));
            renderState.setRenderData(IS_CLIMBING, (Object)((Boolean)player.getData(PeakAttachmentTypes.CLIMBING) != false && ((StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR)).hasStamina((Entity)player, true) && (player.level().getBlockState(player.blockPosition().relative(PeakClient.getNearestViewDirection((Player)player))).isFaceSturdy((BlockGetter)player.level(), player.blockPosition().relative(PeakClient.getNearestViewDirection((Player)player)), PeakClient.getNearestViewDirection((Player)player).getOpposite()) || player.level().getBlockState(player.blockPosition().above().relative(PeakClient.getNearestViewDirection((Player)player))).isFaceSturdy((BlockGetter)player.level(), player.blockPosition().above().relative(PeakClient.getNearestViewDirection((Player)player)), PeakClient.getNearestViewDirection((Player)player).getOpposite())) ? 1 : 0));
            renderState.setRenderData(IS_HOLDING_PITON, (Object)((Boolean)player.getData(PeakAttachmentTypes.GRABBING_PITON)));
            renderState.setRenderData(IS_MOVING, (Object)(((Vec2)player.getData(PeakAttachmentTypes.INPUT)).length() > 0.05f ? 1 : 0));
            renderState.setRenderData(IS_LOCAL_PLAYER, (Object)(Minecraft.getInstance().player == player ? 1 : 0));
            renderState.setRenderData(IS_CHICKEN, (Object)(((StaminaBar)Minecraft.getInstance().player.getData(PeakAttachmentTypes.STAMINA_BAR)).getStatus(AfflictionTypes.HUNGER) >= 0.7f && (Integer)Minecraft.getInstance().player.getData(PeakAttachmentTypes.DEATH_TIMER) < 0 ? 1 : 0));
            if (((StaminaBar)Minecraft.getInstance().player.getData(PeakAttachmentTypes.STAMINA_BAR)).getStatus(AfflictionTypes.HUNGER) >= 0.7f && (Integer)Minecraft.getInstance().player.getData(PeakAttachmentTypes.DEATH_TIMER) >= 0 && Minecraft.getInstance().player != player) {
                renderState.chestEquipment = ItemStack.EMPTY;
                renderState.legsEquipment = ItemStack.EMPTY;
                renderState.feetEquipment = ItemStack.EMPTY;
            }
        });
    }

    @SubscribeEvent
    public static void tints(RegisterColorHandlersEvent.Block event) {
        event.register((state, blockAndTintGetter, pos, i) -> blockAndTintGetter != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)pos) : GrassColor.getDefaultColor(), new Block[]{(Block)PeakBlocks.GRASSY_ANCIENT_STATUE.get()});
    }

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)PeakBlocks.GRASSY_ANCIENT_STATUE.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT_MIPPED);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)PeakBlocks.EXPLOSIVE_BULB.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT_MIPPED);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)PeakBlocks.DYNAMITE.get()), (ChunkSectionLayer)ChunkSectionLayer.CUTOUT);
    }

    private static Vec3 getViewVector(float delta, Player player) {
        return player.calculateViewVector(0.0f, player.getViewYRot(delta));
    }

    private static Direction getNearestViewDirection(Player player) {
        return Direction.getApproximateNearest((Vec3)PeakClient.getViewVector(1.0f, player));
    }
}

