/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.client.gui;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.tintankgames.peak.Peak;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.core.registries.PeakRegistries;
import net.tintankgames.peak.stamina.AfflictionType;
import net.tintankgames.peak.stamina.AfflictionTypes;
import net.tintankgames.peak.stamina.StaminaBar;
import net.tintankgames.peak.world.item.PeakItems;
import net.tintankgames.peak.world.level.block.PeakBlocks;

@EventBusSubscriber(value={Dist.CLIENT})
public class PeakGui {
    @SubscribeEvent
    public static void noNormalStuff(RenderGuiLayerEvent.Pre event) {
        if (event.getName() == VanillaGuiLayers.PLAYER_HEALTH || event.getName() == VanillaGuiLayers.ARMOR_LEVEL || event.getName() == VanillaGuiLayers.FOOD_LEVEL || event.getName() == VanillaGuiLayers.VEHICLE_HEALTH || event.getName() == VanillaGuiLayers.AIR_LEVEL || event.getName() == VanillaGuiLayers.CONTEXTUAL_INFO_BAR_BACKGROUND || event.getName() == VanillaGuiLayers.EXPERIENCE_LEVEL || event.getName() == VanillaGuiLayers.CONTEXTUAL_INFO_BAR) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void theBar(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, Peak.id("stamina_bar"), (guiGraphics, deltaTracker) -> {
            if (!Minecraft.getInstance().options.hideGui) {
                int height;
                int i;
                LocalPlayer player = Minecraft.getInstance().player;
                StaminaBar bar = (StaminaBar)(Minecraft.getInstance().cameraEntity != null ? Minecraft.getInstance().cameraEntity : player).getExistingDataOrNull(PeakAttachmentTypes.STAMINA_BAR);
                if (bar != null) {
                    i = guiGraphics.guiWidth() / 2;
                    height = guiGraphics.guiHeight() - 33;
                    if (bar.hasExtraStamina()) {
                        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/bar_extra_outline"), i - 81, height - 1, Math.round(160.0f * bar.getMaxExtraStamina()) + 2, 10);
                        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/bar_extra"), i - 80, height, Math.round(160.0f * bar.getExtraStamina()), 8);
                        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/extra_stamina"), i - 90, height, 8, 8);
                        height -= 12;
                    }
                    if (player.isCreative() || player.getMainHandItem().is(PeakItems.ANCIENT_IDOL)) {
                        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/bar_outline_creative"), i - 81, height - 1, 162, 10);
                    } else {
                        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/bar_outline"), i - 81, height - 1, 162, 10);
                    }
                    if ((Integer)player.getData(PeakAttachmentTypes.INFINITE_TIMER) <= 0) {
                        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/bar"), i - 80, height, Math.round(160.0f * bar.getStamina()), 8);
                    } else {
                        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/bar_infinite_" + player.tickCount % 18), i - 80, height, Math.round(160.0f * (1.0f - bar.getTotalAffliction())), 8);
                    }
                    if (player.isCreative() || player.getMainHandItem().is(PeakItems.ANCIENT_IDOL)) {
                        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/creative"), i - 90, height, 8, 8);
                    }
                    Registry registry = player.registryAccess().lookupOrThrow(PeakRegistries.AFFLICTION_TYPE);
                    ArrayList list = new ArrayList(registry.registryKeySet());
                    list.sort((o1, o2) -> Float.compare(((AfflictionType)registry.getValueOrThrow(o1)).sort(), ((AfflictionType)registry.getValueOrThrow(o2)).sort()));
                    if (bar.getTotalAffliction() <= 1.0f) {
                        status = bar.getTotalAffliction();
                        for (ResourceKey type : list) {
                            if (!bar.hasStatus((ResourceKey<AfflictionType>)type)) continue;
                            AfflictionType type1 = (AfflictionType)registry.getValueOrThrow(type);
                            if (bar.getStatus((ResourceKey<AfflictionType>)type) == 0.025f) {
                                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/damage_single"), i - 80 + Math.round(160.0f * (1.0f - status)), height, 4, 8, type1.color());
                            } else {
                                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/damage_left"), i - 80 + Math.round(160.0f * (1.0f - status)), height, 4, 8, type1.color());
                                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/damage_middle"), i - 80 + Math.round(160.0f * (1.0f - (status - 0.025f))), height, Math.round(160.0f * (bar.getStatus((ResourceKey<AfflictionType>)type) - 0.025f)), 8, type1.color());
                                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/damage_right_overlay"), i - 80 + Math.round(160.0f * (1.0f - (status - bar.getStatus((ResourceKey<AfflictionType>)type)))) - 1, height, 1, 8, type1.color());
                            }
                            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, type1.sprite(), i - 80 + Math.round(160.0f * (1.0f - (status - bar.getStatus((ResourceKey<AfflictionType>)type) / 2.0f))) - 4, height - 10, 8, 8);
                            status -= bar.getStatus((ResourceKey<AfflictionType>)type);
                        }
                    } else {
                        status = 0.0f;
                        for (ResourceKey type : list) {
                            if (!bar.hasStatus((ResourceKey<AfflictionType>)type)) continue;
                            AfflictionType type1 = (AfflictionType)registry.getValueOrThrow(type);
                            if (bar.getStatus((ResourceKey<AfflictionType>)type) == 0.025f) {
                                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/damage_single"), i - 80 + Math.round(160.0f * status), height, 4, 8, type1.color());
                            } else {
                                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/damage_left"), i - 80 + Math.round(160.0f * status), height, 4, 8, type1.color());
                                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/damage_middle"), i - 80 + Math.round(160.0f * (status + 0.025f)), height, Math.round(160.0f * (bar.getStatus((ResourceKey<AfflictionType>)type) - 0.025f)), 8, type1.color());
                                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/damage_right_overlay"), i - 80 + Math.round(160.0f * (status + bar.getStatus((ResourceKey<AfflictionType>)type))) - 1, height, 1, 8, type1.color());
                            }
                            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, type1.sprite(), i - 80 + Math.round(160.0f * (status + bar.getStatus((ResourceKey<AfflictionType>)type) / 2.0f)) - 4, height - 10, 8, 8);
                            status += bar.getStatus((ResourceKey<AfflictionType>)type);
                        }
                        int overflow = Math.round((status - 1.0f) * 40.0f);
                        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/bar_outline_overflow_start"), i + 80, height - 2, 1, 12);
                        for (int j = 0; j < overflow; ++j) {
                            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/bar_outline_overflow"), i + 80 + j * 4, height - 1, 4, 10);
                        }
                        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("stamina_bar/bar_outline_overflow_edge"), i + 80 + overflow * 4, height - 1, 1, 10);
                    }
                    height = guiGraphics.guiHeight() - 100;
                    BlockHitResult hit = player.level().clip(new ClipContext(player.getEyePosition(deltaTracker.getGameTimeDeltaTicks()), player.getEyePosition(deltaTracker.getGameTimeDeltaTicks()).add(player.getViewVector(deltaTracker.getGameTimeDeltaTicks()).scale(player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE))), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                    HitResult eatHit = ProjectileUtil.getHitResultOnViewVector((Entity)player, entity -> entity instanceof Player, (double)player.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE));
                    if (((Boolean)player.getData(PeakAttachmentTypes.CLIMBING)).booleanValue() && (player.level().getBlockState(player.blockPosition().relative(PeakGui.getNearestViewDirection((Player)player))).isFaceSturdy((BlockGetter)player.level(), player.blockPosition().relative(PeakGui.getNearestViewDirection((Player)player)), PeakGui.getNearestViewDirection((Player)player).getOpposite()) || player.level().getBlockState(player.blockPosition().above().relative(PeakGui.getNearestViewDirection((Player)player))).isFaceSturdy((BlockGetter)player.level(), player.blockPosition().above().relative(PeakGui.getNearestViewDirection((Player)player)), PeakGui.getNearestViewDirection((Player)player).getOpposite())) && (bar.hasStamina((Entity)player, true) || ((Vec3)player.getData(PeakAttachmentTypes.MOVEMENT_LUNGE)).length() > 0.05 || ((Vec3)player.getData(PeakAttachmentTypes.MOVEMENT_ASSIST)).length() > 0.05)) {
                        if (bar.getStamina() > 0.0f && (double)bar.getStamina() <= 0.025 || bar.getExtraStamina() > 0.0f && (double)bar.getExtraStamina() <= 0.025) {
                            guiGraphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.tooltip.lunge", (Object[])new Object[]{Component.keybind((String)Minecraft.getInstance().options.keyShift.getName())}), i, height, -1);
                        } else if (hit.getType() != HitResult.Type.MISS && player.level().getBlockState(hit.getBlockPos()).is(PeakBlocks.PITON)) {
                            guiGraphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.tooltip.grab_piton", (Object[])new Object[]{Component.keybind((String)Minecraft.getInstance().options.keyInventory.getName())}), i, height, -1);
                        } else if (player.getInventory().contains(stack -> stack.is(PeakBlocks.PITON.asItem()))) {
                            guiGraphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.tooltip.place_piton", (Object[])new Object[]{Component.keybind((String)Minecraft.getInstance().options.keyInventory.getName())}), i, height, -1);
                        }
                    } else if (eatHit.getType() == HitResult.Type.ENTITY && bar.getStatus(AfflictionTypes.HUNGER) >= 0.7f) {
                        guiGraphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.tooltip.cannibalism", (Object[])new Object[]{Component.keybind((String)Minecraft.getInstance().options.keyUse.getName())}), i, height, -1);
                    }
                }
                i = guiGraphics.guiWidth() / 2;
                height = 11;
                if ((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) > 0) {
                    float value = Mth.lerp((float)deltaTracker.getGameTimeDeltaTicks(), (float)((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER_O)).intValue(), (float)((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER)).intValue()) / (float)((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER_MAX)).intValue();
                    float percent = Mth.clamp((float)Mth.lerp((float)value, (float)-0.2f, (float)1.2f), (float)0.0f, (float)1.0f);
                    float blue = Mth.clamp((float)percent, (float)0.0f, (float)0.9f);
                    float green = Mth.clamp((float)(percent - 0.5f), (float)0.0f, (float)0.5f);
                    float red = Mth.clamp((float)(1.0f - percent), (float)0.0f, (float)0.9f);
                    guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("death_meter/bar_outline"), i - 41, height - 1, 82, 6);
                    guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("death_meter/bar"), i - 40, height, Math.round(80.0f * value), 4, ARGB.colorFromFloat((float)1.0f, (float)red, (float)green, (float)blue));
                    if (Math.round(80.0f * value) > 0) {
                        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Peak.id("death_meter/bar_edge"), i - 41 + Math.round(80.0f * value), height, 1, 4, ARGB.colorFromFloat((float)1.0f, (float)red, (float)green, (float)blue));
                    }
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.death.give_up", (Object[])new Object[]{Component.keybind((String)Minecraft.getInstance().options.keyInventory.getName())}), i + 61, height, -1);
                } else if ((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) == 0) {
                    guiGraphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.death.ghost"), i, height, -1);
                    guiGraphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"gui.death.revive"), i, height + 10, -1);
                }
            }
        });
        event.registerAboveAll(Peak.id("fade"), (guiGraphics, deltaTracker) -> {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                int fade = (Integer)player.getData(PeakAttachmentTypes.PASS_OUT_FADE);
                int fadeO = (Integer)player.getData(PeakAttachmentTypes.PASS_OUT_FADE_O);
                float alpha = Mth.lerp((float)deltaTracker.getGameTimeDeltaTicks(), (float)fadeO, (float)fade) / 20.0f;
                guiGraphics.fill(RenderPipelines.GUI, 0, 0, guiGraphics.guiWidth(), guiGraphics.guiHeight(), ARGB.color((float)alpha, (int)0));
            }
        });
    }

    private static Vec3 getViewVector(float p_20253_, Player player) {
        return player.calculateViewVector(0.0f, player.getViewYRot(p_20253_));
    }

    private static Direction getNearestViewDirection(Player player) {
        return Direction.getApproximateNearest((Vec3)PeakGui.getViewVector(1.0f, player));
    }
}

