/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;

public class ReviveParticle
extends NoRenderParticle {
    private final Vec3 pos;
    private int life;

    public ReviveParticle(ClientLevel clientLevel, double x, double y, double z) {
        super(clientLevel, x, y, z, 0.0, 0.0, 0.0);
        this.pos = new Vec3(x, y, z);
        this.tick();
    }

    public void tick() {
        for (int i = 0; i < 16; ++i) {
            double d2;
            double d1;
            double d0 = this.random.nextFloat() * 2.0f - 1.0f;
            if (d0 * d0 + (d1 = (double)(this.random.nextFloat() * 2.0f - 1.0f)) * d1 + (d2 = (double)(this.random.nextFloat() * 2.0f - 1.0f)) * d2 > 1.0) continue;
            double d3 = this.pos.x + d0 / 4.0 * 0.6;
            double d4 = this.pos.y + 0.5 + d1 / 4.0 * 0.6;
            double d5 = this.pos.z + d2 / 4.0 * 0.6;
            this.level.addParticle((ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, d3, d4, d5, d0, d1 + 0.2, d2);
        }
        ++this.life;
        if (this.life >= 30) {
            this.remove();
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType p_108377_, ClientLevel p_108378_, double p_108379_, double p_108380_, double p_108381_, double p_108382_, double p_108383_, double p_108384_) {
            return new ReviveParticle(p_108378_, p_108379_, p_108380_, p_108381_);
        }
    }
}

