/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.client.renderer.entity;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tintankgames.peak.client.model.FallenScoutModel;
import net.tintankgames.peak.client.model.PeakModels;
import net.tintankgames.peak.client.renderer.entity.layers.ScoutArmorLayer;
import net.tintankgames.peak.world.entity.FallenScout;

public class FallenScoutRenderer
extends MobRenderer<FallenScout, HumanoidRenderState, FallenScoutModel> {
    private static final ResourceLocation SKELETON_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/skeleton.png");

    public FallenScoutRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new FallenScoutModel(context.bakeLayer(PeakModels.FALLEN_SCOUT)), 0.5f);
        this.addLayer(new ScoutArmorLayer(this, new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getEquipmentRenderer()));
    }

    public ResourceLocation getTextureLocation(HumanoidRenderState renderState) {
        return SKELETON_LOCATION;
    }

    public HumanoidRenderState createRenderState() {
        return new HumanoidRenderState();
    }

    public void extractRenderState(FallenScout fallenScout, HumanoidRenderState renderState, float deltaTick) {
        super.extractRenderState((LivingEntity)fallenScout, (LivingEntityRenderState)renderState, deltaTick);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)fallenScout, (HumanoidRenderState)renderState, (float)deltaTick, (ItemModelResolver)this.itemModelResolver);
        renderState.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        renderState.rightArmPose = HumanoidModel.ArmPose.EMPTY;
    }
}

