/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tintankgames.peak.client.model.PeakModels;
import net.tintankgames.peak.client.model.UnconsciousScoutModel;
import net.tintankgames.peak.client.renderer.entity.layers.ScoutArmorLayer;
import net.tintankgames.peak.client.renderer.entity.state.UnconsciousScoutRenderState;
import net.tintankgames.peak.world.entity.UnconsciousScout;

public class UnconsciousScoutRenderer
extends MobRenderer<UnconsciousScout, UnconsciousScoutRenderState, UnconsciousScoutModel> {
    private final UnconsciousScoutModel wideModel;
    private final UnconsciousScoutModel slimModel;

    public UnconsciousScoutRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new UnconsciousScoutModel(context.bakeLayer(PeakModels.UNCONSCIOUS_SCOUT)), 0.5f);
        this.wideModel = new UnconsciousScoutModel(context.bakeLayer(PeakModels.UNCONSCIOUS_SCOUT));
        this.slimModel = new UnconsciousScoutModel(context.bakeLayer(PeakModels.UNCONSCIOUS_SCOUT_SLIM));
        this.model = this.wideModel;
        this.addLayer(new ScoutArmorLayer(this, new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getEquipmentRenderer()));
    }

    public ResourceLocation getTextureLocation(UnconsciousScoutRenderState renderState) {
        return renderState.ownerTexture;
    }

    public void render(UnconsciousScoutRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int deltaTicks) {
        this.model = renderState.slim ? this.slimModel : this.wideModel;
        super.render((LivingEntityRenderState)renderState, poseStack, bufferSource, deltaTicks);
    }

    public UnconsciousScoutRenderState createRenderState() {
        return new UnconsciousScoutRenderState();
    }

    public void extractRenderState(UnconsciousScout fallenScout, UnconsciousScoutRenderState renderState, float deltaTick) {
        super.extractRenderState((LivingEntity)fallenScout, (LivingEntityRenderState)renderState, deltaTick);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)fallenScout, (HumanoidRenderState)renderState, (float)deltaTick, (ItemModelResolver)this.itemModelResolver);
        if (fallenScout.getOwnerReference() != null && Minecraft.getInstance().getConnection().getPlayerInfo(fallenScout.getOwnerReference().getUUID()) != null) {
            PlayerSkin skin = Minecraft.getInstance().getConnection().getPlayerInfo(fallenScout.getOwnerReference().getUUID()).getSkin();
            renderState.ownerTexture = skin.texture();
            renderState.slim = skin.model() == PlayerSkin.Model.SLIM;
        } else {
            renderState.ownerTexture = ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/steve.png");
            renderState.slim = false;
        }
        renderState.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        renderState.rightArmPose = HumanoidModel.ArmPose.EMPTY;
    }
}

