/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.datagen;

import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.BlockTagCopyingItemTagProvider;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.tintankgames.peak.Peak;
import net.tintankgames.peak.core.registries.PeakDataMaps;
import net.tintankgames.peak.core.registries.PeakRegistries;
import net.tintankgames.peak.stamina.AfflictionType;
import net.tintankgames.peak.stamina.AfflictionTypes;
import net.tintankgames.peak.tags.PeakTags;
import net.tintankgames.peak.world.entity.PeakEntityTypes;
import net.tintankgames.peak.world.item.PeakCreativeModeTabs;
import net.tintankgames.peak.world.item.PeakItems;
import net.tintankgames.peak.world.item.component.PeakConsumable;
import net.tintankgames.peak.world.item.component.Poisonous;
import net.tintankgames.peak.world.level.block.AncientStatueBlock;
import net.tintankgames.peak.world.level.block.PeakBlocks;

@EventBusSubscriber(modid="peak", value={Dist.CLIENT})
public class PeakDataGenerator {
    public static final ModelTemplate BING_BONG = ModelTemplates.createItem((String)"peak:template_bing_bong", (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE});
    public static final ModelTemplate BLOWGUN = ModelTemplates.createItem((String)"peak:template_blowgun", (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE});
    public static final ModelTemplate BLOWGUN_BLOWING = ModelTemplates.createItem((String)"peak:template_blowgun_blowing", (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE});
    public static final ModelTemplate ANCIENT_STATUE_LOWER = ModelTemplates.create((String)"peak:template_ancient_statue_lower", (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE, TextureSlot.PARTICLE});
    public static final ModelTemplate ANCIENT_STATUE_UPPER = ModelTemplates.create((String)"peak:template_ancient_statue_upper", (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE, TextureSlot.PARTICLE});
    public static final ModelTemplate ANCIENT_STATUE_UPPER_BROKEN = ModelTemplates.create((String)"peak:template_ancient_statue_upper_broken", (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE, TextureSlot.PARTICLE});
    public static final TextureSlot TINT = TextureSlot.create((String)"tint");
    public static final ModelTemplate ANCIENT_STATUE_TINTED_LOWER = ModelTemplates.create((String)"peak:template_ancient_statue_tinted_lower", (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE, TINT, TextureSlot.PARTICLE});
    public static final ModelTemplate ANCIENT_STATUE_TINTED_UPPER = ModelTemplates.create((String)"peak:template_ancient_statue_tinted_upper", (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE, TINT, TextureSlot.PARTICLE});
    public static final ModelTemplate ANCIENT_STATUE_TINTED_UPPER_BROKEN = ModelTemplates.create((String)"peak:template_ancient_statue_tinted_upper_broken", (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE, TINT, TextureSlot.PARTICLE});

    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        event.createDatapackRegistryObjects(new RegistrySetBuilder().add(PeakRegistries.AFFLICTION_TYPE, context -> {
            context.register(AfflictionTypes.WEIGHT, (Object)new AfflictionType(10443293, 2.0f, 0.0f, Peak.id("stamina_bar/weight"), Optional.empty()));
            context.register(AfflictionTypes.HUNGER, (Object)new AfflictionType(16762880, 2.0f, 20.0f, Peak.id("stamina_bar/hunger"), Optional.empty()));
            context.register(AfflictionTypes.COLD, (Object)new AfflictionType(506353, 2.0f, 40.0f, Peak.id("stamina_bar/cold"), Optional.of(new AfflictionType.Recovery(60, 7.5E-4f))));
            context.register(AfflictionTypes.INJURY, (Object)new AfflictionType(16339204, 1.0f, 60.0f, Peak.id("stamina_bar/injury"), Optional.empty()));
            context.register(AfflictionTypes.POISON, (Object)new AfflictionType(10434299, 2.0f, 80.0f, Peak.id("stamina_bar/poison"), Optional.of(new AfflictionType.Recovery(600, 2.0E-4f))));
            context.register(AfflictionTypes.DROWSY, (Object)new AfflictionType(15227814, 2.0f, 100.0f, Peak.id("stamina_bar/drowsy"), Optional.of(new AfflictionType.Recovery(200, 7.5E-4f))));
            context.register(AfflictionTypes.HOT, (Object)new AfflictionType(13438232, 2.0f, 120.0f, Peak.id("stamina_bar/hot"), Optional.of(new AfflictionType.Recovery(160, 6.5E-4f))));
            context.register(AfflictionTypes.CRAB, (Object)new AfflictionType(14692674, 2.0f, 130.0f, Peak.id("stamina_bar/crab"), Optional.empty()));
            context.register(AfflictionTypes.CURSE, (Object)new AfflictionType(1181746, 2.0f, 140.0f, Peak.id("stamina_bar/curse"), Optional.empty()));
            context.register(AfflictionTypes.THORNS, (Object)new AfflictionType(7440896, 2.0f, 160.0f, Peak.id("stamina_bar/thorns"), Optional.of(new AfflictionType.Recovery(600, 2.0f))));
        }));
        event.createBlockAndItemTags((output, completableFuture) -> new BlockTagsProvider(output, completableFuture, "peak"){

            protected void addTags(HolderLookup.Provider provider) {
            }
        }, (output, lookup, tags) -> new BlockTagCopyingItemTagProvider(output, lookup, tags, "peak"){

            protected void addTags(HolderLookup.Provider provider) {
                this.tag(PeakTags.Items.WEIGHS_0);
                this.tag(PeakTags.Items.WEIGHS_5).add((Object[])new Item[]{(Item)PeakItems.FIRST_AID_KIT.get(), (Item)PeakItems.COOKED_FIRST_AID_KIT.get(), (Item)PeakItems.BING_BONG.get()});
            }
        });
        event.createProvider((output, completableFuture) -> new DataMapProvider(output, completableFuture){

            protected void gather(HolderLookup.Provider provider) {
                this.builder(PeakDataMaps.ITEM_WEIGHTS).add(PeakTags.Items.WEIGHS_0, (Object)Float.valueOf(0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.ITEM_WEIGHTS).add(PeakTags.Items.WEIGHS_5, (Object)Float.valueOf(0.05f), false, new ICondition[0]);
                this.builder(PeakDataMaps.ITEM_WEIGHTS).add(BuiltInRegistries.ITEM.getKey((Object)((Item)PeakItems.ANCIENT_IDOL.get())), (Object)Float.valueOf(0.4f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.APPLE), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.05f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.BAKED_POTATO), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.15f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.BEEF), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.15f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.BEETROOT), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.025f), AfflictionTypes.POISON, Float.valueOf(-0.1f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.BEETROOT_SOUP), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.15f), AfflictionTypes.POISON, Float.valueOf(-0.35f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.BREAD), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.1f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.CARROT), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.05f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.CHICKEN), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.15f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.CHORUS_FRUIT), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.05f), AfflictionTypes.DROWSY, Float.valueOf(-2.0f), AfflictionTypes.THORNS, Float.valueOf(-2.0f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.COD), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.1f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.COOKED_BEEF), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.3f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.COOKED_CHICKEN), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.3f), AfflictionTypes.COLD, Float.valueOf(-0.35f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.COOKED_COD), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.2f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.COOKED_MUTTON), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.2f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.COOKED_PORKCHOP), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.3f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.COOKED_RABBIT), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.15f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.COOKED_SALMON), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.2f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.COOKIE), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.05f))), 0.25f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.DRIED_KELP), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.025f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.ENCHANTED_GOLDEN_APPLE), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.6f), AfflictionTypes.COLD, Float.valueOf(-1.05f), AfflictionTypes.INJURY, Float.valueOf(-1.05f), AfflictionTypes.POISON, Float.valueOf(-1.05f), AfflictionTypes.DROWSY, Float.valueOf(-1.05f), AfflictionTypes.HOT, Float.valueOf(-1.05f), AfflictionTypes.CRAB, Float.valueOf(-1.05f), AfflictionTypes.CURSE, Float.valueOf(-0.15f))), 0.3f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.GLOW_BERRIES), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.05f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.GOLDEN_APPLE), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.2f), AfflictionTypes.COLD, Float.valueOf(-0.35f), AfflictionTypes.INJURY, Float.valueOf(-0.35f), AfflictionTypes.POISON, Float.valueOf(-0.35f), AfflictionTypes.DROWSY, Float.valueOf(-0.35f), AfflictionTypes.HOT, Float.valueOf(-0.35f), AfflictionTypes.CRAB, Float.valueOf(-0.35f), AfflictionTypes.CURSE, Float.valueOf(-0.05f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.GOLDEN_CARROT), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.15f), AfflictionTypes.COLD, Float.valueOf(-0.25f), AfflictionTypes.INJURY, Float.valueOf(-0.25f), AfflictionTypes.POISON, Float.valueOf(-0.25f), AfflictionTypes.DROWSY, Float.valueOf(-0.25f), AfflictionTypes.HOT, Float.valueOf(-0.25f), AfflictionTypes.CRAB, Float.valueOf(-0.25f))), 0.3f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.HONEY_BOTTLE), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.15f), AfflictionTypes.POISON, Float.valueOf(-0.5f))), 0.5f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.MELON_SLICE), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.05f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.MUSHROOM_STEW), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.3f), AfflictionTypes.POISON, Float.valueOf(-0.5f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.MUTTON), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.1f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.POISONOUS_POTATO), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.1f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.POISONOUS).add(BuiltInRegistries.ITEM.getKey((Object)Items.POISONOUS_POTATO), (Object)new Poisonous(8.0f, 2.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.PORKCHOP), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.15f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.POTATO), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.075f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.PUFFERFISH), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.05f), AfflictionTypes.INJURY, Float.valueOf(0.05f), AfflictionTypes.POISON, Float.valueOf(0.4f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.POISONOUS).add(BuiltInRegistries.ITEM.getKey((Object)Items.PUFFERFISH), (Object)new Poisonous(16.0f, 1.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.PUMPKIN_PIE), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.3f), AfflictionTypes.INJURY, Float.valueOf(-0.1f), AfflictionTypes.POISON, Float.valueOf(-0.1f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.RABBIT), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.075f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.RABBIT_STEW), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.4f), AfflictionTypes.INJURY, Float.valueOf(-0.15f), AfflictionTypes.POISON, Float.valueOf(-0.15f), AfflictionTypes.HOT, Float.valueOf(-0.15f))), 0.2f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.ROTTEN_FLESH), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.05f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.POISONOUS).add(BuiltInRegistries.ITEM.getKey((Object)Items.ROTTEN_FLESH), (Object)new Poisonous(8.0f, 2.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.SALMON), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.1f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.SPIDER_EYE), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.025f))), 0.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.POISONOUS).add(BuiltInRegistries.ITEM.getKey((Object)Items.SPIDER_EYE), (Object)new Poisonous(24.0f, 2.0f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.SUSPICIOUS_STEW), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.15f))), 0.1f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.SWEET_BERRIES), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.025f))), 0.05f), false, new ICondition[0]);
                this.builder(PeakDataMaps.CONSUMABLES).add(BuiltInRegistries.ITEM.getKey((Object)Items.TROPICAL_FISH), (Object)new PeakConsumable((Map<ResourceKey<AfflictionType>, Float>)new Object2FloatOpenHashMap(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.05f))), 0.0f), false, new ICondition[0]);
            }
        });
        event.createProvider((output, completableFuture) -> new RecipeProvider.Runner(output, completableFuture){

            protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
                return new RecipeProvider(this, provider, recipeOutput){

                    protected void buildRecipes() {
                        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(PeakItems.MARSHMALLOW), (RecipeCategory)RecipeCategory.FOOD, PeakItems.COOKED_MARSHMALLOW, (float)0.35f, (int)200).unlockedBy("has_marshmallow", this.has((ItemLike)PeakItems.MARSHMALLOW)).save(this.output);
                        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(PeakItems.BANDAGES), (RecipeCategory)RecipeCategory.FOOD, PeakItems.COOKED_BANDAGES, (float)0.35f, (int)200).unlockedBy("has_bandages", this.has((ItemLike)PeakItems.BANDAGES)).save(this.output);
                        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(PeakItems.FIRST_AID_KIT), (RecipeCategory)RecipeCategory.FOOD, PeakItems.COOKED_FIRST_AID_KIT, (float)0.35f, (int)200).unlockedBy("has_first_aid_kit", this.has((ItemLike)PeakItems.FIRST_AID_KIT)).save(this.output);
                        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(PeakItems.ANTIDOTE), (RecipeCategory)RecipeCategory.FOOD, PeakItems.COOKED_ANTIDOTE, (float)0.35f, (int)200).unlockedBy("has_antidote", this.has((ItemLike)PeakItems.ANTIDOTE)).save(this.output);
                        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(PeakItems.BIG_LOLLIPOP), (RecipeCategory)RecipeCategory.FOOD, PeakItems.COOKED_BIG_LOLLIPOP, (float)0.35f, (int)200).unlockedBy("has_big_lollipop", this.has((ItemLike)PeakItems.BIG_LOLLIPOP)).save(this.output);
                        this.cookRecipes("smoking", RecipeSerializer.SMOKING_RECIPE, SmokingRecipe::new, 100);
                        this.cookRecipes("campfire_cooking", RecipeSerializer.CAMPFIRE_COOKING_RECIPE, CampfireCookingRecipe::new, 600);
                    }

                    protected <T extends AbstractCookingRecipe> void cookRecipes(String method, RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> factory, int time) {
                        this.simpleCookingRecipe(method, (RecipeSerializer)serializer, (AbstractCookingRecipe.Factory)factory, time, (ItemLike)PeakItems.MARSHMALLOW, (ItemLike)PeakItems.COOKED_MARSHMALLOW, 0.35f);
                        this.simpleCookingRecipe(method, (RecipeSerializer)serializer, (AbstractCookingRecipe.Factory)factory, time, (ItemLike)PeakItems.BANDAGES, (ItemLike)PeakItems.COOKED_BANDAGES, 0.35f);
                        this.simpleCookingRecipe(method, (RecipeSerializer)serializer, (AbstractCookingRecipe.Factory)factory, time, (ItemLike)PeakItems.FIRST_AID_KIT, (ItemLike)PeakItems.COOKED_FIRST_AID_KIT, 0.35f);
                        this.simpleCookingRecipe(method, (RecipeSerializer)serializer, (AbstractCookingRecipe.Factory)factory, time, (ItemLike)PeakItems.ANTIDOTE, (ItemLike)PeakItems.COOKED_ANTIDOTE, 0.35f);
                        this.simpleCookingRecipe(method, (RecipeSerializer)serializer, (AbstractCookingRecipe.Factory)factory, time, (ItemLike)PeakItems.BIG_LOLLIPOP, (ItemLike)PeakItems.COOKED_BIG_LOLLIPOP, 0.35f);
                    }
                };
            }

            public String getName() {
                return "Peak Recipes";
            }
        });
        event.createProvider(output -> new ModelProvider(output, "peak"){

            protected Stream<? extends Holder<Block>> getKnownBlocks() {
                return BuiltInRegistries.BLOCK.listElements().filter(holder -> holder.getKey().location().getNamespace().equals(this.modId) && !holder.getKey().location().getPath().equals("piton") && !holder.getKey().location().getPath().equals("dynamite"));
            }

            protected Stream<? extends Holder<Item>> getKnownItems() {
                return BuiltInRegistries.ITEM.listElements().filter(holder -> holder.getKey().location().getNamespace().equals(this.modId) && !holder.getKey().location().getPath().equals("dynamite"));
            }

            protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
                this.generateAncientStatue(blockModels, itemModels, (Block)PeakBlocks.ANCIENT_STATUE.get(), Blocks.STONE);
                this.generateAncientStatue(blockModels, itemModels, (Block)PeakBlocks.SANDY_ANCIENT_STATUE.get(), Blocks.STONE);
                this.generateAncientStatue(blockModels, itemModels, (Block)PeakBlocks.MOSSY_ANCIENT_STATUE.get(), Blocks.STONE);
                this.generateAncientStatue(blockModels, itemModels, (Block)PeakBlocks.SNOWY_ANCIENT_STATUE.get(), Blocks.STONE);
                this.generateAncientStatue(blockModels, itemModels, (Block)PeakBlocks.DESERT_ANCIENT_STATUE.get(), Blocks.STONE);
                this.generateAncientStatue(blockModels, itemModels, (Block)PeakBlocks.CHARRED_ANCIENT_STATUE.get(), Blocks.STONE);
                this.generateTintedAncientStatue(blockModels, itemModels, (Block)PeakBlocks.ANCIENT_STATUE.get(), (Block)PeakBlocks.GRASSY_ANCIENT_STATUE.get(), Blocks.STONE);
                blockModels.createCrossBlockWithDefaultItem((Block)PeakBlocks.EXPLOSIVE_BULB.get(), BlockModelGenerators.PlantType.NOT_TINTED);
                itemModels.generateFlatItem(PeakBlocks.PITON.asItem(), ModelTemplates.FLAT_ITEM);
                itemModels.generateFlatItem((Item)PeakItems.MARSHMALLOW.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
                itemModels.generateFlatItem((Item)PeakItems.COOKED_MARSHMALLOW.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
                itemModels.generateFlatItem((Item)PeakItems.BANDAGES.get(), ModelTemplates.FLAT_ITEM);
                itemModels.generateFlatItem((Item)PeakItems.COOKED_BANDAGES.get(), ModelTemplates.FLAT_ITEM);
                itemModels.generateFlatItem((Item)PeakItems.FIRST_AID_KIT.get(), ModelTemplates.FLAT_ITEM);
                itemModels.generateFlatItem((Item)PeakItems.COOKED_FIRST_AID_KIT.get(), ModelTemplates.FLAT_ITEM);
                itemModels.generateFlatItem((Item)PeakItems.ANTIDOTE.get(), ModelTemplates.FLAT_ITEM);
                itemModels.generateFlatItem((Item)PeakItems.COOKED_ANTIDOTE.get(), ModelTemplates.FLAT_ITEM);
                itemModels.generateFlatItem((Item)PeakItems.BIG_LOLLIPOP.get(), ModelTemplates.FLAT_ITEM);
                itemModels.generateFlatItem((Item)PeakItems.COOKED_BIG_LOLLIPOP.get(), ModelTemplates.FLAT_ITEM);
                this.generateBlowgun(itemModels, (Item)PeakItems.BLOWGUN.get());
                itemModels.generateFlatItem((Item)PeakItems.SCOUT_EFFIGY.get(), ModelTemplates.FLAT_ITEM);
                itemModels.itemModelOutput.accept((Item)PeakItems.BING_BONG.get(), ItemModelUtils.plainModel((ResourceLocation)BING_BONG.create(ModelLocationUtils.getModelLocation((Item)((Item)PeakItems.BING_BONG.get())), TextureMapping.defaultTexture((ResourceLocation)TextureMapping.getItemTexture((Item)((Item)PeakItems.BING_BONG.get()))), itemModels.modelOutput)));
                itemModels.itemModelOutput.accept((Item)PeakItems.ANCIENT_IDOL.get(), ItemModelUtils.plainModel((ResourceLocation)BING_BONG.create(ModelLocationUtils.getModelLocation((Item)((Item)PeakItems.ANCIENT_IDOL.get())), TextureMapping.defaultTexture((ResourceLocation)TextureMapping.getItemTexture((Item)((Item)PeakItems.ANCIENT_IDOL.get()))), itemModels.modelOutput)));
            }

            private void generateAncientStatue(BlockModelGenerators blockModels, ItemModelGenerators itemModels, Block block, Block particle) {
                MultiVariant lower = BlockModelGenerators.plainVariant((ResourceLocation)5.lower(particle).createWithSuffix(block, "_lower", blockModels.modelOutput));
                MultiVariant upper = BlockModelGenerators.plainVariant((ResourceLocation)5.upper(particle).createWithSuffix(block, "_upper", blockModels.modelOutput));
                MultiVariant broken = BlockModelGenerators.plainVariant((ResourceLocation)5.upperBroken(particle).createWithSuffix(block, "_upper_broken", blockModels.modelOutput));
                blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with((PropertyDispatch)PropertyDispatch.initial((Property)AncientStatueBlock.FACING, AncientStatueBlock.HALF, (Property)AncientStatueBlock.BROKEN).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(false), (Object)lower).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(false), (Object)lower.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(false), (Object)lower.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(false), (Object)lower.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(true), (Object)lower).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(true), (Object)lower.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(true), (Object)lower.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(true), (Object)lower.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(false), (Object)upper).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(false), (Object)upper.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(false), (Object)upper.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(false), (Object)upper.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(true), (Object)broken).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(true), (Object)broken.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(true), (Object)broken.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(true), (Object)broken.with(BlockModelGenerators.Y_ROT_270))));
                itemModels.generateFlatItem(block.asItem(), ModelTemplates.FLAT_ITEM);
            }

            private void generateTintedAncientStatue(BlockModelGenerators blockModels, ItemModelGenerators itemModels, Block base, Block block, Block particle) {
                MultiVariant lower = BlockModelGenerators.plainVariant((ResourceLocation)5.tintedLower(base, particle).createWithSuffix(block, "_lower", blockModels.modelOutput));
                MultiVariant upper = BlockModelGenerators.plainVariant((ResourceLocation)5.tintedUpper(base, particle).createWithSuffix(block, "_upper", blockModels.modelOutput));
                MultiVariant broken = BlockModelGenerators.plainVariant((ResourceLocation)5.tintedUpperBroken(base, particle).createWithSuffix(block, "_upper_broken", blockModels.modelOutput));
                blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with((PropertyDispatch)PropertyDispatch.initial((Property)AncientStatueBlock.FACING, AncientStatueBlock.HALF, (Property)AncientStatueBlock.BROKEN).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(false), (Object)lower).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(false), (Object)lower.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(false), (Object)lower.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(false), (Object)lower.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(true), (Object)lower).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(true), (Object)lower.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(true), (Object)lower.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)Boolean.valueOf(true), (Object)lower.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(false), (Object)upper).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(false), (Object)upper.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(false), (Object)upper.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(false), (Object)upper.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(true), (Object)broken).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(true), (Object)broken.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(true), (Object)broken.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)Boolean.valueOf(true), (Object)broken.with(BlockModelGenerators.Y_ROT_270))));
                itemModels.generateFlatItem(block.asItem(), ModelTemplates.FLAT_ITEM);
            }

            private static TextureMapping defaultTextureAndParticle(Block block, Block particle) {
                return new TextureMapping().put(TextureSlot.TEXTURE, TextureMapping.getBlockTexture((Block)block)).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)particle));
            }

            private static TextureMapping defaultTextureAndTintAndParticle(Block base, Block block, Block particle) {
                return new TextureMapping().put(TextureSlot.TEXTURE, TextureMapping.getBlockTexture((Block)base)).put(TINT, TextureMapping.getBlockTexture((Block)block)).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)particle));
            }

            private static TexturedModel.Provider lower(Block particle) {
                return block1 -> new TexturedModel(5.defaultTextureAndParticle(block1, particle), ANCIENT_STATUE_LOWER);
            }

            private static TexturedModel.Provider upper(Block particle) {
                return block1 -> new TexturedModel(5.defaultTextureAndParticle(block1, particle), ANCIENT_STATUE_UPPER);
            }

            private static TexturedModel.Provider upperBroken(Block particle) {
                return block1 -> new TexturedModel(5.defaultTextureAndParticle(block1, particle), ANCIENT_STATUE_UPPER_BROKEN);
            }

            private static TexturedModel.Provider tintedLower(Block base, Block particle) {
                return block1 -> new TexturedModel(5.defaultTextureAndTintAndParticle(base, block1, particle), ANCIENT_STATUE_TINTED_LOWER);
            }

            private static TexturedModel.Provider tintedUpper(Block base, Block particle) {
                return block1 -> new TexturedModel(5.defaultTextureAndTintAndParticle(base, block1, particle), ANCIENT_STATUE_TINTED_UPPER);
            }

            private static TexturedModel.Provider tintedUpperBroken(Block base, Block particle) {
                return block1 -> new TexturedModel(5.defaultTextureAndTintAndParticle(base, block1, particle), ANCIENT_STATUE_TINTED_UPPER_BROKEN);
            }

            public void generateBlowgun(ItemModelGenerators itemModels, Item item) {
                ItemModel.Unbaked normal = ItemModelUtils.plainModel((ResourceLocation)BLOWGUN.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.defaultTexture((ResourceLocation)TextureMapping.getItemTexture((Item)item)), itemModels.modelOutput));
                ItemModel.Unbaked blowing = ItemModelUtils.plainModel((ResourceLocation)BLOWGUN_BLOWING.create(ModelLocationUtils.getModelLocation((Item)item).withPath(path -> path + "_blowing"), TextureMapping.defaultTexture((ResourceLocation)TextureMapping.getItemTexture((Item)item)), itemModels.modelOutput));
                itemModels.itemModelOutput.accept(item, ItemModelUtils.conditional((ConditionalItemModelProperty)ItemModelUtils.isUsingItem(), (ItemModel.Unbaked)blowing, (ItemModel.Unbaked)normal));
            }
        });
        event.createProvider(output -> new LanguageProvider(output, "peak", "en_us"){

            protected void addTranslations() {
                this.add((Block)PeakBlocks.PITON.get(), "Piton");
                this.add((Block)PeakBlocks.ANCIENT_STATUE.get(), "Ancient Statue");
                this.add((Block)PeakBlocks.SANDY_ANCIENT_STATUE.get(), "Sandy Ancient Statue");
                this.add((Block)PeakBlocks.MOSSY_ANCIENT_STATUE.get(), "Mossy Ancient Statue");
                this.add((Block)PeakBlocks.SNOWY_ANCIENT_STATUE.get(), "Snowy Ancient Statue");
                this.add((Block)PeakBlocks.DESERT_ANCIENT_STATUE.get(), "Desert Ancient Statue");
                this.add((Block)PeakBlocks.CHARRED_ANCIENT_STATUE.get(), "Charred Ancient Statue");
                this.add((Block)PeakBlocks.GRASSY_ANCIENT_STATUE.get(), "Grassy Ancient Statue");
                this.add((Block)PeakBlocks.EXPLOSIVE_BULB.get(), "Explosive Bulb");
                this.add((Block)PeakBlocks.DYNAMITE.get(), "Dynamite");
                this.add((Item)PeakItems.MARSHMALLOW.get(), "Marshmallow");
                this.add((Item)PeakItems.COOKED_MARSHMALLOW.get(), "Cooked Marshmallow");
                this.add((Item)PeakItems.BANDAGES.get(), "Bandages");
                this.add((Item)PeakItems.COOKED_BANDAGES.get(), "Cooked Bandages");
                this.add((Item)PeakItems.FIRST_AID_KIT.get(), "First Aid Kit");
                this.add((Item)PeakItems.COOKED_FIRST_AID_KIT.get(), "Cooked First Aid Kit");
                this.add((Item)PeakItems.ANTIDOTE.get(), "Antidote");
                this.add((Item)PeakItems.COOKED_ANTIDOTE.get(), "Cooked Antidote");
                this.add((Item)PeakItems.BIG_LOLLIPOP.get(), "Big Lollipop");
                this.add((Item)PeakItems.COOKED_BIG_LOLLIPOP.get(), "Cooked Big Lollipop");
                this.add((Item)PeakItems.BLOWGUN.get(), "Blowgun");
                this.add((Item)PeakItems.SCOUT_EFFIGY.get(), "Scout Effigy");
                this.add((Item)PeakItems.BING_BONG.get(), "Bing Bong");
                this.add((Item)PeakItems.ANCIENT_IDOL.get(), "Ancient Idol");
                this.add(PeakCreativeModeTabs.PEAK.getId().toLanguageKey("itemGroup"), "PEAK");
                this.add((EntityType)PeakEntityTypes.UNCONSCIOUS_SCOUT.get(), "Unconscious Scout");
                this.add((EntityType)PeakEntityTypes.FALLEN_SCOUT.get(), "Fallen Scout");
                this.add("gui.tooltip.lunge", "Press %s to lunge");
                this.add("gui.tooltip.place_piton", "Press %s to place piton");
                this.add("gui.tooltip.grab_piton", "Press %s to grab piton");
                this.add("gui.tooltip.cannibalism", "Hold %s to eat");
                this.add("gui.death.give_up", "Give up: %s");
                this.add("gui.death.ghost", "You are a ghost.");
                this.add("gui.death.revive", "Get revived at the statue.");
                this.add("peakBiome.shore", "Shore");
                this.add("peakBiome.tropics", "Tropics");
                this.add("peakBiome.alpine", "Alpine");
                this.add("peakBiome.mesa", "Mesa");
                this.add("peakBiome.caldera", "Caldera");
                this.add("peakBiome.kiln", "The Kiln");
                this.add("peakBiome.peak", "Peak");
            }
        });
    }
}

