/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.stamina.AfflictionTypes;
import net.tintankgames.peak.stamina.StaminaBar;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CakeBlock.class})
public abstract class CakeBlockMixin {
    @Shadow
    @Final
    public static IntegerProperty BITES;

    @Inject(at={@At(value="HEAD")}, method={"eat"}, cancellable=true)
    private static void haveMyCakeAndEatItToo(LevelAccessor levelAccessor, BlockPos pos, BlockState state, Player player, CallbackInfoReturnable<InteractionResult> cir) {
        if (!player.canEat(false)) {
            cir.setReturnValue((Object)InteractionResult.PASS);
        } else {
            player.awardStat(Stats.EAT_CAKE_SLICE);
            if (player instanceof ServerPlayer) {
                ((StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR)).removeStatus(AfflictionTypes.HUNGER, 0.05f);
                ((StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR)).removeStatus(AfflictionTypes.DROWSY, 0.075f);
                ((StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR)).addExtraStamina(0.05f);
                player.setData(PeakAttachmentTypes.INFINITE_TIMER, (Object)((Integer)player.getData(PeakAttachmentTypes.INFINITE_TIMER) + 40));
            }
            int i = (Integer)state.getValue((Property)BITES);
            levelAccessor.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
            if (i < 6) {
                levelAccessor.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
            } else {
                levelAccessor.removeBlock(pos, false);
                levelAccessor.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }
}

