/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.mixin;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;
import net.tintankgames.peak.world.item.ScoutEffigyItem;
import net.tintankgames.peak.world.level.block.PitonBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CommonHooks.class}, remap=false)
public abstract class CommonHooksMixin {
    @Inject(at={@At(value="HEAD")}, method={"onPlaceItemIntoWorld"}, cancellable=true)
    private static void placeInAdventure(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        BlockItem blockItem;
        Item item;
        ItemStack stack = context.getItemInHand();
        if (stack.getItem() instanceof ScoutEffigyItem || (item = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof PitonBlock) {
            AdventureModePredicate adventureModePredicate;
            Level level = context.getLevel();
            Player player = context.getPlayer();
            if (player != null && !player.getAbilities().mayBuild && (adventureModePredicate = (AdventureModePredicate)stack.get(DataComponents.CAN_PLACE_ON)) != null && !adventureModePredicate.test(new BlockInWorld((LevelReader)level, context.getClickedPos(), false))) {
                cir.setReturnValue((Object)InteractionResult.PASS);
            }
            Item item2 = stack.getItem();
            int size = stack.getCount();
            DataComponentMap components = stack.getComponents();
            if (!(stack.getItem() instanceof BucketItem)) {
                level.captureBlockSnapshots = true;
            }
            ItemStack copy = stack.copy();
            InteractionResult ret = stack.getItem().useOn(context);
            if (stack.isEmpty()) {
                EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)context.getHand());
            }
            level.captureBlockSnapshots = false;
            if (ret.consumesAction()) {
                int newSize = stack.getCount();
                DataComponentMap newComponents = stack.getComponents();
                List blockSnapshots = (List)level.capturedBlockSnapshots.clone();
                level.capturedBlockSnapshots.clear();
                stack.setCount(size);
                stack.applyComponents(components);
                Direction side = context.getClickedFace();
                boolean eventResult = false;
                if (blockSnapshots.size() > 1) {
                    eventResult = EventHooks.onMultiBlockPlace((Entity)player, (List)blockSnapshots, (Direction)side);
                } else if (blockSnapshots.size() == 1) {
                    eventResult = EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)((BlockSnapshot)blockSnapshots.get(0)), (Direction)side);
                }
                if (eventResult) {
                    ret = InteractionResult.FAIL;
                    for (BlockSnapshot blocksnapshot : Lists.reverse((List)blockSnapshots)) {
                        level.restoringBlockSnapshots = true;
                        blocksnapshot.restore(blocksnapshot.getFlags() | 2);
                        level.restoringBlockSnapshots = false;
                    }
                } else {
                    stack.setCount(newSize);
                    stack.applyComponents(newComponents);
                    for (BlockSnapshot snap : blockSnapshots) {
                        int updateFlag = snap.getFlags();
                        BlockState oldBlock = snap.getState();
                        BlockState newBlock = level.getBlockState(snap.getPos());
                        newBlock.onPlace(level, snap.getPos(), oldBlock, false);
                        level.markAndNotifyBlock(snap.getPos(), level.getChunkAt(snap.getPos()), oldBlock, newBlock, updateFlag, 512);
                    }
                    if (player != null) {
                        player.awardStat(Stats.ITEM_USED.get((Object)item2));
                    }
                }
            }
            level.capturedBlockSnapshots.clear();
            cir.setReturnValue((Object)ret);
        }
    }
}

